/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer;

import aQute.lib.utf8properties.UTF8Properties;
import java.util.Map;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformerLoggerFactory {
    public final Transformer transformer;
    public LoggerSettings settings;
    protected static final String SIMPLE_LOGGER_PROPERTY_PREFIX = "org.slf4j.simpleLogger.";

    public TransformerLoggerFactory(Transformer transformer) {
        this.transformer = transformer;
        this.settings = new LoggerSettings(this.transformer);
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public LoggerSettings getSettings() {
        return this.settings;
    }

    protected void verboseOutput(String message, Object ... parms) {
        if (this.settings.isVerbose) {
            this.transformer.outputPrint(message, parms);
        }
    }

    protected void normalOutput(String message, Object ... parms) {
        if (!this.settings.isVerbose && !this.settings.isTerse) {
            this.transformer.outputPrint(message, parms);
        }
    }

    protected void nonTerseOutput(String message, Object ... parms) {
        if (!this.settings.isTerse) {
            this.transformer.outputPrint(message, parms);
        }
    }

    protected void terseOutput(String message, Object ... parms) {
        if (this.settings.isTerse) {
            this.transformer.outputPrint(message, parms);
        }
    }

    public Logger createLogger() throws TransformException {
        this.setLoggingProperties();
        String logName = this.selectLoggerName();
        return LoggerFactory.getLogger(logName);
    }

    protected void setLoggingProperties() throws TransformException {
        if (this.settings.logFileName != null) {
            this.setLoggingProperty(LoggerProperty.LOG_FILE.getPropertyName(), this.settings.logFileName);
        }
        if (this.settings.logLevel != null) {
            this.setLoggingProperty(LoggerProperty.LOG_LEVEL_ROOT.getPropertyName(), this.settings.logLevel);
        }
        if (this.settings.properties != null) {
            for (String propertyAssignment : this.settings.properties) {
                this.assignLoggingProperty(propertyAssignment);
            }
        }
        if (this.settings.propertyFileName != null) {
            UTF8Properties properties;
            try {
                properties = this.transformer.loadExternalProperties("Logging Properties File", this.settings.propertyFileName);
            }
            catch (Exception e) {
                throw new TransformException("Failed to load logging properties [ " + this.settings.propertyFileName + " ]", e);
            }
            for (Map.Entry<Object, Object> propertyEntry : properties.entrySet()) {
                String propertyName = propertyEntry.getKey().toString();
                String propertyValue = propertyEntry.getValue().toString();
                this.setLoggingProperty(propertyName, propertyValue);
            }
        }
        if (!this.settings.isTerse && this.settings.isVerbose) {
            this.nonTerseOutput("Verbose output requested", new Object[0]);
        }
    }

    protected String selectLoggerName() {
        String logName;
        String logNameCase;
        if (this.settings.logName == null) {
            logNameCase = "Defaulted";
            logName = Transformer.class.getSimpleName();
        } else {
            logNameCase = "Assigned";
            logName = this.settings.logName;
        }
        this.nonTerseOutput("Logger name [ %s ] (%s)", logName, logNameCase);
        return logName;
    }

    protected String completePropertyName(String propertyName) {
        if (propertyName.startsWith(SIMPLE_LOGGER_PROPERTY_PREFIX)) {
            return null;
        }
        if (propertyName.contains(".")) {
            return null;
        }
        return SIMPLE_LOGGER_PROPERTY_PREFIX + propertyName;
    }

    protected String[] parseAssignment(String propertyAssignment) {
        int equalsOffset = propertyAssignment.indexOf("=");
        if (equalsOffset == -1) {
            return null;
        }
        String propertyName = propertyAssignment.substring(0, equalsOffset);
        String propertyValue = propertyAssignment.substring(equalsOffset + 1);
        if (propertyName.isEmpty() || propertyValue.isEmpty()) {
            return null;
        }
        return new String[]{propertyName, propertyValue};
    }

    protected void assignLoggingProperty(String propertyAssignment) throws TransformException {
        String[] assignmentValues = this.parseAssignment(propertyAssignment);
        if (assignmentValues == null) {
            throw new TransformException("Malformed logger property assignment [ " + propertyAssignment + " ]");
        }
        String propertyName = assignmentValues[0];
        String propertyValue = assignmentValues[1];
        String completedPropertyName = this.completePropertyName(propertyName);
        if (completedPropertyName != null) {
            this.verboseOutput("Transformer logging property adjusted from [ %s ] to [ %s ]", propertyName, completedPropertyName, propertyValue);
        } else {
            completedPropertyName = propertyName;
        }
        this.setLoggingProperty(completedPropertyName, propertyValue);
    }

    protected void setLoggingProperty(String propertyName, String newPropertyValue) {
        String oldPropertyValue = System.getProperty(propertyName);
        if (oldPropertyValue != null) {
            this.nonTerseOutput("Blocked assignment of logging property [ %s ] to [ %s ] by prior value [ %s ]", propertyName, newPropertyValue, oldPropertyValue);
        } else {
            System.setProperty(propertyName, newPropertyValue);
            this.nonTerseOutput("Assigning logging property [ %s ] to [ %s ]", propertyName, newPropertyValue);
        }
    }

    public static boolean logToSysOut() {
        String logFile = System.getProperty(LoggerProperty.LOG_FILE.getPropertyName());
        return logFile != null && logFile.equals("System.out");
    }

    public static boolean logToSysErr() {
        String logFile = System.getProperty(LoggerProperty.LOG_FILE.getPropertyName());
        return logFile == null || logFile.equals("System.err");
    }

    public static enum LoggerProperty {
        LOG_FILE("org.slf4j.simpleLogger.logFile"),
        LOG_CACHE_OUTPUT("org.slf4j.simpleLogger.cacheOutputStream"),
        LOG_LEVEL_ROOT("org.slf4j.simpleLogger.defaultLogLevel"),
        LOG_LEVEL_CHILD("org.slf4j.simpleLogger.log.a.b.c"),
        LOG_LEVEL_IN_BRACkETS("org.slf4j.simpleLogger.levelInBrackets"),
        LOG_SHOW_DATE_TIME("org.slf4j.simpleLogger.showDateTime"),
        LOG_DATE_TIME_FORMAT("org.slf4j.simpleLogger.dateTimeFormat"),
        LOG_SHOW_THREAD_NAME("org.slf4j.simpleLogger.showThreadName"),
        LOG_SHOW_LOG_NAME("org.slf4j.simpleLogger.showLogName"),
        LOG_SHOW_SHORT_LOG_NAME("org.slf4j.simpleLogger.showShortLogName"),
        LOG_WARN_STRING("org.slf4j.simpleLogger.warnLevelString");

        private final String propertyName;

        private LoggerProperty(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }

    public static class LoggerSettings {
        public final boolean isTerse;
        public final boolean isVerbose;
        public final String[] properties;
        public final String propertyFileName;
        public final String logName;
        public final String logLevel;
        public final String logFileName;

        public LoggerSettings(Transformer transformer) {
            this.isTerse = transformer.hasOption(Transformer.AppOption.LOG_TERSE);
            this.isVerbose = transformer.hasOption(Transformer.AppOption.LOG_VERBOSE);
            this.properties = transformer.getOptionValues(Transformer.AppOption.LOG_PROPERTY);
            this.propertyFileName = transformer.getOptionValue(Transformer.AppOption.LOG_PROPERTY_FILE, Transformer.DO_NORMALIZE);
            this.logName = transformer.getOptionValue(Transformer.AppOption.LOG_NAME);
            this.logLevel = transformer.getOptionValue(Transformer.AppOption.LOG_LEVEL);
            this.logFileName = transformer.getOptionValue(Transformer.AppOption.LOG_FILE, Transformer.DO_NORMALIZE);
        }
    }
}

