/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer.eclipse;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.transformer.Transformer;
import org.eclipse.transformer.action.Changes;
import org.wildfly.extras.transformer.ArchiveTransformer;

final class ArchiveTransformerImpl
extends ArchiveTransformer {
    public static final String DEFAULT_RENAMES_REFERENCE = "jakarta-renames.properties";
    public static final String DEFAULT_MASTER_TXT_REFERENCE = "jakarta-txt-master.properties";
    public static final String DEFAULT_PER_CLASS_REFERENCE = "jakarta-per-class.properties";
    public static final String DEFAULT_DIRECT_REFERENCE = "jakarta-direct.properties";

    ArchiveTransformerImpl(File configsDir, boolean verbose) {
        super(configsDir, verbose);
    }

    private Map<Transformer.AppOption, String> getOptionDefaults() {
        HashMap<Transformer.AppOption, String> optionDefaults = new HashMap<Transformer.AppOption, String>();
        optionDefaults.put(Transformer.AppOption.RULES_RENAMES, DEFAULT_RENAMES_REFERENCE);
        optionDefaults.put(Transformer.AppOption.RULES_MASTER_TEXT, DEFAULT_MASTER_TXT_REFERENCE);
        optionDefaults.put(Transformer.AppOption.RULES_PER_CLASS_CONSTANT, DEFAULT_PER_CLASS_REFERENCE);
        optionDefaults.put(Transformer.AppOption.RULES_DIRECT, DEFAULT_DIRECT_REFERENCE);
        return optionDefaults;
    }

    @Override
    public boolean transform(File inJarFile, File outJarFile) {
        boolean transformed;
        try {
            if (!this.verbose) {
                System.setProperty("org.slf4j.simpleLogger.log.Transformer", "error");
            }
            ArrayList<String> args = new ArrayList<String>();
            if (this.configsDir != null) {
                File configFile = new File(this.configsDir, DEFAULT_RENAMES_REFERENCE);
                if (configFile.exists() && configFile.isFile()) {
                    args.add("-tr");
                    args.add(configFile.getAbsolutePath());
                }
                if ((configFile = new File(this.configsDir, DEFAULT_MASTER_TXT_REFERENCE)).exists() && configFile.isFile()) {
                    args.add("-tf");
                    args.add(configFile.getAbsolutePath());
                }
                if ((configFile = new File(this.configsDir, DEFAULT_PER_CLASS_REFERENCE)).exists() && configFile.isFile()) {
                    args.add("-tp");
                    args.add(configFile.getAbsolutePath());
                }
                if ((configFile = new File(this.configsDir, DEFAULT_DIRECT_REFERENCE)).exists() && configFile.isFile()) {
                    args.add("-td");
                    args.add(configFile.getAbsolutePath());
                }
            }
            args.add(inJarFile.getAbsolutePath());
            args.add(outJarFile.getAbsolutePath());
            if (this.verbose) {
                args.add("-v");
            } else {
                args.add("--quiet");
            }
            String[] array = new String[args.size()];
            transformed = this.transform(args.toArray(array), true);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return transformed;
    }

    private boolean transform(String[] args, boolean silent) throws IOException {
        ByteArrayOutputStream devNull = new ByteArrayOutputStream();
        Transformer jTrans = silent ? new Transformer(new PrintStream(devNull), new PrintStream(devNull)) : new Transformer(System.out, System.err);
        jTrans.setOptionDefaults(ArchiveTransformerImpl.class, this.getOptionDefaults());
        jTrans.setArgs(args);
        int rc = jTrans.run();
        if (rc != 0) {
            throw new IOException("Error occurred during transformation. Error code " + rc);
        }
        Changes changes = jTrans.getLastActiveChanges();
        if (changes != null) {
            return changes.hasChanges();
        }
        return false;
    }

    @Override
    public boolean canTransformIndividualClassFile() {
        return true;
    }
}

