/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.transformer.TransformProperties;
import org.eclipse.transformer.action.SelectionRule;
import org.slf4j.Logger;

public class SelectionRuleImpl
implements SelectionRule {
    private final Logger logger;
    private final Set<String> included;
    private final Set<String> includedExact;
    private final Set<String> includedHead;
    private final Set<String> includedTail;
    private final Set<String> includedAny;
    private final Set<String> excluded;
    private final Set<String> excludedExact;
    private final Set<String> excludedHead;
    private final Set<String> excludedTail;
    private final Set<String> excludedAny;

    public SelectionRuleImpl(Logger logger, Set<String> includes, Set<String> excludes) {
        this.logger = logger;
        if (includes == null) {
            this.included = Collections.emptySet();
            this.includedExact = Collections.emptySet();
            this.includedHead = Collections.emptySet();
            this.includedTail = Collections.emptySet();
            this.includedAny = Collections.emptySet();
        } else {
            this.included = new HashSet<String>(includes);
            this.includedExact = new HashSet<String>();
            this.includedHead = new HashSet<String>();
            this.includedTail = new HashSet<String>();
            this.includedAny = new HashSet<String>();
            TransformProperties.processSelections(this.included, this.includedExact, this.includedHead, this.includedTail, this.includedAny);
        }
        if (excludes == null) {
            this.excluded = Collections.emptySet();
            this.excludedExact = Collections.emptySet();
            this.excludedHead = Collections.emptySet();
            this.excludedTail = Collections.emptySet();
            this.excludedAny = Collections.emptySet();
        } else {
            this.excluded = new HashSet<String>(excludes);
            this.excludedExact = new HashSet<String>();
            this.excludedHead = new HashSet<String>();
            this.excludedTail = new HashSet<String>();
            this.excludedAny = new HashSet<String>();
            TransformProperties.processSelections(this.excluded, this.excludedExact, this.excludedHead, this.excludedTail, this.excludedAny);
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void debug(String message, Object ... parms) {
        this.getLogger().debug(message, parms);
    }

    @Override
    public boolean select(String resourceName) {
        boolean isIncluded = this.selectIncluded(resourceName);
        boolean isExcluded = this.rejectExcluded(resourceName);
        return isIncluded && !isExcluded;
    }

    @Override
    public boolean selectIncluded(String resourceName) {
        if (this.included.isEmpty()) {
            this.debug("Include [ {} ]: {}", resourceName, "No includes");
            return true;
        }
        if (this.includedExact.contains(resourceName)) {
            this.debug("Include [ {} ]: {}", resourceName, "Exact include");
            return true;
        }
        for (String tail : this.includedHead) {
            if (!resourceName.endsWith(tail)) continue;
            this.debug("Include [ {} ]: {} ({})", resourceName, "Match tail", tail);
            return true;
        }
        for (String head : this.includedTail) {
            if (!resourceName.startsWith(head)) continue;
            this.debug("Include [ {} ]: {} ({})", resourceName, "Match head", head);
            return true;
        }
        for (String middle : this.includedAny) {
            if (!resourceName.contains(middle)) continue;
            this.debug("Include [ {} ]: {} ({})", resourceName, "Match middle", middle);
            return true;
        }
        this.debug("Do not include [ {} ]", resourceName);
        return false;
    }

    @Override
    public boolean rejectExcluded(String resourceName) {
        if (this.excluded.isEmpty()) {
            this.debug("Do not exclude[ {} ]: {}", resourceName, "No excludes");
            return false;
        }
        if (this.excludedExact.contains(resourceName)) {
            this.debug("Exclude [ {} ]: {}", resourceName, "Exact exclude");
            return true;
        }
        for (String tail : this.excludedHead) {
            if (!resourceName.endsWith(tail)) continue;
            this.debug("Exclude[ {} ]: {} ({})", resourceName, "Match tail", tail);
            return true;
        }
        for (String head : this.excludedTail) {
            if (!resourceName.startsWith(head)) continue;
            this.debug("Exclude[ {} ]: {} ({})", resourceName, "Match head", head);
            return true;
        }
        for (String middle : this.excludedAny) {
            if (!resourceName.contains(middle)) continue;
            this.debug("Exclude[ {} ]: {} ({})", resourceName, "Match middle", middle);
            return true;
        }
        this.debug("Do not exclude [ {} ]", resourceName);
        return false;
    }
}

