/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import nu.xom.ParsingException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.FeaturePackLayoutDescriber;
import org.jboss.galleon.maven.plugin.FpMavenErrors;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.spec.PackageSpec;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.PathFilter;
import org.jboss.galleon.util.StringUtils;
import org.jboss.galleon.util.ZipUtils;
import org.jboss.galleon.xml.FeaturePackXmlWriter;
import org.jboss.galleon.xml.PackageXmlParser;
import org.jboss.galleon.xml.PackageXmlWriter;
import org.wildfly.galleon.maven.FeaturePackDependencySpec;
import org.wildfly.galleon.maven.MavenProjectArtifactVersions;
import org.wildfly.galleon.maven.ModuleIdentifier;
import org.wildfly.galleon.maven.ModuleParseResult;
import org.wildfly.galleon.maven.ModuleXmlParser;
import org.wildfly.galleon.maven.Util;
import org.wildfly.galleon.maven.WildFlyFeaturePackBuild;

@Mojo(name="build-feature-pack", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.COMPILE)
public class WfFeaturePackBuildMojo
extends AbstractMojo {
    private static Pattern windowsLineEndingPattern = Pattern.compile("(?<!\\r)\\n", 8);
    private static Pattern linuxLineEndingPattern = Pattern.compile("\\r\\n", 8);
    private static PathFilter windowsLineEndingsPathFilter = new PathFilter(){

        public boolean accept(Path path) {
            return path.getFileName().toString().endsWith(".bat");
        }
    };
    private static PathFilter linuxLineEndingsPathFilter = new PathFilter(){

        public boolean accept(Path path) {
            String name = path.getFileName().toString();
            return name.endsWith(".sh") || name.endsWith(".conf");
        }
    };
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Parameter(alias="config-file", defaultValue="wildfly-feature-pack-build.xml", property="wildfly.feature.pack.configFile")
    private String configFile;
    @Parameter(alias="config-dir", defaultValue="${basedir}", property="wildfly.feature.pack.configDir")
    private File configDir;
    @Parameter(alias="resources-dir", defaultValue="src/main/resources", property="wildfly.feature.pack.resourcesDir", required=true)
    private String resourcesDir;
    @Parameter(defaultValue="${project.build.directory}", property="wildfly.feature.pack.buildName")
    private String buildName;
    @Parameter(alias="release-name", defaultValue="${product.release.name}", required=true)
    private String releaseName;
    @Parameter(alias="feature-pack-artifact-id", defaultValue="${project.artifactId}", required=false)
    private String fpArtifactId;
    @Component
    private MavenProjectHelper projectHelper;
    private MavenProjectArtifactVersions artifactVersions;
    private WildFlyFeaturePackBuild wfFpConfig;
    private Map<String, FeaturePackLayout> fpDependencies = Collections.emptyMap();
    private Map<String, PackageSpec.Builder> extendedPackages = Collections.emptyMap();

    private static boolean isProvided(String module) {
        return module.startsWith("java.") || module.startsWith("jdk.") || module.equals("org.jboss.modules");
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.doExecute();
    }

    private void doExecute() throws MojoExecutionException, MojoFailureException {
        this.artifactVersions = MavenProjectArtifactVersions.getInstance(this.project);
        if (!this.resourcesDir.isEmpty()) {
            switch (this.resourcesDir.charAt(0)) {
                case '/': 
                case '\\': {
                    break;
                }
                default: {
                    this.resourcesDir = "/" + this.resourcesDir;
                }
            }
        }
        Path targetResources = Paths.get(this.buildName, "resources");
        Path specsDir = Paths.get(this.configDir.getAbsolutePath(), new String[0]).resolve(this.resourcesDir);
        if (Files.exists(specsDir, new LinkOption[0])) {
            try {
                IoUtils.copy((Path)specsDir, (Path)targetResources);
            }
            catch (IOException e1) {
                throw new MojoExecutionException(Errors.copyFile((Path)specsDir, (Path)targetResources), (Exception)e1);
            }
        }
        Path workDir = Paths.get(this.buildName, "layout");
        IoUtils.recursiveDelete((Path)workDir);
        Path fpDir = workDir.resolve(this.project.getGroupId()).resolve(this.fpArtifactId).resolve(this.project.getVersion());
        Path fpPackagesDir = fpDir.resolve("packages");
        FeaturePackLayout.Builder fpBuilder = FeaturePackLayout.builder((FeaturePackSpec.Builder)FeaturePackSpec.builder((ArtifactCoords.Gav)ArtifactCoords.newGav((String)this.project.getGroupId(), (String)this.fpArtifactId, (String)this.project.getVersion())));
        try {
            this.wfFpConfig = Util.loadFeaturePackBuildConfig(this.getFPConfigFile());
        }
        catch (ProvisioningException e) {
            throw new MojoExecutionException("Failed to load feature-pack config file", (Exception)((Object)e));
        }
        for (String defaultPackage : this.wfFpConfig.getDefaultPackages()) {
            fpBuilder.getSpecBuilder().addDefaultPackage(defaultPackage);
        }
        try {
            this.processFeaturePackDependencies(fpBuilder.getSpecBuilder());
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to process dependencies", e);
        }
        Path srcModulesDir = targetResources.resolve("modules").resolve("system").resolve("layers").resolve("base");
        if (Files.exists(srcModulesDir, new LinkOption[0])) {
            this.addModulesAll(srcModulesDir, fpBuilder, targetResources, fpPackagesDir);
        } else {
            this.getLog().warn((CharSequence)("No modules found at " + srcModulesDir));
        }
        Path contentDir = targetResources.resolve("content");
        if (Files.exists(contentDir, new LinkOption[0])) {
            try {
                this.packageContent(fpBuilder, contentDir, fpPackagesDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to process content", (Exception)e);
            }
        }
        if (this.wfFpConfig.hasSchemaGroups()) {
            this.addDocsSchemas(fpPackagesDir, fpBuilder);
        }
        this.addConfigPackages(targetResources.resolve("packages"), fpDir.resolve("packages"), fpBuilder);
        PackageSpec.Builder docsBuilder = this.getExtendedPackage("docs", false);
        if (docsBuilder != null) {
            fpBuilder.getSpecBuilder().addDefaultPackage(WfFeaturePackBuildMojo.addPackage(fpPackagesDir, fpBuilder, docsBuilder).getName());
        }
        if (!this.fpDependencies.isEmpty() && !this.extendedPackages.isEmpty()) {
            for (Map.Entry<String, PackageSpec.Builder> entry2 : this.fpDependencies.entrySet()) {
                FeaturePackLayout fpDepLayout = (FeaturePackLayout)entry2.getValue();
                for (Map.Entry<String, PackageSpec.Builder> entry22 : this.extendedPackages.entrySet()) {
                    if (!fpDepLayout.hasPackage(entry22.getKey())) continue;
                    entry22.getValue().addPackageDep(entry2.getKey(), entry22.getKey());
                }
            }
        }
        for (Map.Entry<String, PackageSpec.Builder> entry3 : this.extendedPackages.entrySet()) {
            WfFeaturePackBuildMojo.addPackage(fpPackagesDir, fpBuilder, entry3.getValue());
        }
        if (this.wfFpConfig.hasConfigs()) {
            for (ConfigModel configModel : this.wfFpConfig.getConfigs()) {
                try {
                    fpBuilder.getSpecBuilder().addConfig(configModel);
                }
                catch (ProvisioningDescriptionException e) {
                    throw new MojoExecutionException("Failed to add config to the feature-pack", (Exception)((Object)e));
                }
            }
        }
        try {
            FeaturePackLayout fpLayout = fpBuilder.build();
            FeaturePackXmlWriter.getInstance().write((Object)fpLayout.getSpec(), fpDir.resolve("feature-pack.xml"));
        }
        catch (IOException | XMLStreamException | ProvisioningDescriptionException throwable) {
            throw new MojoExecutionException(Errors.writeFile((Path)fpDir.resolve("feature-pack.xml")), (Exception)throwable);
        }
        this.copyDirIfExists(targetResources.resolve("features"), fpDir.resolve("features"));
        this.copyDirIfExists(targetResources.resolve("feature_groups"), fpDir.resolve("feature_groups"));
        Artifact artifact = (Artifact)this.project.getPluginArtifactMap().get("org.wildfly.galleon-plugins:wildfly-galleon-maven-plugins");
        this.addWildFlyPlugin(fpDir, artifact);
        Path resourcesWildFly = fpDir.resolve("resources").resolve("wildfly");
        WfFeaturePackBuildMojo.mkdirs(resourcesWildFly);
        this.addConfigGenerator(resourcesWildFly, artifact);
        try {
            Map.Entry<String, PackageSpec.Builder> entry22;
            OutputStream out = Files.newOutputStream(resourcesWildFly.resolve("wildfly-tasks.properties"), new OpenOption[0]);
            entry22 = null;
            try {
                this.getFPConfigProperties().store(out, "WildFly feature-pack properties");
            }
            catch (Throwable throwable) {
                entry22 = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (entry22 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)entry22)).addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to store feature-pack properties", (Exception)e);
        }
        try {
            this.artifactVersions.store(resourcesWildFly.resolve("artifact-versions.properties"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to store artifact versions", (Exception)e);
        }
        Path scriptsDir = targetResources.resolve("scripts");
        if (Files.exists(scriptsDir, new LinkOption[0])) {
            if (!Files.isDirectory(scriptsDir, new LinkOption[0])) {
                throw new MojoExecutionException("scripts is not a directory");
            }
            try {
                IoUtils.copy((Path)scriptsDir, (Path)resourcesWildFly.resolve("scripts"));
            }
            catch (IOException e) {
                throw new MojoExecutionException(Errors.copyFile((Path)scriptsDir, (Path)resourcesWildFly.resolve("scripts")), (Exception)e);
            }
        }
        try (DirectoryStream<Path> wdStream = Files.newDirectoryStream(workDir, entry -> Files.isDirectory(entry, new LinkOption[0]));){
            for (Path groupDir : wdStream) {
                DirectoryStream<Path> groupStream = Files.newDirectoryStream(groupDir);
                Throwable throwable = null;
                try {
                    for (Path artifactDir : groupStream) {
                        String artifactId = artifactDir.getFileName().toString();
                        DirectoryStream<Path> artifactStream = Files.newDirectoryStream(artifactDir);
                        Throwable throwable2 = null;
                        try {
                            for (Path versionDir : artifactStream) {
                                Path target = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve(artifactId + '-' + versionDir.getFileName() + ".zip");
                                if (Files.exists(target, new LinkOption[0])) {
                                    IoUtils.recursiveDelete((Path)target);
                                }
                                ZipUtils.zip((Path)versionDir, (Path)target);
                                this.debug("Attaching feature-pack " + target + " as a project artifact", new Object[0]);
                                this.projectHelper.attachArtifact(this.project, "zip", target.toFile());
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (artifactStream == null) continue;
                            if (throwable2 != null) {
                                try {
                                    artifactStream.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            artifactStream.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (groupStream == null) continue;
                    if (throwable != null) {
                        try {
                            groupStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    groupStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create a feature-pack archives from the layout", (Exception)e);
        }
    }

    private static PackageSpec addPackage(Path fpPackagesDir, FeaturePackLayout.Builder fpBuilder, PackageSpec.Builder pkgBuilder) throws MojoExecutionException {
        PackageSpec pkg = pkgBuilder.build();
        fpBuilder.addPackage(pkg);
        WfFeaturePackBuildMojo.writeXml(pkg, fpPackagesDir.resolve(pkg.getName()));
        return pkg;
    }

    private PackageSpec.Builder getExtendedPackage(String name, boolean create) {
        PackageSpec.Builder pkgBuilder = this.extendedPackages.get(name);
        if (pkgBuilder == null) {
            if (!create) {
                return null;
            }
            pkgBuilder = PackageSpec.builder((String)name);
            this.extendedPackages = CollectionUtils.put(this.extendedPackages, (Object)name, (Object)pkgBuilder);
        }
        return pkgBuilder;
    }

    private void addModulesAll(Path srcModulesDir, FeaturePackLayout.Builder fpBuilder, Path targetResources, Path fpPackagesDir) throws MojoExecutionException {
        this.debug("WfFeaturePackBuildMojo adding modules.all", new Object[0]);
        PackageSpec.Builder modulesAll = this.getExtendedPackage("modules.all", true);
        try {
            Map<String, Path> moduleXmlByPkgName = this.findModules(srcModulesDir);
            if (moduleXmlByPkgName.isEmpty()) {
                throw new MojoExecutionException("Modules not found in " + srcModulesDir);
            }
            this.packageModules(fpBuilder, targetResources, moduleXmlByPkgName, fpPackagesDir, modulesAll);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to process modules content", (Exception)e);
        }
    }

    private void copyDirIfExists(Path srcDir, Path targetDir) throws MojoExecutionException {
        if (Files.exists(srcDir, new LinkOption[0])) {
            try {
                IoUtils.copy((Path)srcDir, (Path)targetDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException(Errors.copyFile((Path)srcDir, (Path)targetDir), (Exception)e);
            }
        }
    }

    private void addWildFlyPlugin(Path fpDir, Artifact mvnPluginsArtifact) throws MojoExecutionException {
        Path wfPlugInPath;
        Path pluginsDir = fpDir.resolve("plugins");
        WfFeaturePackBuildMojo.mkdirs(pluginsDir);
        try {
            wfPlugInPath = this.resolveArtifact(ArtifactCoords.newInstance((String)mvnPluginsArtifact.getGroupId(), (String)"wildfly-galleon-plugins", (String)mvnPluginsArtifact.getVersion(), (String)"jar"));
        }
        catch (ProvisioningException e) {
            throw new MojoExecutionException("Failed to build feature-pack", (Exception)((Object)e));
        }
        try {
            IoUtils.copy((Path)wfPlugInPath, (Path)pluginsDir.resolve(wfPlugInPath.getFileName()));
        }
        catch (IOException e) {
            throw new MojoExecutionException(Errors.copyFile((Path)wfPlugInPath, (Path)pluginsDir.resolve(wfPlugInPath.getFileName())));
        }
    }

    private void addConfigGenerator(Path resourcesDir, Artifact mvnPluginsArtifact) throws MojoExecutionException {
        Path wfPlugInPath;
        WfFeaturePackBuildMojo.mkdirs(resourcesDir);
        try {
            wfPlugInPath = this.resolveArtifact(ArtifactCoords.newInstance((String)mvnPluginsArtifact.getGroupId(), (String)"wildfly-config-gen", (String)mvnPluginsArtifact.getVersion(), (String)"jar"));
        }
        catch (ProvisioningException e) {
            throw new MojoExecutionException("Failed to build feature-pack", (Exception)((Object)e));
        }
        try {
            IoUtils.copy((Path)wfPlugInPath, (Path)resourcesDir.resolve("wildfly-config-gen.jar"));
        }
        catch (IOException e) {
            throw new MojoExecutionException(Errors.copyFile((Path)wfPlugInPath, (Path)resourcesDir.resolve(wfPlugInPath.getFileName())));
        }
    }

    private static void mkdirs(Path resourcesWildFly) throws MojoExecutionException {
        try {
            Files.createDirectories(resourcesWildFly, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException(Errors.mkdirs((Path)resourcesWildFly), (Exception)e);
        }
    }

    private void addDocsSchemas(Path fpPackagesDir, FeaturePackLayout.Builder fpBuilder) throws MojoExecutionException {
        this.getExtendedPackage("docs.schema", true);
        this.getExtendedPackage("docs", true).addPackageDep("docs.schema", true);
        Path schemasPackageDir = fpPackagesDir.resolve("docs.schema");
        Path schemaGroupsTxt = schemasPackageDir.resolve("pm").resolve("wildfly").resolve("schema-groups.txt");
        BufferedWriter writer = null;
        try {
            WfFeaturePackBuildMojo.mkdirs(schemasPackageDir);
            WfFeaturePackBuildMojo.mkdirs(schemaGroupsTxt.getParent());
            writer = Files.newBufferedWriter(schemaGroupsTxt, new OpenOption[0]);
            for (String group : this.wfFpConfig.getSchemaGroups()) {
                writer.write(group);
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(Errors.mkdirs((Path)schemaGroupsTxt.getParent()), (Exception)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void addConfigPackages(Path configDir, Path packagesDir, FeaturePackLayout.Builder fpBuilder) throws MojoExecutionException {
        if (!Files.exists(configDir, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(configDir);){
            for (Path configPackage : stream) {
                PackageSpec pkgSpec;
                Path packageDir = packagesDir.resolve(configPackage.getFileName());
                if (!Files.exists(packageDir, new LinkOption[0])) {
                    WfFeaturePackBuildMojo.mkdirs(packageDir);
                }
                IoUtils.copy((Path)configPackage, (Path)packageDir);
                Path packageXml = configPackage.resolve("package.xml");
                if (!Files.exists(packageXml, new LinkOption[0])) continue;
                try (BufferedReader reader = Files.newBufferedReader(packageXml);){
                    try {
                        pkgSpec = PackageXmlParser.getInstance().parse((Reader)reader);
                    }
                    catch (XMLStreamException e) {
                        throw new MojoExecutionException("Failed to parse " + packageXml, (Exception)e);
                    }
                }
                IoUtils.copy((Path)packageXml, (Path)packageDir.resolve("package.xml"));
                fpBuilder.addPackage(pkgSpec);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to process config packages", (Exception)e);
        }
    }

    private void processFeaturePackDependencies(FeaturePackSpec.Builder fpBuilder) throws Exception {
        if (this.wfFpConfig.getDependencies().isEmpty()) {
            return;
        }
        this.fpDependencies = new LinkedHashMap<String, FeaturePackLayout>(this.wfFpConfig.getDependencies().size());
        for (FeaturePackDependencySpec depSpec : this.wfFpConfig.getDependencies()) {
            FeaturePackConfig depConfig = depSpec.getTarget();
            String depStr = depConfig.getGav().toString();
            String gavStr = this.artifactVersions.getVersion(depStr);
            if (gavStr == null) {
                throw new MojoExecutionException("Failed resolve artifact version for " + depStr);
            }
            ArtifactCoords.Gav depGav = ArtifactCoords.newGav((String)gavStr);
            FeaturePackConfig.Builder depBuilder = FeaturePackConfig.builder((ArtifactCoords.Gav)depGav);
            depBuilder.setInheritPackages(depConfig.isInheritPackages());
            if (depConfig.hasExcludedPackages()) {
                try {
                    depBuilder.excludeAllPackages((Collection)depConfig.getExcludedPackages()).build();
                }
                catch (ProvisioningException e) {
                    throw new MojoExecutionException("Failed to process dependencies", (Exception)((Object)e));
                }
            }
            if (depConfig.hasIncludedPackages()) {
                try {
                    depBuilder.includeAllPackages(depConfig.getIncludedPackages()).build();
                }
                catch (ProvisioningException e) {
                    throw new MojoExecutionException("Failed to process dependencies", (Exception)((Object)e));
                }
            }
            depBuilder.setInheritConfigs(depConfig.isInheritConfigs());
            if (depConfig.hasDefinedConfigs()) {
                for (ConfigModel configModel : depConfig.getDefinedConfigs()) {
                    depBuilder.addConfig(configModel);
                }
            }
            if (depConfig.hasExcludedConfigs()) {
                for (ConfigId configId : depConfig.getExcludedConfigs()) {
                    depBuilder.excludeDefaultConfig(configId);
                }
            }
            if (depConfig.hasFullModelsExcluded()) {
                for (Map.Entry entry : depConfig.getFullModelsExcluded().entrySet()) {
                    depBuilder.excludeConfigModel((String)entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
                }
            }
            if (depConfig.hasFullModelsIncluded()) {
                for (String string : depConfig.getFullModelsIncluded()) {
                    depBuilder.includeConfigModel(string);
                }
            }
            if (depConfig.hasIncludedConfigs()) {
                for (ConfigId configId : depConfig.getIncludedConfigs()) {
                    depBuilder.includeDefaultConfig(configId);
                }
            }
            if (depConfig.hasDefinedConfigs()) {
                for (ConfigModel configModel : depConfig.getDefinedConfigs()) {
                    depBuilder.addConfig(configModel);
                }
            }
            fpBuilder.addFeaturePackDep(depSpec.getName(), depBuilder.build());
            Path depZip = this.resolveArtifact(depGav.toArtifactCoords());
            this.fpDependencies.put(depSpec.getName(), FeaturePackLayoutDescriber.describeFeaturePackZip((Path)depZip));
        }
    }

    private void packageContent(FeaturePackLayout.Builder fpBuilder, Path contentDir, Path packagesDir) throws IOException, MojoExecutionException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(contentDir);){
            for (Path p : stream) {
                String pkgName = p.getFileName().toString();
                Path pkgDir = packagesDir.resolve(pkgName);
                Path pkgContentDir = pkgDir.resolve("content").resolve(pkgName);
                PackageSpec.Builder pkgBuilder = this.getExtendedPackage(pkgName, true);
                if (pkgName.equals("docs")) {
                    try (DirectoryStream<Path> docsStream = Files.newDirectoryStream(p);){
                        for (Path docPath : docsStream) {
                            String docName = docPath.getFileName().toString();
                            String docPkgName = "docs." + docName;
                            Path docDir = packagesDir.resolve(docPkgName);
                            this.getExtendedPackage(docPkgName, true);
                            Path docContentDir = docDir.resolve("content").resolve("docs").resolve(docName);
                            IoUtils.copy((Path)docPath, (Path)docContentDir);
                            pkgBuilder.addPackageDep(docPkgName, true);
                            WfFeaturePackBuildMojo.ensureLineEndings(docContentDir);
                        }
                    }
                }
                if (pkgName.equals("bin")) {
                    Path binStandalonePkgDir = packagesDir.resolve("bin.standalone").resolve("content").resolve(pkgName);
                    Path binDomainPkgDir = packagesDir.resolve("bin.domain").resolve("content").resolve(pkgName);
                    try (DirectoryStream<Path> binStream = Files.newDirectoryStream(p);){
                        for (Path binPath : binStream) {
                            String fileName = binPath.getFileName().toString();
                            if (fileName.startsWith("standalone")) {
                                IoUtils.copy((Path)binPath, (Path)binStandalonePkgDir.resolve(fileName));
                                continue;
                            }
                            if (fileName.startsWith("domain")) {
                                IoUtils.copy((Path)binPath, (Path)binDomainPkgDir.resolve(fileName));
                                continue;
                            }
                            IoUtils.copy((Path)binPath, (Path)pkgContentDir.resolve(fileName));
                        }
                    }
                    if (Files.exists(binStandalonePkgDir, new LinkOption[0])) {
                        WfFeaturePackBuildMojo.ensureLineEndings(binStandalonePkgDir);
                        this.getExtendedPackage("bin.standalone", true).addPackageDep(pkgName);
                    }
                    if (Files.exists(binDomainPkgDir, new LinkOption[0])) {
                        WfFeaturePackBuildMojo.ensureLineEndings(binDomainPkgDir);
                        this.getExtendedPackage("bin.domain", true).addPackageDep(pkgName);
                    }
                } else {
                    IoUtils.copy((Path)p, (Path)pkgContentDir);
                }
                if (!Files.exists(pkgContentDir, new LinkOption[0])) continue;
                WfFeaturePackBuildMojo.ensureLineEndings(pkgContentDir);
            }
        }
    }

    private Map<String, Path> findModules(final Path modulesDir) throws IOException {
        final HashMap<String, Path> moduleXmlByPkgName = new HashMap<String, Path>();
        Files.walkFileTree(modulesDir, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path moduleXml = dir.resolve("module.xml");
                if (!Files.exists(moduleXml, new LinkOption[0])) {
                    return FileVisitResult.CONTINUE;
                }
                String packageName = moduleXml.getParent().getFileName().toString().equals("main") ? modulesDir.relativize(moduleXml.getParent().getParent()).toString() : modulesDir.relativize(moduleXml.getParent()).toString();
                packageName = packageName.replace(File.separatorChar, '.');
                moduleXmlByPkgName.put(packageName, moduleXml);
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.TERMINATE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        return moduleXmlByPkgName;
    }

    private void packageModules(FeaturePackLayout.Builder fpBuilder, Path resourcesDir, Map<String, Path> moduleXmlByPkgName, Path packagesDir, PackageSpec.Builder modulesAll) throws IOException, MojoExecutionException {
        for (Map.Entry<String, Path> module : moduleXmlByPkgName.entrySet()) {
            String packageName = module.getKey();
            Path moduleXml = module.getValue();
            Path packageDir = packagesDir.resolve(packageName);
            Path targetXml = packageDir.resolve("pm").resolve("wildfly").resolve("module").resolve(resourcesDir.relativize(moduleXml));
            WfFeaturePackBuildMojo.mkdirs(targetXml.getParent());
            IoUtils.copy((Path)moduleXml.getParent(), (Path)targetXml.getParent());
            PackageSpec.Builder pkgSpecBuilder = PackageSpec.builder((String)packageName);
            try {
                ModuleParseResult parsedModule = ModuleXmlParser.parse(targetXml, "UTF-8");
                if (!parsedModule.dependencies.isEmpty()) {
                    for (ModuleParseResult.ModuleDependency moduleDep : parsedModule.dependencies) {
                        ModuleIdentifier moduleId = moduleDep.getModuleId();
                        String depName = moduleId.getName();
                        if (!moduleId.getSlot().equals("main")) {
                            depName = depName + '.' + moduleId.getSlot();
                        }
                        if (moduleXmlByPkgName.containsKey(depName)) {
                            pkgSpecBuilder.addPackageDep(depName, moduleDep.isOptional());
                            continue;
                        }
                        Map.Entry<String, FeaturePackLayout> depSrc = null;
                        if (!this.fpDependencies.isEmpty()) {
                            Set alternativeSrc = Collections.emptySet();
                            for (Map.Entry<String, FeaturePackLayout> depEntry : this.fpDependencies.entrySet()) {
                                if (!depEntry.getValue().hasPackage(depName)) continue;
                                if (depSrc != null) {
                                    alternativeSrc = CollectionUtils.add(alternativeSrc, (Object)depSrc.getKey());
                                }
                                depSrc = depEntry;
                            }
                            if (!alternativeSrc.isEmpty()) {
                                StringBuilder warn = new StringBuilder();
                                warn.append("Package ").append(depName).append(" from ").append(depSrc.getKey()).append(" picked as dependency of ").append(packageName).append(" although ").append(depName).append(" also exists in ");
                                StringUtils.append((StringBuilder)warn, (Iterable)alternativeSrc);
                                this.getLog().warn((CharSequence)warn);
                            }
                        }
                        if (depSrc != null) {
                            pkgSpecBuilder.addPackageDep((String)depSrc.getKey(), depName, moduleDep.isOptional());
                            continue;
                        }
                        if (moduleDep.isOptional() || WfFeaturePackBuildMojo.isProvided(depName)) continue;
                        throw new MojoExecutionException("Package " + packageName + " has unsatisifed external dependency on package " + depName);
                    }
                }
            }
            catch (ParsingException e) {
                throw new IOException(Errors.parseXml((Path)targetXml), e);
            }
            PackageSpec pkgSpec = pkgSpecBuilder.build();
            try {
                PackageXmlWriter.getInstance().write((Object)pkgSpec, packageDir.resolve("package.xml"));
            }
            catch (XMLStreamException e) {
                throw new IOException(Errors.writeFile((Path)packageDir.resolve("package.xml")), e);
            }
            modulesAll.addPackageDep(packageName, true);
            fpBuilder.addPackage(pkgSpec);
        }
    }

    private Properties getFPConfigProperties() {
        Properties properties = new Properties();
        properties.put("project.version", this.project.getVersion());
        properties.put("product.release.name", this.releaseName);
        properties.put("version", this.project.getVersion());
        return properties;
    }

    private Path getFPConfigFile() throws ProvisioningException {
        Path path = Paths.get(this.configDir.getAbsolutePath(), this.configFile);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new ProvisioningException(Errors.pathDoesNotExist((Path)path));
        }
        return path;
    }

    private static void writeXml(PackageSpec pkgSpec, Path dir) throws MojoExecutionException {
        try {
            WfFeaturePackBuildMojo.mkdirs(dir);
            PackageXmlWriter.getInstance().write((Object)pkgSpec, dir.resolve("package.xml"));
        }
        catch (IOException | XMLStreamException e) {
            throw new MojoExecutionException(Errors.writeFile((Path)dir.resolve("package.xml")), e);
        }
    }

    private Path resolveArtifact(ArtifactCoords coords) throws ProvisioningException {
        ArtifactResult result;
        try {
            result = this.repoSystem.resolveArtifact(this.repoSession, this.getArtifactRequest(coords));
        }
        catch (ArtifactResolutionException e) {
            throw new ProvisioningException(FpMavenErrors.artifactResolution((ArtifactCoords)coords), (Throwable)e);
        }
        if (!result.isResolved()) {
            throw new ProvisioningException(FpMavenErrors.artifactResolution((ArtifactCoords)coords));
        }
        if (result.isMissing()) {
            throw new ProvisioningException(FpMavenErrors.artifactMissing((ArtifactCoords)coords));
        }
        return Paths.get(result.getArtifact().getFile().toURI());
    }

    private ArtifactRequest getArtifactRequest(ArtifactCoords coords) {
        ArtifactRequest req = new ArtifactRequest();
        req.setArtifact((org.eclipse.aether.artifact.Artifact)new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getExtension(), coords.getVersion()));
        req.setRepositories(this.remoteRepos);
        return req;
    }

    private static void ensureLineEndings(Path file) throws MojoExecutionException {
        try {
            Files.walkFileTree(file, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (linuxLineEndingsPathFilter.accept(file)) {
                        WfFeaturePackBuildMojo.ensureLineEndings(file, linuxLineEndingPattern, "\n");
                    } else if (windowsLineEndingsPathFilter.accept(file)) {
                        WfFeaturePackBuildMojo.ensureLineEndings(file, windowsLineEndingPattern, "\r\n");
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to adjust line endings for " + file, (Exception)e);
        }
    }

    private static void ensureLineEndings(Path file, Pattern pattern, String lineEnding) throws IOException {
        Matcher matcher;
        String fixedContent;
        String content = IoUtils.readFile((Path)file);
        if (content.equals(fixedContent = (matcher = pattern.matcher(content)).replaceAll(lineEnding))) {
            return;
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(fixedContent.getBytes("UTF-8"));){
            Files.copy(in, file, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void debug(String msg, Object ... args) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format(msg, args));
        }
    }
}

