/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.spec.ConfigLayerDependency;
import org.jboss.galleon.spec.ConfigLayerSpec;
import org.jboss.galleon.universe.Channel;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.universe.maven.MavenChannel;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;
import org.jboss.galleon.xml.ProvisioningXmlParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wildfly.glow.AddOn;
import org.wildfly.glow.Env;
import org.wildfly.glow.EnvHandler;
import org.wildfly.glow.FeaturePacks;
import org.wildfly.glow.GlowMessageWriter;
import org.wildfly.glow.GlowSession;
import org.wildfly.glow.Layer;
import org.wildfly.glow.LayerMapping;
import org.wildfly.glow.ProvisioningTracker;
import org.wildfly.glow.error.Fix;

public final class Utils {
    static void applyXPath(Path p, String expression, String expectedValue, Consumer<Layer> consumer, Layer layer) throws Exception {
        block10: {
            if (Files.readAllBytes(p).length == 0) {
                return;
            }
            try (InputStream reader = Files.newInputStream(p, new OpenOption[0]);){
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(reader);
                XPath xPath = XPathFactory.newInstance().newXPath();
                NodeList nodes = (NodeList)xPath.evaluate(expression, document, XPathConstants.NODESET);
                if (nodes.getLength() == 0) break block10;
                if (expectedValue != null) {
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Pattern pattern;
                        Node n = nodes.item(i);
                        String content = n.getTextContent();
                        if (Utils.isPattern(expectedValue)) {
                            expectedValue = Utils.escapePattern(expectedValue);
                        }
                        if (!(pattern = Pattern.compile(expectedValue)).matcher(content).matches()) continue;
                        consumer.accept(layer);
                        break block10;
                    }
                    break block10;
                }
                consumer.accept(layer);
            }
        }
    }

    static Set<Layer> getTransitiveDependencies(Map<String, Layer> all, Layer root, Set<Layer> seen) {
        if (seen.contains(root)) {
            return Collections.emptySet();
        }
        seen.add(root);
        Layer l = all.get(root.getName());
        if (l.getDependencies().isEmpty()) {
            return Collections.emptySet();
        }
        TreeSet<Layer> alldeps = new TreeSet<Layer>();
        alldeps.addAll(l.getDependencies());
        for (Layer d : l.getDependencies()) {
            alldeps.addAll(Utils.getTransitiveDependencies(all, d, seen));
        }
        return alldeps;
    }

    static void exportOffline(UniverseResolver universeResolver, ProvisioningLayout<FeaturePackLayout> pLayout) throws ProvisioningException, IOException {
        Path featurePacksDir = GlowSession.OFFLINE_FEATURE_PACKS_DIR;
        Path docsDir = GlowSession.OFFLINE_DOCS_DIR;
        Files.createDirectories(featurePacksDir, new FileAttribute[0]);
        Files.createDirectories(docsDir, new FileAttribute[0]);
        int index = 0;
        for (FeaturePackLayout fp : pLayout.getOrderedFeaturePacks()) {
            Channel c = universeResolver.getChannel(fp.getFPID().getLocation());
            Path resolved = c.resolve(fp.getFPID().getLocation());
            Path target = featurePacksDir.resolve(index + "-" + resolved.getFileName().toString());
            if (!Files.exists(target, new LinkOption[0])) {
                Files.copy(resolved, target, new CopyOption[0]);
            }
            ++index;
        }
        Map<String, Layer> layers = Utils.getAllLayers(universeResolver, pLayout, new HashMap<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>>());
        for (Layer l : layers.values()) {
            for (String k : l.getProperties().keySet()) {
                if (!"org.wildfly.rule.configuration".equals(k)) continue;
                String val = l.getProperties().get(k);
                String[] split = val.split(",");
                for (int i = 0; i < split.length; ++i) {
                    String s = split[i];
                    l.getConfiguration().add(s);
                    try (InputStream in = new URL(s).openStream();){
                        Files.copy(in, docsDir.resolve(l.getName() + "-glow-configuration-" + i + ".yaml"), StandardCopyOption.REPLACE_EXISTING);
                        continue;
                    }
                }
            }
        }
    }

    public static Map<String, Layer> getAllLayers(UniverseResolver universeResolver, ProvisioningLayout<FeaturePackLayout> pLayout, Map<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>> fpDependencies) throws ProvisioningException, IOException {
        HashMap<String, Layer> layersMap = new HashMap<String, Layer>();
        TreeSet autoInjected = new TreeSet();
        TreeSet<String> hiddens = new TreeSet<String>();
        LinkedHashMap unresolvedDependencies = new LinkedHashMap();
        for (FeaturePackLayout fp : pLayout.getOrderedFeaturePacks()) {
            Object layer2;
            ConfigModel m = fp.loadModel("standalone");
            if (m != null) {
                autoInjected.addAll(m.getIncludedLayers());
            }
            FeaturePackLocation.FPID fpid = Utils.toMavenCoordinates(fp.getFPID(), universeResolver);
            for (Object layer2 : fp.loadLayers()) {
                ConfigLayerSpec spec = fp.loadConfigLayerSpec(layer2.getModel(), layer2.getName());
                String kind = (String)spec.getProperties().get("org.wildfly.rule.kind");
                if (kind != null && "hidden".equals(kind)) {
                    hiddens.add(layer2.getName());
                    continue;
                }
                TreeSet<String> dependencies = new TreeSet<String>();
                for (ConfigLayerDependency dep : spec.getLayerDeps()) {
                    dependencies.add(dep.getName());
                }
                Layer l = (Layer)layersMap.get(layer2.getName());
                if (l != null) {
                    Set deps = (Set)unresolvedDependencies.get(l.getName());
                    if (deps != null) {
                        deps.addAll(dependencies);
                    }
                    l.getProperties().putAll(spec.getProperties());
                    String redefinedKind = (String)spec.getProperties().get("org.wildfly.rule.kind");
                    if (redefinedKind != null && "hidden".equals(redefinedKind)) {
                        layersMap.remove(layer2.getName());
                    }
                } else {
                    if (hiddens.contains(layer2.getName())) continue;
                    l = new Layer(layer2.getName());
                    l.getProperties().putAll(spec.getProperties());
                    unresolvedDependencies.put(l.getName(), dependencies);
                    layersMap.put(layer2.getName(), l);
                }
                l.getFeaturePacks().add(fpid);
            }
            Set producers = fpDependencies.computeIfAbsent(fpid, value -> new HashSet());
            for (FeaturePackConfig cfg : fp.getSpec().getFeaturePackDeps()) {
                FeaturePackLocation.FPID fpidDep = Utils.toMavenCoordinates(cfg.getLocation().getFPID(), universeResolver);
                producers.add(fpidDep.getProducer());
            }
            layer2 = layersMap.values().iterator();
            while (layer2.hasNext()) {
                Layer l = (Layer)layer2.next();
                if (!autoInjected.contains(l.getName())) continue;
                l.setIsAutomaticInjection(true);
            }
        }
        for (String l : unresolvedDependencies.keySet()) {
            Layer layer = (Layer)layersMap.get(l);
            Set deps = (Set)unresolvedDependencies.get(l);
            for (String d : deps) {
                Layer dep = (Layer)layersMap.get(d);
                layer.getDependencies().add(dep);
            }
        }
        return layersMap;
    }

    static FeaturePackLocation.FPID toMavenCoordinates(FeaturePackLocation.FPID fpid, UniverseResolver universeResolver) throws ProvisioningException {
        Channel c;
        if (!fpid.getLocation().isMavenCoordinates() && (c = universeResolver.getChannel(fpid.getLocation())) instanceof MavenChannel) {
            MavenChannel mc = (MavenChannel)c;
            String grpId = mc.getFeaturePackGroupId();
            String artifactId = mc.getFeaturePackArtifactId();
            fpid = FeaturePackLocation.fromString((String)(grpId + ":" + artifactId + ":" + fpid.getBuild())).getFPID();
        }
        return fpid;
    }

    public static Path getOffLineContent() throws IOException {
        if (Files.exists(GlowSession.OFFLINE_ZIP, new LinkOption[0])) {
            if (Files.exists(GlowSession.OFFLINE_CONTENT, new LinkOption[0])) {
                IoUtils.recursiveDelete((Path)GlowSession.OFFLINE_CONTENT);
            }
            Files.createDirectories(GlowSession.OFFLINE_CONTENT, new FileAttribute[0]);
            ZipUtils.unzip((Path)GlowSession.OFFLINE_ZIP, (Path)GlowSession.OFFLINE_CONTENT);
        }
        return GlowSession.OFFLINE_CONTENT;
    }

    public static ProvisioningLayout<FeaturePackLayout> buildLayout(String executionContext, Path provisioningXML, String version, GlowMessageWriter writer, boolean techPreview) throws Exception {
        ProvisioningLayoutFactory factory = ProvisioningLayoutFactory.getInstance();
        ProvisioningConfig pConfig = Utils.buildProvisioningConfig(factory, executionContext, provisioningXML, version, writer, techPreview);
        return factory.newConfigLayout(pConfig);
    }

    public static ProvisioningConfig buildProvisioningConfig(ProvisioningLayoutFactory factory, String executionContext, Path provisioningXML, String version, GlowMessageWriter writer, boolean techPreview) throws Exception {
        ProvisioningConfig pConfig;
        Path offlineContent = Utils.getOffLineContent();
        if (Files.exists(offlineContent, new LinkOption[0])) {
            writer.info("Offline content detected");
            List files = Stream.of(GlowSession.OFFLINE_FEATURE_PACKS_DIR.toFile().listFiles()).filter(file -> !file.isDirectory()).sorted().collect(Collectors.toList());
            ProvisioningConfig.Builder builder = ProvisioningConfig.builder();
            for (File f : files) {
                builder.addFeaturePackDep(factory.addLocal(f.toPath(), false));
            }
            pConfig = builder.build();
        } else {
            if (provisioningXML == null) {
                provisioningXML = FeaturePacks.getFeaturePacks(version, executionContext, techPreview);
            }
            pConfig = ProvisioningXmlParser.parse((Path)provisioningXML);
        }
        return pConfig;
    }

    public static ProvisioningLayout<FeaturePackLayout> buildLayout(ProvisioningLayoutFactory factory, ProvisioningConfig pConfig, String executionContext, Path provisioningXML, String version, GlowMessageWriter writer) throws IOException, ProvisioningException, URISyntaxException {
        Object fs = null;
        ProvisioningLayout layout = factory.newConfigLayout(pConfig);
        return layout;
    }

    static void provisionServer(ProvisioningConfig config, Path home, MavenRepoManager resolver, final GlowMessageWriter writer) throws ProvisioningException {
        try (ProvisioningManager pm = ((ProvisioningManager.Builder)ProvisioningManager.builder().addArtifactResolver((RepositoryArtifactResolver)resolver)).setInstallationHome(home).setLogTime(false).setMessageWriter(new MessageWriter(){

            public void verbose(Throwable cause, CharSequence message) {
                if (writer.isVerbose()) {
                    writer.trace(message);
                }
            }

            public void print(Throwable cause, CharSequence message) {
                writer.info(message);
            }

            public void error(Throwable cause, CharSequence message) {
                writer.error(message);
            }

            public boolean isVerboseEnabled() {
                return writer.isVerbose();
            }

            public void close() throws Exception {
            }
        }).setRecordState(true).build();){
            ProvisioningTracker.initTrackers(pm, writer);
            pm.provision(config);
        }
    }

    public static Set<String> getXMLElementValues(Path p, String expression) throws Exception {
        if (Files.readAllBytes(p).length == 0) {
            return Collections.emptySet();
        }
        TreeSet<String> values = new TreeSet<String>();
        try (InputStream reader = Files.newInputStream(p, new OpenOption[0]);){
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(reader);
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodes = (NodeList)xPath.evaluate(expression, document, XPathConstants.NODESET);
            if (nodes.getLength() != 0) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node n = nodes.item(i);
                    String content = n.getTextContent();
                    values.add(content);
                }
            }
        }
        return values;
    }

    public static String escapePattern(String s) {
        if (Utils.isPattern(s)) {
            StringBuilder builder = new StringBuilder();
            for (char c : s.toCharArray()) {
                if (c == '.') {
                    builder.append('\\');
                } else if (c == '*') {
                    builder.append('.');
                }
                builder.append(c);
            }
            return builder.toString();
        }
        return s;
    }

    public static boolean isPattern(String s) {
        return s.contains("*");
    }

    public static LayerMapping buildMapping(Map<String, Layer> layers, Set<String> profiles) {
        LayerMapping mapping = new LayerMapping();
        for (Layer l : layers.values()) {
            block1: for (String k : l.getProperties().keySet()) {
                Set ll;
                if ("org.wildfly.rule.annotations".equals(k)) {
                    String[] split;
                    String val = l.getProperties().get(k);
                    for (String s : split = val.split(",")) {
                        s = Utils.escapePattern(s);
                        ll = mapping.getAnnotations().computeIfAbsent(s, value -> new HashSet());
                        ll.add(l);
                    }
                    continue;
                }
                if ("org.wildfly.rule.class".equals(k)) {
                    String[] split;
                    String val = l.getProperties().get(k);
                    for (String s : split = val.split(",")) {
                        s = Utils.escapePattern(s);
                        ll = mapping.getConstantPoolClassInfos().computeIfAbsent(s, value -> new HashSet());
                        ll.add(l);
                    }
                    continue;
                }
                if ("org.wildfly.rule.configuration".equals(k)) {
                    if (Files.exists(GlowSession.OFFLINE_DOCS_DIR, new LinkOption[0])) {
                        List files = Stream.of(GlowSession.OFFLINE_DOCS_DIR.toFile().listFiles()).filter(file -> !file.isDirectory() && file.getName().startsWith(l.getName() + "-glow-configuration-")).sorted().collect(Collectors.toList());
                        for (File f : files) {
                            l.getConfiguration().add(f.toURI().toString());
                        }
                        continue;
                    }
                    String val = l.getProperties().get(k);
                    String[] split = val.split(",");
                    l.getConfiguration().addAll(Arrays.asList(split));
                    continue;
                }
                if (k.startsWith("org.wildfly.rule.no-configuration-if")) {
                    mapping.getNoConfigurationConditions().put(l, k);
                    continue;
                }
                if (k.startsWith("org.wildfly.rule.hidden-if")) {
                    mapping.getHiddenConditions().put(l, k);
                    continue;
                }
                if ("org.wildfly.rule.expect-add-on-family".equals(k)) {
                    l.setExpectFamily(l.getProperties().get(k));
                    continue;
                }
                if ("org.wildfly.rule.add-on".equals(k)) {
                    String familyAndName = l.getProperties().get(k);
                    String[] split = familyAndName.split(",");
                    String family = split[0];
                    String name = split[1];
                    String description = l.getProperties().get("org.wildfly.rule.add-on-description");
                    AddOn addon = new AddOn(name, family, description);
                    String dependencies = l.getProperties().get("org.wildfly.rule.add-on-depends-on");
                    if ("all-dependencies".equals(dependencies)) {
                        addon.getLayersThatExpectAllDependencies().add(l);
                    } else if (dependencies.startsWith("only:")) {
                        int i = dependencies.indexOf(":");
                        String v = dependencies.substring(i + 1);
                        String[] deps = v.split(",");
                        Set<Layer> set = addon.getLayersThatExpectSomeDependencies().get(l);
                        if (set == null) {
                            set = new TreeSet<Layer>();
                            addon.getLayersThatExpectSomeDependencies().put(l, set);
                        }
                        for (String d : deps) {
                            Layer dl = layers.get(d);
                            if (dl == null) continue;
                            set.add(dl);
                        }
                    } else if ("none".equals(dependencies)) {
                        addon.getLayersAlwaysIncluded().add(l);
                    }
                    addon.getLayers().add(l);
                    l.setAddOn(addon);
                    mapping.getAddOns().put(addon.getName(), addon);
                    Set<AddOn> members = mapping.getAddOnFamilyMembers().get(family);
                    if (members == null) {
                        members = new TreeSet<AddOn>();
                        mapping.getAddOnFamilyMembers().put(family, members);
                    }
                    members.add(addon);
                    String cardinality = l.getProperties().get("org.wildfly.rule.add-on-cardinality");
                    if (cardinality != null) {
                        int i = Integer.parseInt(cardinality);
                        mapping.getAddOnsCardinalityInFamily().put(family, i);
                    } else if (addon.isDefault()) {
                        mapping.getAddOnsCardinalityInDefaultFamily().put(family, 1);
                    }
                    for (String kk : l.getProperties().keySet()) {
                        if (!kk.startsWith("org.wildfly.rule.add-on-fix-")) continue;
                        int i = "org.wildfly.rule.add-on-fix-".length();
                        String id = kk.substring(i);
                        String value2 = l.getProperties().get(kk);
                        String[] items = value2.split(",");
                        String fixDescription = null;
                        String fixContent = null;
                        if (items.length == 2) {
                            fixDescription = items[0];
                            fixContent = items[1];
                        }
                        Fix fix = new Fix(id, fixDescription, fixContent);
                        addon.getFixes().put(id, fix);
                        Set<AddOn> s = mapping.getFixedByAddons().get(id);
                        if (s == null) {
                            s = new TreeSet<AddOn>();
                            mapping.getFixedByAddons().put(id, s);
                        }
                        s.add(addon);
                        continue block1;
                    }
                    continue;
                }
                if ("org.wildfly.rule.kind".equals(k)) {
                    String kind = l.getProperties().get(k);
                    if ("default-base-layer".equals(kind)) {
                        mapping.setDefaultBaseLayer(l);
                        continue;
                    }
                    if (!"metadata-only".equals(kind)) continue;
                    mapping.getMetadataOnly().add(l);
                    continue;
                }
                if ("org.wildfly.rule.bring-datasource".equals(k)) {
                    String value3 = l.getProperties().get(k);
                    l.getBringDatasources().add(value3);
                    continue;
                }
                if (k.startsWith("org.wildfly.rule.profile-")) {
                    int i = k.indexOf("-");
                    String profile = k.substring(i + 1);
                    String val = l.getProperties().get(k);
                    Set<Layer> set = mapping.getAllProfilesLayers().get(profile);
                    if (set == null) {
                        set = new TreeSet<Layer>();
                        mapping.getAllProfilesLayers().put(profile, set);
                    }
                    set.add(layers.get(val));
                }
                if ("org.wildfly.rule.inclusion-mode".equals(k)) {
                    String val = l.getProperties().get(k);
                    if ("all-dependencies".equals(val)) {
                        mapping.getLayersIncludedIfAllDeps().add(l);
                        continue;
                    }
                    if (!val.startsWith("only:")) continue;
                    int i = val.indexOf(":");
                    String v = val.substring(i + 1);
                    String[] split = v.split(",");
                    Set<String> set = mapping.getLayersIncludedIfSomeDeps().get(l);
                    if (set == null) {
                        set = new TreeSet<String>();
                        mapping.getLayersIncludedIfSomeDeps().put(l, set);
                    }
                    set.addAll(Arrays.asList(split));
                    continue;
                }
                if (profiles.isEmpty()) continue;
                Set<String> referencedProfiles = Utils.getProfiles(profiles, k, l);
                for (String s : referencedProfiles) {
                    mapping.getActiveProfilesLayers().put(s, l);
                }
            }
        }
        return mapping;
    }

    private static Set<String> getProfiles(Set<String> profiles, String k, Layer l) {
        TreeSet<String> ret = new TreeSet<String>();
        for (String p : profiles) {
            if (!("org.wildfly.rule.profile-" + p).equals(k)) continue;
            String val = l.getProperties().get(k);
            String[] split = val.split(",");
            ret.addAll(Arrays.asList(split));
        }
        return ret;
    }

    public static Set<String> getAllProfiles(Map<String, Layer> layers) {
        TreeSet<String> profiles = new TreeSet<String>();
        for (Layer l : layers.values()) {
            for (String k : l.getProperties().keySet()) {
                if (!k.startsWith("org.wildfly.rule.profile-")) continue;
                int i = k.indexOf("-");
                profiles.add(k.substring(i + 1));
            }
        }
        profiles.add("standalone");
        return profiles;
    }

    public static String getAddOnFix(AddOn ao, String fixContent) throws URISyntaxException, IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("add-on ").append(ao.getName()).append(" fixes the problem");
        StringBuilder envBuilder = new StringBuilder();
        for (Layer l : ao.getLayers()) {
            if (l.getConfiguration().isEmpty()) continue;
            for (String c : l.getConfiguration()) {
                URI uri = new URI(c);
                Set<Env> envs = EnvHandler.retrieveEnv(uri);
                for (Env env : envs) {
                    if (!env.isRequired().booleanValue()) continue;
                    envBuilder.append("   - ").append(env.getName()).append("=").append(env.getDescription()).append("\n");
                }
            }
        }
        if (envBuilder.length() != 0) {
            builder.append(" and expects (at least) the following env variables:\n").append(envBuilder.toString());
            if (fixContent != null && !fixContent.isEmpty()) {
                builder.append("   - ").append(fixContent);
            }
        } else if (fixContent == null || fixContent.isEmpty()) {
            builder.append(" fully");
        } else {
            builder.append("   - ").append(fixContent);
        }
        return builder.toString();
    }

    public static boolean layersAreBanned(Set<Layer> layers) {
        for (Layer l : layers) {
            if (l.isBanned()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConfigEntry(String entry) throws IOException {
        String prop = System.getProperty(entry);
        if (prop != null) {
            return prop;
        }
        InputStream stream = Utils.class.getResourceAsStream("glow.properties");
        if (stream == null) {
            return null;
        }
        try {
            String value;
            Properties properties = new Properties();
            properties.load(stream);
            String string = value = properties.getProperty(entry);
            return string;
        }
        finally {
            stream.close();
        }
    }
}

