/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayersBuilder;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;
import org.wildfly.glow.AddOn;
import org.wildfly.glow.Arguments;
import org.wildfly.glow.DeploymentScanner;
import org.wildfly.glow.DockerSupport;
import org.wildfly.glow.Env;
import org.wildfly.glow.EnvHandler;
import org.wildfly.glow.FeaturePacks;
import org.wildfly.glow.GlowMessageWriter;
import org.wildfly.glow.GoOfflineArguments;
import org.wildfly.glow.Layer;
import org.wildfly.glow.LayerMapping;
import org.wildfly.glow.OutputContent;
import org.wildfly.glow.OutputFormat;
import org.wildfly.glow.ScanArguments;
import org.wildfly.glow.ScanResults;
import org.wildfly.glow.ScanResultsPrinter;
import org.wildfly.glow.Suggestions;
import org.wildfly.glow.Utils;
import org.wildfly.glow.error.ErrorIdentificationSession;
import org.wildfly.glow.error.ErrorLevel;
import org.wildfly.glow.error.IdentifiedError;
import org.wildfly.glow.windup.WindupSupport;

public class GlowSession {
    public static final Path OFFLINE_ZIP = Paths.get("glow-offline.zip", new String[0]);
    public static final Path OFFLINE_CONTENT = Paths.get("glow-offline-content", new String[0]);
    public static final Path OFFLINE_DOCS_DIR = OFFLINE_CONTENT.resolve("docs");
    public static final Path OFFLINE_FEATURE_PACKS_DIR = OFFLINE_CONTENT.resolve("feature-packs");
    public static final Path OFFLINE_FEATURE_PACK_DEPENDENCIES_DIR = OFFLINE_CONTENT.resolve("feature-pack-dependencies");
    public static final String STANDALONE_PROFILE = "standalone";
    private final MavenRepoManager resolver;
    private final Arguments arguments;
    private final GlowMessageWriter writer;

    private GlowSession(MavenRepoManager resolver, Arguments arguments, GlowMessageWriter writer) {
        this.resolver = resolver;
        this.arguments = arguments;
        this.writer = writer;
    }

    public static void goOffline(MavenRepoManager resolver, GoOfflineArguments arguments, GlowMessageWriter writer) throws Exception {
        if (!(arguments instanceof Arguments)) {
            throw new IllegalArgumentException("Please use the API to create the GoOfflineArguments instance");
        }
        GlowSession session = new GlowSession(resolver, (Arguments)arguments, writer);
        session.goOffline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void goOffline() throws Exception {
        if (Files.exists(OFFLINE_CONTENT, new LinkOption[0])) {
            IoUtils.recursiveDelete((Path)OFFLINE_CONTENT);
        }
        UniverseResolver universeResolver = ((UniverseResolver.Builder)UniverseResolver.builder().addArtifactResolver((RepositoryArtifactResolver)this.resolver)).build();
        GalleonBuilder provider = new GalleonBuilder();
        provider.addArtifactResolver((RepositoryArtifactResolver)this.resolver);
        try (Provisioning provisioning = null;){
            GalleonProvisioningConfig config = Utils.buildOfflineProvisioningConfig(provider, this.writer);
            if (config == null) {
                Path provisioningXML = this.arguments.getProvisioningXML();
                if (provisioningXML == null) {
                    provisioningXML = FeaturePacks.getFeaturePacks(this.arguments.getVersion(), this.arguments.getExecutionContext(), this.arguments.isTechPreview());
                }
                provisioning = provider.newProvisioningBuilder(provisioningXML).build();
                config = provisioning.loadProvisioningConfig(provisioningXML);
            } else {
                provisioning = provider.newProvisioningBuilder(config).build();
            }
            Utils.exportOffline(provisioning, config, universeResolver);
        }
        Files.deleteIfExists(OFFLINE_ZIP);
        ZipUtils.zip((Path)OFFLINE_CONTENT, (Path)OFFLINE_ZIP);
        IoUtils.recursiveDelete((Path)OFFLINE_CONTENT);
    }

    public static ScanResults scan(MavenRepoManager resolver, ScanArguments arguments, GlowMessageWriter writer) throws Exception {
        if (!(arguments instanceof Arguments)) {
            throw new IllegalArgumentException("Please use the API to create the ScanArguments instance");
        }
        GlowSession session = new GlowSession(resolver, (Arguments)arguments, writer);
        return session.scan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResults scan() throws Exception {
        LinkedHashSet<Layer> layers = new LinkedHashSet<Layer>();
        TreeSet<AddOn> possibleAddOns = new TreeSet<AddOn>();
        ErrorIdentificationSession errorSession = new ErrorIdentificationSession();
        UniverseResolver universeResolver = ((UniverseResolver.Builder)UniverseResolver.builder().addArtifactResolver((RepositoryArtifactResolver)this.resolver)).build();
        if (Files.exists(OFFLINE_ZIP, new LinkOption[0])) {
            Files.createDirectories(OFFLINE_CONTENT, new FileAttribute[0]);
            ZipUtils.unzip((Path)OFFLINE_ZIP, (Path)OFFLINE_CONTENT);
        }
        GalleonBuilder provider = new GalleonBuilder();
        provider.addArtifactResolver((RepositoryArtifactResolver)this.resolver);
        Provisioning provisioning = null;
        GalleonProvisioningConfig config = Utils.buildOfflineProvisioningConfig(provider, this.writer);
        try {
            Layer foundLayer;
            if (config == null) {
                Path provisioningXML = this.arguments.getProvisioningXML();
                if (provisioningXML == null) {
                    provisioningXML = FeaturePacks.getFeaturePacks(this.arguments.getVersion(), this.arguments.getExecutionContext(), this.arguments.isTechPreview());
                }
                provisioning = provider.newProvisioningBuilder(provisioningXML).build();
                config = provisioning.loadProvisioningConfig(provisioningXML);
            } else {
                provisioning = provider.newProvisioningBuilder(config).build();
            }
            HashMap<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>> fpDependencies = new HashMap<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>>();
            Map<String, Layer> all = Utils.getAllLayers(config, universeResolver, provisioning, fpDependencies);
            LayerMapping mapping = Utils.buildMapping(all, this.arguments.getExecutionProfiles());
            if (mapping.getDefaultBaseLayer() == null) {
                throw new IllegalArgumentException("No base layer found, WildFly Glow doesn't support WildFly server version. You must upgrade to a more recent WildFly version.");
            }
            for (String string : this.arguments.getUserEnabledAddOns()) {
                if (mapping.getAddOns().containsKey(string)) continue;
                throw new Exception("Unknown add-on " + string);
            }
            Set<String> allProfiles = Utils.getAllProfiles(all);
            for (String string : this.arguments.getExecutionProfiles()) {
                if (allProfiles.contains(string)) continue;
                throw new Exception("Unknown profile " + string);
            }
            if (this.arguments.isCloud() && OutputFormat.BOOTABLE_JAR.equals((Object)this.arguments.getOutput())) {
                this.writer.info("NOTE. In a cloud context, Bootable JAR packaging is not taken into account, a server is installed in the image.");
            }
            if (this.arguments.getBinaries() != null && !this.arguments.getBinaries().isEmpty()) {
                Path path = WindupSupport.getWindupMapping();
                if (path == null) {
                    for (Path d : this.arguments.getBinaries()) {
                        Iterator<Object> deploymentScanner = new DeploymentScanner(d, this.arguments.isVerbose(), this.arguments.getExcludeArchivesFromScan());
                        ((DeploymentScanner)((Object)deploymentScanner)).scan(mapping, layers, all, errorSession);
                    }
                } else {
                    for (Path d : this.arguments.getBinaries()) {
                        layers.addAll(WindupSupport.getLayers(all, path, d));
                    }
                }
            }
            if (!this.arguments.getManualLayers().isEmpty()) {
                for (String string : this.arguments.getManualLayers()) {
                    foundLayer = all.get(string);
                    if (foundLayer == null) {
                        throw new IllegalArgumentException("Manual layer '" + string + "' does not exist in the set of layers");
                    }
                    if (layers.contains(foundLayer)) {
                        throw new IllegalArgumentException("Layer '" + foundLayer + "' manually added has already been discovered in the deployment. It must be removed.");
                    }
                    layers.add(foundLayer);
                }
            }
            if (!this.arguments.getLayersForJndi().isEmpty()) {
                for (String string : this.arguments.getLayersForJndi()) {
                    foundLayer = all.get(string);
                    if (foundLayer == null) {
                        throw new IllegalArgumentException("Layer '" + string + "' added due to JNDI lookup does not exist in the set of layers");
                    }
                    if (layers.contains(foundLayer)) {
                        throw new IllegalArgumentException("Layer '" + string + "' added due to JNDI lookup has already been discovered in the deployment. It must be removed.");
                    }
                    layers.add(foundLayer);
                }
            }
            Map<Layer, Set<Layer>> map = GlowSession.findBaseLayer(mapping, all);
            Layer layer = map.keySet().iterator().next();
            TreeSet<Layer> allBaseLayers = new TreeSet<Layer>();
            allBaseLayers.addAll(layers);
            allBaseLayers.addAll(Utils.getTransitiveDependencies(all, layer, new HashSet<Layer>()));
            for (Layer layer2 : layers) {
                allBaseLayers.addAll(Utils.getTransitiveDependencies(all, layer2, new HashSet<Layer>()));
            }
            for (AddOn addOn : mapping.getAddOns().values()) {
                boolean enabled = this.arguments.getUserEnabledAddOns().contains(addOn.getName());
                if (!enabled) continue;
                for (Layer layer3 : addOn.getLayers()) {
                    if (layer3.isBanned()) continue;
                    layers.add(layer3);
                    allBaseLayers.add(layer3);
                    Set<Layer> dependencies = all.get(layer3.getName()).getDependencies();
                    layers.addAll(dependencies);
                    allBaseLayers.addAll(dependencies);
                }
            }
            for (String string : mapping.getAddOns().keySet()) {
                AddOn addOn = mapping.getAddOns().get(string);
                boolean enabled = this.arguments.getUserEnabledAddOns().contains(addOn.getName());
                for (Layer layer4 : addOn.getLayersThatExpectAllDependencies()) {
                    if (allBaseLayers.contains(layer4) || layer4.isBanned() || !allBaseLayers.containsAll(layer4.getDependencies())) continue;
                    if (enabled) {
                        layers.add(layer4);
                        allBaseLayers.add(layer4);
                        continue;
                    }
                    possibleAddOns.add(addOn);
                }
                for (Layer layer4 : addOn.getLayersThatExpectSomeDependencies().keySet()) {
                    Object expectDeps;
                    if (allBaseLayers.contains(layer4) || layer4.isBanned() || (expectDeps = addOn.getLayersThatExpectSomeDependencies().get(layer4)) == null || !allBaseLayers.containsAll((Collection<?>)expectDeps)) continue;
                    if (enabled) {
                        layers.add(layer4);
                        allBaseLayers.add(layer4);
                        continue;
                    }
                    possibleAddOns.add(addOn);
                }
                for (Layer layer4 : addOn.getLayersAlwaysIncluded()) {
                    if (enabled && !layer4.isBanned()) {
                        layers.add(layer4);
                        allBaseLayers.add(layer4);
                        continue;
                    }
                    possibleAddOns.add(addOn);
                }
            }
            for (Layer layer5 : mapping.getLayersIncludedIfAllDeps()) {
                if (allBaseLayers.contains(layer5) || layer5.isBanned() || !allBaseLayers.containsAll(layer5.getDependencies())) continue;
                layers.add(layer5);
                allBaseLayers.add(layer5);
            }
            for (Layer layer6 : mapping.getLayersIncludedIfSomeDeps().keySet()) {
                if (allBaseLayers.contains(layer6) || layer6.isBanned() || !allBaseLayers.containsAll((Collection)mapping.getLayersIncludedIfSomeDeps().get(layer6))) continue;
                layers.add(layer6);
                allBaseLayers.add(layer6);
            }
            for (Layer layer7 : all.values()) {
                if (!layer7.isIsAutomaticInjection() || layer7.isBanned()) continue;
                allBaseLayers.add(layer7);
            }
            TreeSet<String> possibleProfiles = new TreeSet<String>();
            if (this.arguments.getExecutionProfiles().isEmpty()) {
                block19: for (Layer l : allBaseLayers) {
                    for (String string : mapping.getAllProfilesLayers().keySet()) {
                        Set<Layer> layersInProfile = mapping.getAllProfilesLayers().get(string);
                        if (!layersInProfile.contains(l)) continue;
                        possibleProfiles.add(string);
                        continue block19;
                    }
                }
            }
            TreeSet<Layer> treeSet = new TreeSet<Layer>();
            TreeSet<Layer> excludedLayers = new TreeSet<Layer>();
            for (Layer layer8 : allBaseLayers) {
                Layer toInclude = mapping.getActiveProfilesLayers().get(layer8.getName());
                if (toInclude == null) continue;
                treeSet.add(toInclude);
                excludedLayers.add(layer8);
            }
            LinkedHashSet<Layer> decorators = new LinkedHashSet<Layer>();
            for (Layer s : layers) {
                if (map.get(layer).contains(s)) continue;
                decorators.add(s);
            }
            decorators.addAll(treeSet);
            Iterator iterator = decorators.iterator();
            while (iterator.hasNext()) {
                Layer l = (Layer)iterator.next();
                if (!excludedLayers.contains(l)) continue;
                excludedLayers.remove(l);
                iterator.remove();
            }
            TreeSet<AddOn> allEnabledAddOns = new TreeSet<AddOn>();
            for (Layer layer9 : allBaseLayers) {
                if (layer9.getAddOn() == null) continue;
                allEnabledAddOns.add(layer9.getAddOn());
            }
            TreeMap<AddOn, String> disabledAddOns = new TreeMap<AddOn, String>();
            GlowSession.fixAddOns(errorSession, layers, mapping, allEnabledAddOns, possibleAddOns, disabledAddOns, this.arguments);
            LinkedHashSet<Layer> filteredLayers = new LinkedHashSet<Layer>();
            filteredLayers.addAll(decorators);
            Iterator it = filteredLayers.iterator();
            block25: while (it.hasNext()) {
                Layer l = (Layer)it.next();
                for (Layer layer10 : decorators) {
                    Set<Layer> set;
                    if (l.equals(layer10) || !(set = Utils.getTransitiveDependencies(all, layer10, new HashSet<Layer>())).contains(l)) continue;
                    it.remove();
                    continue block25;
                }
            }
            decorators = filteredLayers;
            TreeMap<Layer, Set<Env>> suggestedConfigurations = new TreeMap<Layer, Set<Env>>();
            TreeMap<Layer, Set<Env>> stronglySuggestedConfigurations = new TreeMap<Layer, Set<Env>>();
            for (Layer layer11 : allBaseLayers) {
                if (excludedLayers.contains(layer11) || layer11.getConfiguration().isEmpty()) continue;
                if (layers.contains(layer11)) {
                    TreeSet<Env> requiredSet = new TreeSet<Env>();
                    TreeSet notRequiredSet = new TreeSet();
                    for (String c : layer11.getConfiguration()) {
                        URI uri = new URI(c);
                        Set<Env> envs = EnvHandler.retrieveEnv(uri);
                        for (Env e : envs) {
                            if (e.isRequired().booleanValue()) {
                                requiredSet.add(e);
                                continue;
                            }
                            notRequiredSet.add(e);
                        }
                    }
                    if (!requiredSet.isEmpty()) {
                        stronglySuggestedConfigurations.put(layer11, requiredSet);
                    }
                    if (notRequiredSet.isEmpty()) continue;
                    suggestedConfigurations.put(layer11, notRequiredSet);
                    continue;
                }
                TreeSet<Env> envs = new TreeSet<Env>();
                for (String c : layer11.getConfiguration()) {
                    envs.addAll(EnvHandler.retrieveEnv(new URI(c)));
                }
                suggestedConfigurations.put(layer11, envs);
            }
            for (Layer layer12 : mapping.getMetadataOnly()) {
                if (decorators.contains(layer12)) {
                    decorators.remove(layer12);
                }
                if (!layers.contains(layer12)) continue;
                layers.remove(layer12);
            }
            Map<Layer, Set<Env>> map2 = errorSession.refreshErrors(allBaseLayers, mapping, allEnabledAddOns);
            for (Layer l : map2.keySet()) {
                TreeSet envs = (TreeSet)stronglySuggestedConfigurations.get(l);
                if (envs == null) {
                    envs = new TreeSet();
                    stronglySuggestedConfigurations.put(l, envs);
                }
                envs.addAll(map2.get(l));
            }
            GalleonProvisioningConfig galleonProvisioningConfig = GlowSession.buildProvisioningConfig(config, universeResolver, allBaseLayers, layer, decorators, excludedLayers, fpDependencies, this.arguments.getConfigName());
            Suggestions suggestions = new Suggestions(suggestedConfigurations, stronglySuggestedConfigurations, possibleAddOns, possibleProfiles);
            ScanResults scanResults = new ScanResults(this, layers, excludedLayers, layer, decorators, provisioning, galleonProvisioningConfig, allEnabledAddOns, disabledAddOns, suggestions, errorSession);
            ScanResults scanResults2 = scanResults;
            return scanResults2;
        }
        finally {
            IoUtils.recursiveDelete((Path)OFFLINE_CONTENT);
        }
    }

    OutputContent outputConfig(ScanResults scanResults, Path target, String dockerImageName) throws Exception {
        Provisioning provisioning = scanResults.getProvisioning();
        if (this.arguments.getOutput() == null) {
            throw new IllegalStateException("No output format set");
        }
        HashMap<OutputContent.OutputFile, Path> files = new HashMap<OutputContent.OutputFile, Path>();
        if (!OutputFormat.PROVISIONING_XML.equals((Object)this.arguments.getOutput())) {
            if (scanResults.getErrorSession().hasErrors()) {
                this.writer.warn("You are provisioning a server although some errors still exist. You should first fix them.");
            }
            Path generatedArtifact = this.provisionServer(this.arguments.getBinaries(), scanResults.getProvisioningConfig(), this.resolver, this.arguments.getOutput(), this.arguments.isCloud(), target);
            switch (this.arguments.getOutput()) {
                case DOCKER_IMAGE: {
                    dockerImageName = dockerImageName == null ? DockerSupport.getImageName(generatedArtifact.getFileName().toString()) : dockerImageName;
                    Path origDockerFile = DockerSupport.buildApplicationImage(dockerImageName, generatedArtifact, this.arguments, this.writer);
                    IoUtils.recursiveDelete((Path)generatedArtifact);
                    Files.createDirectories(target, new FileAttribute[0]);
                    Path dockerFile = target.resolve("Dockerfile");
                    Files.copy(origDockerFile, dockerFile, new CopyOption[0]);
                    Files.delete(origDockerFile);
                    files.put(OutputContent.OutputFile.DOCKER_FILE, dockerFile.toAbsolutePath());
                    break;
                }
                case BOOTABLE_JAR: {
                    files.put(OutputContent.OutputFile.BOOTABLE_JAR_FILE, generatedArtifact.toAbsolutePath());
                    break;
                }
                case SERVER: {
                    files.put(OutputContent.OutputFile.SERVER_DIR, generatedArtifact.toAbsolutePath());
                }
            }
        } else {
            Files.createDirectories(target, new FileAttribute[0]);
            Path prov = target.resolve("provisioning.xml");
            provisioning.storeProvisioningConfig(scanResults.getProvisioningConfig(), prov);
            files.put(OutputContent.OutputFile.PROVISIONING_XML_FILE, prov.toAbsolutePath());
        }
        StringBuilder envFileContent = new StringBuilder();
        if (!scanResults.getSuggestions().getStronglySuggestedConfigurations().isEmpty() || this.arguments.isSuggest() && !scanResults.getSuggestions().getSuggestedConfigurations().isEmpty()) {
            envFileContent.append("Environment variables to set. ").append(System.lineSeparator());
        }
        if (!scanResults.getSuggestions().getStronglySuggestedConfigurations().isEmpty()) {
            envFileContent.append(this.buildEnvs(scanResults.getSuggestions().getStronglySuggestedConfigurations(), true)).append(System.lineSeparator());
        }
        if (this.arguments.isSuggest() && !scanResults.getSuggestions().getSuggestedConfigurations().isEmpty()) {
            envFileContent.append(this.buildEnvs(scanResults.getSuggestions().getSuggestedConfigurations(), false)).append(System.lineSeparator());
        }
        if (envFileContent.length() != 0) {
            if (!Files.exists(target, new LinkOption[0])) {
                Files.createDirectories(target, new FileAttribute[0]);
            }
            Path p = target.resolve("configuration.env");
            Files.write(p, envFileContent.toString().getBytes(), new OpenOption[0]);
            files.put(OutputContent.OutputFile.ENV_FILE, p.toAbsolutePath());
        }
        return new OutputContent(files, dockerImageName);
    }

    private String buildEnvs(Map<Layer, Set<Env>> map, boolean isRequired) {
        StringBuilder envFileContent = new StringBuilder();
        for (Map.Entry<Layer, Set<Env>> entry : map.entrySet()) {
            envFileContent.append(System.lineSeparator()).append(System.lineSeparator()).append(isRequired ? "# Env required by the layer " : "# Env suggested by the layer ").append(entry.getKey().getName()).append(System.lineSeparator());
            for (Env env : entry.getValue()) {
                envFileContent.append("# ").append(env.getName()).append("=").append(env.getDescription()).append(System.lineSeparator());
            }
        }
        return envFileContent.toString();
    }

    void outputInformation(ScanResultsPrinter scanResultsPrinter, ScanResults scanResults) throws Exception {
        scanResultsPrinter.print(this.arguments, scanResults);
    }

    void outputCompactInformation(ScanResultsPrinter scanResultsPrinter, ScanResults scanResults) throws Exception {
        scanResultsPrinter.printCompact(this.arguments, scanResults);
    }

    String getCompactInformation(ScanResultsPrinter scanResultsPrinter, ScanResults scanResults) throws Exception {
        return scanResultsPrinter.getCompactInformation(this.arguments, scanResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path provisionServer(List<Path> binaries, GalleonProvisioningConfig activeConfig, MavenRepoManager resolver, OutputFormat format, boolean isCloud, Path target) throws Exception {
        Path tmpDir = null;
        Path originalTarget = target;
        if (OutputFormat.BOOTABLE_JAR.equals((Object)format)) {
            target = tmpDir = Files.createTempDirectory("wildfly-glow-bootable", new FileAttribute[0]);
        } else {
            IoUtils.recursiveDelete((Path)target);
        }
        Path ret = target;
        try {
            Utils.provisionServer(activeConfig, target.toAbsolutePath(), resolver, this.writer);
            if (!binaries.isEmpty()) {
                for (Path path : binaries) {
                    Path deploymentTarget = target.resolve(STANDALONE_PROFILE).resolve("deployments").resolve(path.getFileName().toString());
                    this.writer.info("Copy " + path + " to " + deploymentTarget);
                    Files.copy(path, deploymentTarget, new CopyOption[0]);
                }
            }
            if (OutputFormat.BOOTABLE_JAR.equals((Object)format)) {
                Path targetJarFile;
                Object bootableJarName = "";
                if (!binaries.isEmpty()) {
                    for (Path binary : binaries) {
                        int i = binary.getFileName().toString().lastIndexOf(".");
                        bootableJarName = (String)bootableJarName + binary.getFileName().toString().substring(0, i);
                    }
                } else {
                    bootableJarName = "hollow";
                }
                String string = this.arguments.getVersion() == null ? FeaturePacks.getLatestVersion() : this.arguments.getVersion();
                ret = targetJarFile = originalTarget.toAbsolutePath().resolve((String)bootableJarName + "-" + string + "-bootable.jar");
                Files.deleteIfExists(targetJarFile);
                throw new Exception("Bootable JAR packaging is disabled for 1.0.0.Alpha12, will be re-introduced in WildFly Glow 1.0.0.Beta1");
            }
        }
        finally {
            if (tmpDir != null) {
                IoUtils.recursiveDelete((Path)tmpDir);
            }
        }
        return ret;
    }

    private static void fixAddOns(ErrorIdentificationSession errorSession, Set<Layer> layers, LayerMapping mapping, Set<AddOn> allEnabledAddOns, Set<AddOn> possibleAddOns, Map<AddOn, String> disabledAddOns, Arguments arguments) throws URISyntaxException, IOException {
        TreeSet<String> familyOfAddOnsComplete = new TreeSet<String>();
        HashMap<String, TreeSet<AddOn>> membersInFamily = new HashMap<String, TreeSet<AddOn>>();
        HashMap<String, TreeSet<AddOn>> defaultMembersInFamily = new HashMap<String, TreeSet<AddOn>>();
        for (AddOn addOn : allEnabledAddOns) {
            Set<AddOn> members;
            if (addOn.isDefault()) {
                members = (Set)defaultMembersInFamily.get(addOn.getFamily());
                if (members == null) {
                    members = new TreeSet<AddOn>();
                    defaultMembersInFamily.put(addOn.getFamily(), (TreeSet<AddOn>)members);
                }
                members.add(addOn);
                continue;
            }
            members = (Set)membersInFamily.get(addOn.getFamily());
            if (members == null) {
                members = new TreeSet();
                membersInFamily.put(addOn.getFamily(), (TreeSet<AddOn>)members);
            }
            members.add(addOn);
        }
        TreeSet<String> treatedFamily = new TreeSet<String>();
        HashMap<String, TreeSet<AddOn>> addOnsThatFixsCardinality = new HashMap<String, TreeSet<AddOn>>();
        for (AddOn addOn : allEnabledAddOns) {
            Integer i = mapping.getAddOnsCardinalityInFamily().get(addOn.getFamily());
            if (i == null) continue;
            Set members = (Set)membersInFamily.get(addOn.getFamily());
            if (members.size() == i.intValue()) {
                familyOfAddOnsComplete.add(addOn.getFamily());
                TreeSet<AddOn> ao = (TreeSet<AddOn>)addOnsThatFixsCardinality.get(addOn.getFamily());
                if (ao == null) {
                    ao = new TreeSet<AddOn>();
                    addOnsThatFixsCardinality.put(addOn.getFamily(), ao);
                }
                ao.add(addOn);
                continue;
            }
            if (members.size() <= i || treatedFamily.contains(addOn.getFamily())) continue;
            treatedFamily.add(addOn.getFamily());
            boolean isError = true;
            for (AddOn ao : members) {
                for (AddOn ao2 : members) {
                    if (!ao.equals(ao2)) {
                        for (Layer l : ao2.getLayers()) {
                            if (!l.getDependencies().containsAll(ao.getLayers())) continue;
                            isError = false;
                            break;
                        }
                    }
                    if (isError) continue;
                    break;
                }
                if (isError) continue;
                break;
            }
            if (!isError) continue;
            errorSession.addError(new IdentifiedError("add-on cardinality violation", "add-ons family " + addOn.getFamily() + " accepts " + (Integer)i + " members although " + members.size() + " are configured : " + members, ErrorLevel.ERROR));
        }
        TreeSet<String> treatedDefaultFamily = new TreeSet<String>();
        TreeSet<String> disabledAddOnsDueToDefault = new TreeSet<String>();
        for (AddOn addOn : allEnabledAddOns) {
            Set members;
            if (!addOn.isDefault()) continue;
            Integer i = mapping.getAddOnsCardinalityInDefaultFamily().get(addOn.getFamily());
            if (i != null && (members = (Set)defaultMembersInFamily.get(addOn.getFamily())).size() > i && !treatedDefaultFamily.contains(addOn.getFamily())) {
                treatedDefaultFamily.add(addOn.getFamily());
                errorSession.addError(new IdentifiedError("add-on cardinality violation", "default in add-ons family " + addOn.getFamily() + " accepts " + i + " members although " + members.size() + " are configured : " + members, ErrorLevel.ERROR));
            }
            disabledAddOnsDueToDefault.add(addOn.getAssociatedNonDefault());
        }
        Iterator<AddOn> iterator = possibleAddOns.iterator();
        while (iterator.hasNext()) {
            AddOn addOn;
            addOn = iterator.next();
            if (allEnabledAddOns.contains(addOn)) {
                iterator.remove();
                continue;
            }
            if (familyOfAddOnsComplete.contains(addOn.getFamily())) {
                disabledAddOns.put(addOn, "add-on family " + addOn.getFamily() + " is complete");
                iterator.remove();
                continue;
            }
            if (addOn.isDefault()) {
                iterator.remove();
                continue;
            }
            if (!disabledAddOnsDueToDefault.contains(addOn.getName())) continue;
            disabledAddOns.put(addOn, "default add-on " + addOn.getName() + ":default is enabled");
            iterator.remove();
        }
        for (Layer l : layers) {
            String familyExpected = l.getExpectFamily();
            if (familyExpected == null) continue;
            boolean found = false;
            for (AddOn addOn : allEnabledAddOns) {
                if (!addOn.getFamily().equals(familyExpected)) continue;
                found = true;
                break;
            }
            if (found) continue;
            Set<AddOn> members = mapping.getAddOnFamilyMembers().get(familyExpected);
            IdentifiedError err = new IdentifiedError("expected add-on not found", "an add-on of the " + familyExpected + " family is expected by the " + l + " layer", ErrorLevel.ERROR);
            err.getPossibleAddons().addAll((Collection<AddOn>)members);
            errorSession.addError(err);
        }
        for (String family : addOnsThatFixsCardinality.keySet()) {
            Set addons = (Set)addOnsThatFixsCardinality.get(family);
            StringBuilder builder = new StringBuilder();
            for (AddOn ao : addons) {
                if (!arguments.getUserEnabledAddOns().contains(ao.getName())) continue;
                builder.append(Utils.getAddOnFix(ao, null));
            }
            if (builder.length() == 0) continue;
            IdentifiedError err = new IdentifiedError("expected add-on not found", "expected add-on not found in family " + family, ErrorLevel.ERROR);
            err.setFixed(builder.toString());
            errorSession.addError(err);
        }
    }

    private static GalleonProvisioningConfig buildProvisioningConfig(GalleonProvisioningConfig input, UniverseResolver universeResolver, Set<Layer> allBaseLayers, Layer baseLayer, Set<Layer> decorators, Set<Layer> excludedLayers, Map<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>> fpDependencies, String configName) throws ProvisioningException {
        HashMap<FeaturePackLocation.FPID, GalleonFeaturePackConfig> map = new HashMap<FeaturePackLocation.FPID, GalleonFeaturePackConfig>();
        HashMap<FeaturePackLocation.FPID, FeaturePackLocation.FPID> universeToGav = new HashMap<FeaturePackLocation.FPID, FeaturePackLocation.FPID>();
        for (GalleonFeaturePackConfig cfg : input.getFeaturePackDeps()) {
            FeaturePackLocation.FPID loc = null;
            FeaturePackLocation.FPID fPID = Utils.toMavenCoordinates(cfg.getLocation().getFPID(), universeResolver);
            for (FeaturePackLocation.FPID fPID2 : fpDependencies.keySet()) {
                if (!fPID.getProducer().equals((Object)fPID2.getProducer())) continue;
                loc = fPID2;
                break;
            }
            if (loc == null) {
                throw new ProvisioningException("Input fp " + cfg.getLocation() + " not found in resolved feature-packs " + fpDependencies.keySet());
            }
            map.put(loc, cfg);
            universeToGav.put(cfg.getLocation().getFPID(), loc);
        }
        HashMap<FeaturePackLocation.ProducerSpec, FeaturePackLocation.FPID> tmpFps = new HashMap<FeaturePackLocation.ProducerSpec, FeaturePackLocation.FPID>();
        FeaturePackLocation.FPID baseFPID = (FeaturePackLocation.FPID)universeToGav.get(((GalleonFeaturePackConfig)input.getFeaturePackDeps().iterator().next()).getLocation().getFPID());
        tmpFps.put(baseFPID.getProducer(), baseFPID);
        for (Layer layer : allBaseLayers) {
            for (FeaturePackLocation.FPID fPID : layer.getFeaturePacks()) {
                tmpFps.put(fPID.getProducer(), fPID);
            }
        }
        LinkedHashSet<FeaturePackLocation.FPID> activeFeaturePacks = new LinkedHashSet<FeaturePackLocation.FPID>();
        for (Object cfg : input.getFeaturePackDeps()) {
            FeaturePackLocation.FPID fPID = (FeaturePackLocation.FPID)universeToGav.get(cfg.getLocation().getFPID());
            FeaturePackLocation.FPID fPID3 = (FeaturePackLocation.FPID)tmpFps.get(fPID.getProducer());
            if (fPID3 == null) continue;
            activeFeaturePacks.add(fPID3);
        }
        HashSet<FeaturePackLocation.FPID> hashSet = new HashSet<FeaturePackLocation.FPID>();
        for (FeaturePackLocation.FPID fPID : activeFeaturePacks) {
            Set<FeaturePackLocation.ProducerSpec> set = fpDependencies.get(fPID);
            if (set == null) continue;
            for (FeaturePackLocation.ProducerSpec spec : set) {
                for (FeaturePackLocation.FPID af : activeFeaturePacks) {
                    if (!spec.equals((Object)af.getProducer()) || af.getProducer().getName().equals(baseFPID.getProducer().getName())) continue;
                    hashSet.add(af);
                }
            }
        }
        activeFeaturePacks.removeAll(hashSet);
        GalleonProvisioningConfig.Builder activeConfigBuilder = GalleonProvisioningConfig.builder();
        for (FeaturePackLocation.FPID fPID : activeFeaturePacks) {
            GalleonFeaturePackConfig.Builder fpBuilder = GalleonFeaturePackConfig.builder((FeaturePackLocation)fPID.getLocation());
            fpBuilder.setInheritConfigs(false);
            fpBuilder.setInheritPackages(false);
            GalleonFeaturePackConfig inCfg = (GalleonFeaturePackConfig)map.get(fPID);
            fpBuilder.includeAllPackages(inCfg.getIncludedPackages());
            activeConfigBuilder.addFeaturePackDep(fpBuilder.build());
        }
        GalleonConfigurationWithLayersBuilder galleonConfigurationWithLayersBuilder = GalleonConfigurationWithLayersBuilder.builder((String)STANDALONE_PROFILE, (String)configName);
        galleonConfigurationWithLayersBuilder.includeLayer(baseLayer.getName());
        for (Layer l : decorators) {
            galleonConfigurationWithLayersBuilder.includeLayer(l.getName());
        }
        for (Layer l : excludedLayers) {
            galleonConfigurationWithLayersBuilder.excludeLayer(l.getName());
        }
        activeConfigBuilder.addConfig(galleonConfigurationWithLayersBuilder.build());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("optional-packages", "passive+");
        hashMap.put("jboss-fork-embedded", "true");
        activeConfigBuilder.addOptions(hashMap);
        return activeConfigBuilder.build();
    }

    private static Map<Layer, Set<Layer>> findBaseLayer(LayerMapping mapping, Map<String, Layer> all) {
        HashMap<Layer, Set<Layer>> roots = new HashMap<Layer, Set<Layer>>();
        for (String k : all.keySet()) {
            Layer layer = all.get(k);
            String kind = layer.getProperties().get("org.wildfly.rule.kind");
            if (kind == null || !kind.equals("base-layer") && !kind.equals("default-base-layer")) continue;
            roots.put(layer, Utils.getTransitiveDependencies(all, layer, new HashSet<Layer>()));
        }
        HashMap<Layer, Set<Layer>> ret = new HashMap<Layer, Set<Layer>>();
        ret.put(mapping.getDefaultBaseLayer(), (Set)roots.get(mapping.getDefaultBaseLayer()));
        return ret;
    }
}

