/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.wildfly.glow.AddOn;
import org.wildfly.glow.Env;
import org.wildfly.glow.GlowMessageWriter;
import org.wildfly.glow.Layer;
import org.wildfly.glow.ScanArguments;
import org.wildfly.glow.ScanResults;
import org.wildfly.glow.error.ErrorLevel;
import org.wildfly.glow.error.IdentifiedError;

public class ScanResultsPrinter {
    private final GlowMessageWriter writer;

    public ScanResultsPrinter(GlowMessageWriter writer) {
        this.writer = writer;
    }

    void print(ScanArguments arguments, ScanResults scanResults) throws Exception {
        if (arguments.isCompact().booleanValue()) {
            this.printCompact(arguments, scanResults);
        } else {
            this.detailed(arguments, scanResults);
        }
    }

    void printCompact(ScanArguments arguments, ScanResults scanResults) throws Exception {
        this.writer.info(this.getCompactInformation(arguments, scanResults));
    }

    String getCompactInformation(ScanArguments arguments, ScanResults scanResults) throws Exception {
        StringBuilder compactBuilder = new StringBuilder();
        if (!arguments.getExecutionProfiles().isEmpty()) {
            compactBuilder.append(new TreeSet<String>(arguments.getExecutionProfiles()));
        }
        compactBuilder.append(new TreeSet<Layer>(scanResults.getDiscoveredLayers())).append("==>");
        compactBuilder.append(scanResults.getBaseLayer());
        for (Layer l : new TreeSet<Layer>(scanResults.getDecorators())) {
            compactBuilder.append(",").append(l.getName());
        }
        for (Layer l : new TreeSet<Layer>(scanResults.getExcludedLayers())) {
            compactBuilder.append(",-").append(l.getName());
        }
        return compactBuilder.toString();
    }

    private void detailed(ScanArguments arguments, ScanResults scanResults) throws Exception {
        this.writer.info("context: " + arguments.getExecutionContext());
        StringBuilder profileBuilder = new StringBuilder();
        profileBuilder.append("enabled profile: ");
        if (!arguments.getExecutionProfiles().isEmpty()) {
            for (String string : arguments.getExecutionProfiles()) {
                profileBuilder.append(string);
            }
        } else {
            profileBuilder.append("none");
        }
        this.writer.info(profileBuilder);
        this.writer.info("galleon discovery");
        StringBuilder builder = new StringBuilder();
        builder.append("- feature-packs").append("\n");
        for (GalleonFeaturePackConfig galleonFeaturePackConfig : scanResults.getProvisioningConfig().getFeaturePackDeps()) {
            builder.append("   ").append(galleonFeaturePackConfig.getLocation()).append("\n");
        }
        builder.append("- layers").append("\n");
        builder.append("   ").append(scanResults.getBaseLayer()).append("\n");
        for (Layer layer : scanResults.getDecorators()) {
            builder.append("   ").append(layer.getName()).append("\n");
        }
        if (!scanResults.getExcludedLayers().isEmpty()) {
            builder.append("- excluded-layers\n");
            for (Layer layer : scanResults.getExcludedLayers()) {
                builder.append("   ").append(layer.getName()).append("\n");
            }
        }
        this.writer.info(builder);
        if (!scanResults.getEnabledAddOns().isEmpty()) {
            this.writer.info("enabled add-ons");
            StringBuilder stringBuilder = new StringBuilder();
            for (AddOn addOn : scanResults.getEnabledAddOns()) {
                stringBuilder.append("- ").append(addOn.getName()).append((String)(addOn.getDescription() != null ? " : " + addOn.getDescription() : "")).append("\n");
            }
            this.writer.info(stringBuilder);
        }
        if (!scanResults.getDisabledAddOns().isEmpty()) {
            this.writer.info("disabled add-ons");
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<AddOn, String> entry : scanResults.getDisabledAddOns().entrySet()) {
                stringBuilder.append("- ").append(entry.getKey().getName()).append(": ").append(entry.getValue()).append("\n");
            }
            this.writer.info(stringBuilder);
        }
        ArrayList<StringBuilder> arrayList = new ArrayList<StringBuilder>();
        ArrayList<StringBuilder> arrayList2 = new ArrayList<StringBuilder>();
        ArrayList<StringBuilder> arrayList3 = new ArrayList<StringBuilder>();
        for (IdentifiedError identifiedError : scanResults.getErrorSession().getErrors()) {
            if (identifiedError.isFixed()) {
                StringBuilder fixBuilder = new StringBuilder();
                fixBuilder.append("* ").append(identifiedError.getDescription()).append(" is fixed\n");
                fixBuilder.append("  - ").append(identifiedError.getFixMessage()).append("\n");
                arrayList.add(fixBuilder);
                continue;
            }
            StringBuilder errorBuilder = new StringBuilder();
            errorBuilder.append("* ").append(identifiedError.getDescription()).append("\n");
            if (!identifiedError.getPossibleAddons().isEmpty()) {
                errorBuilder.append("  To correct this error, enable one of the following add-ons:\n");
                for (AddOn addOn : identifiedError.getPossibleAddons()) {
                    errorBuilder.append("  - ").append(addOn.getName()).append("\n");
                }
            }
            if (identifiedError.getErrorLevel() == ErrorLevel.ERROR) {
                arrayList2.add(errorBuilder);
                continue;
            }
            arrayList3.add(errorBuilder);
        }
        if (!arrayList2.isEmpty()) {
            this.writer.info("identified errors");
            for (StringBuilder stringBuilder : arrayList2) {
                this.writer.error(stringBuilder);
            }
        }
        if (!arrayList3.isEmpty()) {
            this.writer.info("possible issues");
            for (StringBuilder stringBuilder : arrayList3) {
                this.writer.warn(stringBuilder);
            }
        }
        if (!arrayList.isEmpty()) {
            this.writer.info("identified fixes");
            for (StringBuilder stringBuilder : arrayList) {
                this.writer.info(stringBuilder);
            }
        }
        if (!scanResults.getSuggestions().getStronglySuggestedConfigurations().isEmpty()) {
            this.writer.warn("strongly suggested configuration");
            for (Map.Entry entry : scanResults.getSuggestions().getStronglySuggestedConfigurations().entrySet()) {
                this.writer.warn(ScanResultsPrinter.buildSuggestions((Layer)entry.getKey(), (Set)entry.getValue()));
            }
            this.writer.warn("");
        }
        String suggestedConfigs = ScanResultsPrinter.buildSuggestions(scanResults.getSuggestions().getSuggestedConfigurations());
        if (arguments.isSuggest()) {
            this.writer.info("suggestions");
            if (scanResults.getSuggestions().getPossibleAddOns().isEmpty() && scanResults.getSuggestions().getPossibleProfiles().isEmpty() && suggestedConfigs.isEmpty()) {
                this.writer.info("none");
            } else {
                if (!suggestedConfigs.isEmpty()) {
                    this.writer.info("\n* you could set the following env variables");
                    this.writer.info(suggestedConfigs);
                }
                if (!scanResults.getSuggestions().getPossibleAddOns().isEmpty()) {
                    this.writer.info("* you could enable the following add-ons:");
                    TreeMap<String, TreeSet<AddOn>> treeMap = new TreeMap<String, TreeSet<AddOn>>();
                    for (AddOn addOn : scanResults.getSuggestions().getPossibleAddOns()) {
                        TreeSet<AddOn> addons = (TreeSet<AddOn>)treeMap.get(addOn.getFamily());
                        if (addons == null) {
                            addons = new TreeSet<AddOn>();
                            treeMap.put(addOn.getFamily(), addons);
                        }
                        addons.add(addOn);
                    }
                    StringBuilder possibleBuilder = new StringBuilder();
                    for (String family : treeMap.keySet()) {
                        possibleBuilder.append("  - ").append(family).append(" add-ons:\n");
                        for (AddOn l : (Set)treeMap.get(family)) {
                            possibleBuilder.append("    - ").append(l.getName()).append((String)(l.getDescription() != null ? " : " + l.getDescription() : "")).append("\n");
                        }
                    }
                    this.writer.info(possibleBuilder);
                }
                if (!scanResults.getSuggestions().getPossibleProfiles().isEmpty()) {
                    this.writer.info("* you could enable profiles:");
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String string : scanResults.getSuggestions().getPossibleProfiles()) {
                        stringBuilder.append("  - ").append(string).append("\n");
                    }
                    this.writer.info(stringBuilder);
                }
            }
        } else if (!(scanResults.getSuggestions().getPossibleAddOns().isEmpty() && scanResults.getSuggestions().getPossibleAddOns().isEmpty() && suggestedConfigs.isEmpty())) {
            this.writer.info("Some suggestions have been found. You could enable suggestions with --suggest option.");
        }
    }

    private static String buildSuggestions(Map<Layer, Set<Env>> map) throws URISyntaxException, IOException {
        StringBuilder suggestedConfigsBuilder = new StringBuilder();
        for (Layer l : map.keySet()) {
            suggestedConfigsBuilder.append(ScanResultsPrinter.buildSuggestions(l, map.get(l)));
        }
        return suggestedConfigsBuilder.toString();
    }

    private static String buildSuggestions(Layer layer, Set<Env> envs) throws URISyntaxException, IOException {
        StringBuilder suggestedConfigsBuilder = new StringBuilder();
        suggestedConfigsBuilder.append("\n").append(layer.getName()).append(":\n");
        Iterator<Env> it = envs.iterator();
        while (it.hasNext()) {
            Env e = it.next();
            suggestedConfigsBuilder.append(" - ").append(e.getName()).append("=").append(e.getDescription());
            if (!it.hasNext()) continue;
            suggestedConfigsBuilder.append("\n");
        }
        return suggestedConfigsBuilder.toString();
    }
}

