/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.wildfly.glow.Utils;
import org.yaml.snakeyaml.Yaml;

public class FeaturePacks {
    private static final String VERSIONS = "versions.yaml";
    private static final String PROVISIONING_FILE_RADICAL = "/provisioning-";
    private static final String TECH_PREVIEW = "/tech-preview/";

    public static Path getFeaturePacks(String version, String context, boolean techPreview) throws Exception {
        String rootURL = FeaturePacks.getFeaturePacksURL();
        Yaml yaml = new Yaml();
        if (version == null) {
            Map map = (Map)yaml.load(new URI(rootURL + VERSIONS).toURL().openStream());
            version = (String)map.get("latest");
        }
        Path p = Files.createTempFile("glow-provisioning-", context, new FileAttribute[0]);
        try (InputStream in = new URL(rootURL + version + (techPreview ? TECH_PREVIEW : "") + PROVISIONING_FILE_RADICAL + context + ".xml").openStream();){
            Files.copy(in, p, StandardCopyOption.REPLACE_EXISTING);
        }
        p.toFile().deleteOnExit();
        return p;
    }

    public static String getFeaturePacksURL() throws Exception {
        Object rootURL = Utils.getConfigEntry("wildfly-glow-galleon-feature-packs-url");
        if (rootURL == null) {
            throw new Exception("No wildfly-glow-galleon-feature-packs-url entry found");
        }
        if (!((String)rootURL).endsWith("/")) {
            rootURL = (String)rootURL + "/";
        }
        return rootURL;
    }

    public static Set<String> getAllVersions() throws Exception {
        String rootURL = FeaturePacks.getFeaturePacksURL();
        TreeSet<String> set = new TreeSet<String>();
        Yaml yaml = new Yaml();
        Map map = (Map)yaml.load(new URI(rootURL + VERSIONS).toURL().openStream());
        set.addAll(Arrays.asList(((String)map.get("versions")).split(",")));
        return set;
    }

    public static String getLatestVersion() throws Exception {
        String rootURL = FeaturePacks.getFeaturePacksURL();
        Yaml yaml = new Yaml();
        Map map = (Map)yaml.load(new URI(rootURL + VERSIONS).toURL().openStream());
        return (String)map.get("latest");
    }
}

