/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.wildfly.glow.GoOfflineArguments;
import org.wildfly.glow.HiddenPropertiesAccessor;
import org.wildfly.glow.OutputFormat;
import org.wildfly.glow.ScanArguments;

public class Arguments
implements GoOfflineArguments,
ScanArguments {
    private static final String COMPACT_PROPERTY = "compact";
    private static final String MANUAL_LAYERS_PROPERTY = "org.wildfly.glow.manual.layers";
    private final Set<String> executionProfiles;
    private final Set<String> userEnabledAddOns;
    private final List<Path> binaries;
    private final Path provisioningXML;
    private final OutputFormat output;
    private final String executionContext;
    private final boolean suggest;
    private final String version;
    private final String configName;
    private final Set<String> layersForJndi;
    public static final String CLOUD_EXECUTION_CONTEXT = "cloud";
    public static final String BARE_METAL_EXECUTION_CONTEXT = "bare-metal";
    public static final String STANDALONE_XML = "standalone.xml";
    private final Boolean compact;
    private final Set<String> manualLayers;
    private final boolean verbose;
    private final boolean techPreview;

    protected Arguments(String executionContext, Set<String> executionProfiles, Set<String> userEnabledAddOns, List<Path> binaries, Path provisioningXML, OutputFormat output, boolean suggest, String version, String configName, Set<String> layersForJndi, boolean verbose, boolean techPreview) {
        this.executionProfiles = executionProfiles;
        this.userEnabledAddOns = userEnabledAddOns;
        this.binaries = binaries;
        this.provisioningXML = provisioningXML;
        this.output = output;
        this.executionContext = executionContext == null ? BARE_METAL_EXECUTION_CONTEXT : executionContext;
        this.suggest = suggest;
        this.version = version;
        this.configName = configName == null ? STANDALONE_XML : configName;
        this.layersForJndi = layersForJndi;
        this.verbose = verbose;
        this.techPreview = techPreview;
        HiddenPropertiesAccessor hiddenPropertiesAccessor = new HiddenPropertiesAccessor();
        this.compact = Boolean.parseBoolean(hiddenPropertiesAccessor.getProperty(COMPACT_PROPERTY));
        String manualLayers = hiddenPropertiesAccessor.getProperty(MANUAL_LAYERS_PROPERTY);
        this.manualLayers = manualLayers == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(manualLayers.split(",")));
    }

    @Override
    public String getConfigName() {
        return this.configName;
    }

    @Override
    public Set<String> getExecutionProfiles() {
        return this.executionProfiles;
    }

    @Override
    public Set<String> getUserEnabledAddOns() {
        return this.userEnabledAddOns;
    }

    @Override
    public List<Path> getBinaries() {
        return this.binaries;
    }

    @Override
    public Path getProvisioningXML() {
        return this.provisioningXML;
    }

    @Override
    public OutputFormat getOutput() {
        return this.output;
    }

    @Override
    public String getExecutionContext() {
        return this.executionContext;
    }

    @Override
    public boolean isSuggest() {
        return this.suggest;
    }

    @Override
    public boolean isCloud() {
        return CLOUD_EXECUTION_CONTEXT.equals(this.executionContext);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    Set<String> getManualLayers() {
        return this.manualLayers;
    }

    public Set<String> getLayersForJndi() {
        return this.layersForJndi;
    }

    @Override
    public Boolean isCompact() {
        return this.compact;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public boolean isTechPreview() {
        return this.techPreview;
    }

    static GoOfflineArguments.Builder goOfflineBuilder() {
        return new GoOfflineArguments.Builder();
    }

    public static ScanArguments.Builder scanBuilder() {
        return new ScanArguments.Builder();
    }
}

