/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow;

import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.config.ProvisioningConfig;
import org.wildfly.glow.AddOn;
import org.wildfly.glow.GlowMessageWriter;
import org.wildfly.glow.GlowSession;
import org.wildfly.glow.Layer;
import org.wildfly.glow.OutputContent;
import org.wildfly.glow.ScanResultsPrinter;
import org.wildfly.glow.Suggestions;
import org.wildfly.glow.error.ErrorIdentificationSession;

public class ScanResults {
    private final GlowSession glowSession;
    private final Set<Layer> discoveredLayers;
    private final Set<Layer> excludedLayers;
    private final Layer baseLayer;
    private final Set<Layer> decorators;
    private final ProvisioningConfig provisioningConfig;
    private final ErrorIdentificationSession errorSession;
    private final Map<AddOn, String> disabledAddOns;
    private final Set<AddOn> enabledAddOns;
    private final Suggestions suggestions;

    ScanResults(GlowSession glowSession, Set<Layer> discoveredLayers, Set<Layer> excludedLayers, Layer baseLayer, Set<Layer> decorators, ProvisioningConfig provisioningConfig, Set<AddOn> enabledAddOns, Map<AddOn, String> disabledAddOns, Suggestions suggestions, ErrorIdentificationSession errorSession) {
        this.glowSession = glowSession;
        this.discoveredLayers = discoveredLayers;
        this.excludedLayers = excludedLayers;
        this.baseLayer = baseLayer;
        this.decorators = decorators;
        this.provisioningConfig = provisioningConfig;
        this.disabledAddOns = disabledAddOns;
        this.enabledAddOns = enabledAddOns;
        this.suggestions = suggestions;
        this.errorSession = errorSession;
    }

    public Set<Layer> getDiscoveredLayers() {
        return this.discoveredLayers;
    }

    public Set<Layer> getExcludedLayers() {
        return this.excludedLayers;
    }

    public Layer getBaseLayer() {
        return this.baseLayer;
    }

    public Set<Layer> getDecorators() {
        return this.decorators;
    }

    public ProvisioningConfig getProvisioningConfig() {
        return this.provisioningConfig;
    }

    public Suggestions getSuggestions() {
        return this.suggestions;
    }

    public ErrorIdentificationSession getErrorSession() {
        return this.errorSession;
    }

    public Map<AddOn, String> getDisabledAddOns() {
        return this.disabledAddOns;
    }

    public Set<AddOn> getEnabledAddOns() {
        return this.enabledAddOns;
    }

    public OutputContent outputConfig(Path target, String dockerImageName) throws Exception {
        return this.glowSession.outputConfig(this, target, dockerImageName);
    }

    public void outputInformation() throws Exception {
        this.outputInformation(GlowMessageWriter.DEFAULT);
    }

    public void outputCompactInformation() throws Exception {
        this.outputCompactInformation(GlowMessageWriter.DEFAULT);
    }

    public void outputInformation(GlowMessageWriter writer) throws Exception {
        ScanResultsPrinter printer = new ScanResultsPrinter(writer);
        this.glowSession.outputInformation(printer, this);
    }

    public void outputCompactInformation(GlowMessageWriter writer) throws Exception {
        ScanResultsPrinter printer = new ScanResultsPrinter(writer);
        this.glowSession.outputCompactInformation(printer, this);
    }

    public String getCompactInformation() throws Exception {
        ScanResultsPrinter printer = new ScanResultsPrinter(GlowMessageWriter.DEFAULT);
        return this.glowSession.getCompactInformation(printer, this);
    }
}

