/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow;

import aQute.bnd.classfile.Attribute;
import aQute.bnd.classfile.ClassFile;
import aQute.bnd.classfile.CodeAttribute;
import aQute.bnd.classfile.ConstantPool;
import aQute.bnd.classfile.FieldInfo;
import aQute.bnd.classfile.LocalVariableTableAttribute;
import aQute.bnd.classfile.LocalVariableTypeTableAttribute;
import aQute.bnd.classfile.MethodInfo;
import aQute.bnd.classfile.SignatureAttribute;
import aQute.lib.io.ByteBufferDataInput;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.JarIndexer;
import org.jboss.jandex.Type;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.wildfly.glow.ContextLookupInfo;
import org.wildfly.glow.DeploymentFileRuleInspector;
import org.wildfly.glow.DirectoryIndexer;
import org.wildfly.glow.Layer;
import org.wildfly.glow.LayerMapping;
import org.wildfly.glow.NestedWarOrExplodedArchiveFileVisitor;
import org.wildfly.glow.ResourceInjectionJndiInfo;
import org.wildfly.glow.Utils;
import org.wildfly.glow.error.ErrorIdentificationSession;

public class DeploymentScanner
implements AutoCloseable {
    private final Path binary;
    private final Path tempDirectory;
    private boolean verbose;
    private final Set<Pattern> excludeArchivesFromScan;
    private ArchiveType archiveType;
    private DeploymentScanner parent;
    private final boolean isArchive;

    public DeploymentScanner(Path binary, boolean verbose, Set<Pattern> excludeArchivesFromScan) throws IOException {
        this(null, binary, verbose, excludeArchivesFromScan);
    }

    private DeploymentScanner(DeploymentScanner parent, Path binary, boolean verbose, Set<Pattern> excludeArchivesFromScan) throws IOException {
        this.parent = parent;
        this.tempDirectory = parent == null ? Files.createTempDirectory("glow", new FileAttribute[0]) : parent.tempDirectory;
        this.verbose = verbose;
        this.excludeArchivesFromScan = excludeArchivesFromScan;
        if (!Files.exists(binary, new LinkOption[0])) {
            throw new IllegalArgumentException(binary.normalize().toAbsolutePath() + " is not an archive");
        }
        this.isArchive = !Files.isDirectory(binary, new LinkOption[0]);
        FileNameParts fileNameParts = FileNameParts.parse(binary);
        this.archiveType = fileNameParts.archiveType;
        if (parent == null) {
            this.binary = binary;
        } else if (this.isArchive) {
            this.binary = Files.createTempFile(this.tempDirectory, fileNameParts.coreName, fileNameParts.archiveType.suffix, new FileAttribute[0]);
            Files.delete(this.binary);
            Files.copy(binary, this.binary, new CopyOption[0]);
        } else {
            this.binary = binary;
        }
    }

    @Override
    public void close() {
        if (this.parent != null && this.binary != null) {
            try {
                if (this.isArchive) {
                    Files.delete(this.binary);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.parent == null) {
            IoUtils.recursiveDelete((Path)this.tempDirectory);
        }
    }

    public void scan(LayerMapping mapping, Set<Layer> layers, Map<String, Layer> all, ErrorIdentificationSession errorSession) throws Exception {
        LinkedHashSet<Layer> discoveredLayers = new LinkedHashSet<Layer>();
        DeploymentScanContext ctx = new DeploymentScanContext(mapping, discoveredLayers, all, errorSession);
        this.scan(ctx);
        for (Layer l : discoveredLayers) {
            if (l.isBanned()) continue;
            layers.add(l);
        }
        errorSession.collectEndOfScanErrors(this.verbose, ctx.resourceInjectionJndiInfos, ctx.contextLookupInfos, ctx.allClasses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(DeploymentScanContext ctx) throws Exception {
        this.scanAnnotations(ctx);
        FileSystem fs = this.isArchive ? ZipUtils.newFileSystem((Path)this.binary) : this.binary.getFileSystem();
        try {
            Path rootPath = this.isArchive ? fs.getPath("/", new String[0]) : this.binary;
            this.scanTypesAndChildren(rootPath, ctx);
            ctx.layers.addAll(this.inspectDeployment(rootPath, ctx));
        }
        finally {
            if (this.isArchive) {
                fs.close();
            }
        }
    }

    private void scanAnnotations(DeploymentScanContext ctx) throws IOException {
        Path jd;
        Indexer indexer = new Indexer();
        Index index = this.isArchive ? JarIndexer.createJarIndex((File)this.binary.toFile(), (Indexer)indexer, (boolean)false, (boolean)true, (boolean)false).getIndex() : DirectoryIndexer.indexDirectory(this.binary.toFile(), indexer);
        for (ClassInfo ci : index.getKnownClasses()) {
            for (AnnotationInstance ai : ci.annotations()) {
                this.handleResourceInjectionAnnotations(ai, ctx);
                Set<Layer> l = ctx.mapping.getAnnotations().get(ai.name().toString());
                if (l != null) {
                    ctx.layers.addAll(l);
                    LayerMapping.addRule(LayerMapping.RULE.ANNOTATION, l, ai.name().toString());
                    continue;
                }
                l = ctx.mapping.getAnnotations().get(ai.name().packagePrefix());
                if (l != null) {
                    ctx.layers.addAll(l);
                    LayerMapping.addRule(LayerMapping.RULE.ANNOTATION, l, ai.name().packagePrefix() + ".*");
                    continue;
                }
                for (String s : ctx.mapping.getAnnotations().keySet()) {
                    Set<Layer> layers;
                    Pattern p;
                    if (!Utils.isPattern(s) || !(p = Pattern.compile(s)).matcher(ai.name().toString()).matches() || (layers = ctx.mapping.getAnnotations().get(s)) == null) continue;
                    LayerMapping.addRule(LayerMapping.RULE.ANNOTATION, layers, s);
                    ctx.layers.addAll(layers);
                }
            }
        }
        int i = this.binary.toFile().getName().lastIndexOf(".");
        String ext = this.binary.toFile().getName().substring(i + 1);
        String name = this.binary.toFile().getName().substring(0, i) + "-jandex";
        Path parent = this.binary.getParent();
        Path path = jd = parent == null ? Paths.get(name + "." + ext, new String[0]) : parent.resolve(name + "." + ext);
        if (Files.exists(jd, new LinkOption[0])) {
            Files.delete(jd);
        }
    }

    private void handleResourceInjectionAnnotations(AnnotationInstance annotationInstance, DeploymentScanContext ctx) {
        if (annotationInstance.name().toString().equals("jakarta.annotation.Resource")) {
            Layer l;
            AnnotationTarget tgt = annotationInstance.target();
            AnnotationValue typeFromAnnotation = annotationInstance.value("type");
            String resourceClassName = null;
            if (typeFromAnnotation != null) {
                resourceClassName = typeFromAnnotation.asClass().toString();
            } else if (tgt.kind() == AnnotationTarget.Kind.FIELD) {
                resourceClassName = tgt.asField().type().toString();
            } else if (tgt.kind() == AnnotationTarget.Kind.METHOD) {
                org.jboss.jandex.MethodInfo mi = tgt.asMethod();
                if (this.isSetter(mi)) {
                    resourceClassName = ((Type)mi.parameterTypes().get(0)).toString();
                }
            } else if (tgt.kind() == AnnotationTarget.Kind.CLASS) {
                resourceClassName = Object.class.getName();
            }
            Object injectionPoint = null;
            if (tgt.kind() == AnnotationTarget.Kind.CLASS) {
                injectionPoint = tgt.asClass().toString();
            } else if (tgt.kind() == AnnotationTarget.Kind.FIELD) {
                injectionPoint = tgt.asField().declaringClass().toString() + "." + tgt.asField().name();
            } else if (tgt.kind() == AnnotationTarget.Kind.METHOD && this.isSetter(tgt.asMethod())) {
                injectionPoint = tgt.asMethod().declaringClass().toString() + "." + tgt.asMethod().name() + "()";
            }
            HashSet<Layer> resourceLayers = new HashSet<Layer>();
            String jndiName = this.findJndiName(annotationInstance);
            if (jndiName != null && (l = this.lookupJndi(jndiName, ctx)) != null) {
                resourceLayers.add(l);
            }
            if (resourceClassName != null) {
                Set<Layer> layer = this.lookup(resourceClassName, ctx);
                if (layer != null) {
                    resourceLayers.addAll(layer);
                }
                ResourceInjectionJndiInfo info = new ResourceInjectionJndiInfo(resourceLayers, resourceClassName, (String)injectionPoint, jndiName);
                ctx.resourceInjectionJndiInfos.put(resourceClassName, info);
            }
        }
    }

    private boolean isSetter(org.jboss.jandex.MethodInfo methodInfo) {
        return methodInfo.name().startsWith("set") && methodInfo.parameterTypes().size() == 1;
    }

    private String findJndiName(AnnotationInstance annotationInstance) {
        String lookup = this.getAnnotationValue(annotationInstance, "mappedName");
        if (lookup != null) {
            return lookup;
        }
        lookup = this.getAnnotationValue(annotationInstance, "lookup");
        if (lookup != null) {
            return lookup;
        }
        return null;
    }

    private String getAnnotationValue(AnnotationInstance instance, String name) {
        AnnotationValue value = instance.value(name);
        if (value == null) {
            return null;
        }
        return value.asString();
    }

    private void scanTypesAndChildren(final Path archiveContentRoot, final DeploymentScanContext ctx) throws Exception {
        Files.walkFileTree(archiveContentRoot, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, new NestedWarOrExplodedArchiveFileVisitor(archiveContentRoot, this.isArchive){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path relativeFile;
                String fileName = file.getFileName().toString();
                if (fileName.endsWith(".class")) {
                    if (DeploymentScanner.this.archiveType != ArchiveType.EAR) {
                        DeploymentScanner.this.scanClass(file, ctx);
                    }
                } else if (ArchiveType.isArchiveName(file) && DeploymentScanner.this.archiveType.isValidArchiveLocation(relativeFile = archiveContentRoot.relativize(file))) {
                    DeploymentScanner.this.scanWithNestedScanner(file, ctx);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                FileVisitResult result = super.preVisitDirectory(dir, attrs);
                if (result == FileVisitResult.CONTINUE) {
                    return FileVisitResult.CONTINUE;
                }
                Path relativeFile = archiveContentRoot.relativize(dir);
                if (DeploymentScanner.this.archiveType.isValidArchiveLocation(relativeFile)) {
                    DeploymentScanner.this.scanWithNestedScanner(dir, ctx);
                }
                return result;
            }
        });
    }

    private void scanWithNestedScanner(Path file, DeploymentScanContext ctx) throws IOException {
        for (Pattern exclude : this.excludeArchivesFromScan) {
            if (!exclude.matcher(file.getFileName().toString()).matches()) continue;
            return;
        }
        try (DeploymentScanner nestedScanner = new DeploymentScanner(this, file, this.verbose, this.excludeArchivesFromScan);){
            try {
                nestedScanner.scan(ctx);
            }
            catch (IOException | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void scanClass(Path file, DeploymentScanContext ctx) throws IOException {
        int i;
        byte[] content = Files.readAllBytes(file);
        DataInput in = ByteBufferDataInput.wrap((byte[])content);
        ClassFile clazz = ClassFile.parseClassFile((DataInput)in);
        ctx.allClasses.add(clazz.this_class.replaceAll("/", "."));
        for (i = 0; i < clazz.constant_pool.size(); ++i) {
            Object obj = clazz.constant_pool.entry(i);
            if (obj instanceof ConstantPool.ClassInfo) {
                ConstantPool.ClassInfo ci = (ConstantPool.ClassInfo)obj;
                String className = (String)clazz.constant_pool.entry(ci.class_index);
                className = className.replaceAll("/", ".");
                this.lookup(className, ctx);
                continue;
            }
            if (!(obj instanceof ConstantPool.FieldrefInfo)) continue;
            ConstantPool.FieldrefInfo info = (ConstantPool.FieldrefInfo)obj;
            ConstantPool.NameAndTypeInfo ntinfo = (ConstantPool.NameAndTypeInfo)clazz.constant_pool.entry(info.name_and_type_index);
            String className = this.formatClassName((String)clazz.constant_pool.entry(ntinfo.descriptor_index));
            this.lookup(className, ctx);
        }
        for (i = 0; i < clazz.fields.length; ++i) {
            FieldInfo fi = clazz.fields[i];
            String descriptor = this.formatClassName(fi.descriptor);
            this.lookup(descriptor, ctx);
            for (String type : this.extractClassesFromFieldSignatureAttribute(fi)) {
                this.lookup(type, ctx);
            }
        }
        for (i = 0; i < clazz.methods.length; ++i) {
            MethodInfo mi = clazz.methods[i];
            for (String type : this.parseMethodDescriptor(mi.descriptor)) {
                this.lookup(type, ctx);
            }
            for (String type : this.extractTypeVariablesFromMethodSignatureAttribute(mi)) {
                this.lookup(type, ctx);
            }
            for (String type : this.parseLocalVariableAndLocalVariableTypeTables(mi)) {
                this.lookup(type, ctx);
            }
            for (String type : this.parseLocalVariableTypeTable(mi)) {
                this.lookup(type, ctx);
            }
        }
        this.lookForContextLookups(content, ctx);
    }

    private String trimArrayDimensionsFromDescriptor(String descriptor) {
        for (int j = 0; j < descriptor.length(); ++j) {
            if (descriptor.charAt(j) == '[') continue;
            if (j <= 0) break;
            descriptor = descriptor.substring(j);
            break;
        }
        return descriptor;
    }

    private String formatClassName(String className) {
        if ((className = this.trimArrayDimensionsFromDescriptor(className)).startsWith("L")) {
            className = className.substring(1, className.length() - 1);
        }
        className = className.replaceAll("/", ".");
        return className;
    }

    Set<String> parseMethodDescriptor(String descriptor) {
        HashSet<String> types = new HashSet<String>();
        StringBuilder builder = null;
        for (char c : descriptor.toCharArray()) {
            if (c == 'L') {
                builder = new StringBuilder();
                builder.append(c);
                continue;
            }
            if (c == ';') {
                builder.append(c);
                types.add(this.formatClassName(builder.toString()));
                builder = null;
                continue;
            }
            if (builder == null) continue;
            builder.append(c);
        }
        return types;
    }

    private Set<String> extractTypeVariablesFromMethodSignatureAttribute(MethodInfo mi) {
        String signature = this.getSignatureAttributeSignature(mi.attributes);
        if (signature == null) {
            return Collections.emptySet();
        }
        String[] parts = signature.split("\\(|\\)", 0);
        List list = Arrays.stream(parts).map(v -> v.trim()).filter(v -> v.length() > 0).map(v -> this.trimArrayDimensionsFromDescriptor((String)v)).filter(v -> v.startsWith("L")).collect(Collectors.toList());
        HashSet<String> types = new HashSet<String>();
        for (String current : list) {
            types.addAll(this.extractClassesSignatureForMethod(current));
        }
        return types;
    }

    private String getSignatureAttributeSignature(Attribute[] attributes) {
        for (Attribute attribute : attributes) {
            if (!(attribute instanceof SignatureAttribute)) continue;
            return ((SignatureAttribute)attribute).signature;
        }
        return null;
    }

    private Set<String> extractClassesFromFieldSignatureAttribute(FieldInfo fieldInfo) {
        String signature = this.getSignatureAttributeSignature(fieldInfo.attributes);
        if (signature == null) {
            return Collections.emptySet();
        }
        return this.extractClassesSignatureForField(signature);
    }

    private Set<String> extractClassesSignatureForField(String signature) {
        String[] parts = signature.split("<|>|,");
        Set<String> set = Arrays.stream(parts).map(v -> v.trim()).filter(v -> v.length() > 0).map(v -> this.formatClassName((String)v)).collect(Collectors.toSet());
        return set;
    }

    private Set<String> extractClassesSignatureForMethod(String signature) {
        String[] parts = signature.split("<|>|,|;");
        HashSet<String> types = new HashSet<String>();
        for (String string : parts) {
            String string2;
            String string3 = string.trim();
            if (string3.length() <= 0 || !(string2 = this.trimArrayDimensionsFromDescriptor(string3)).startsWith("L")) continue;
            String string4 = string2 + ";";
            types.add(this.formatClassName(string4));
        }
        return types;
    }

    private Set<String> parseLocalVariableAndLocalVariableTypeTables(MethodInfo mi) {
        HashSet<String> types = new HashSet<String>();
        for (Attribute attr : mi.attributes) {
            if (!(attr instanceof CodeAttribute)) continue;
            CodeAttribute codeAttribute = (CodeAttribute)attr;
            for (Attribute attribute : codeAttribute.attributes) {
                String desc;
                if (attribute instanceof LocalVariableTableAttribute) {
                    LocalVariableTableAttribute localVariableTableAttribute = (LocalVariableTableAttribute)attribute;
                    for (LocalVariableTableAttribute.LocalVariable localVariable : localVariableTableAttribute.local_variable_table) {
                        desc = localVariable.descriptor;
                        types.add(this.formatClassName(desc));
                    }
                    continue;
                }
                if (!(attribute instanceof LocalVariableTypeTableAttribute)) continue;
                LocalVariableTypeTableAttribute localVariableTypeTableAttribute = (LocalVariableTypeTableAttribute)attribute;
                for (LocalVariableTableAttribute.LocalVariable localVariable : localVariableTypeTableAttribute.local_variable_type_table) {
                    desc = localVariable.signature;
                    types.addAll(this.extractClassesSignatureForMethod(desc));
                }
            }
        }
        return types;
    }

    private Set<String> parseLocalVariableTypeTable(MethodInfo mi) {
        HashSet<String> types = new HashSet<String>();
        for (Attribute attr : mi.attributes) {
            if (!(attr instanceof CodeAttribute)) continue;
            CodeAttribute codeAttribute = (CodeAttribute)attr;
            for (Attribute attribute : codeAttribute.attributes) {
                if (!(attribute instanceof LocalVariableTableAttribute)) continue;
                LocalVariableTableAttribute localVariableTableAttribute = (LocalVariableTableAttribute)attribute;
                for (LocalVariableTableAttribute.LocalVariable lv : localVariableTableAttribute.local_variable_table) {
                    String desc = lv.descriptor;
                    types.add(this.formatClassName(desc));
                }
            }
        }
        return types;
    }

    private void lookForContextLookups(byte[] classBytes, DeploymentScanContext ctx) {
        ClassReader cr = new ClassReader(classBytes);
        ContextLookupClassVisitor classVisitor = new ContextLookupClassVisitor(ctx);
        cr.accept((ClassVisitor)classVisitor, 0);
    }

    private Layer lookupJndi(String jndiName, DeploymentScanContext ctx) {
        Layer layer = null;
        for (Layer l : ctx.allLayers.values()) {
            if (!l.getBringDatasources().contains(jndiName)) continue;
            layer = l;
            ctx.layers.add(l);
            LayerMapping.addRule(LayerMapping.RULE.BRING_DATASOURCE, l, jndiName);
        }
        return layer;
    }

    private Set<Layer> lookup(String className, DeploymentScanContext ctx) {
        Map<String, Set<Layer>> map = ctx.mapping.getConstantPoolClassInfos();
        Set<Layer> l = map.get(className);
        if (l == null) {
            String pkgPrefix;
            int index = className.lastIndexOf(".");
            if (index != -1 && (l = map.get(pkgPrefix = className.substring(0, index))) != null) {
                LayerMapping.addRule(LayerMapping.RULE.JAVA_TYPE, l, pkgPrefix + ".*");
            }
            if (l == null) {
                for (String s : map.keySet()) {
                    if (!Utils.isPattern(s)) continue;
                    Pattern p = Pattern.compile(s);
                    if (p.matcher(className).matches()) {
                        l = map.get(s);
                    }
                    if (l == null) continue;
                    LayerMapping.addRule(LayerMapping.RULE.JAVA_TYPE, l, s);
                }
            }
        } else {
            LayerMapping.addRule(LayerMapping.RULE.JAVA_TYPE, l, className);
        }
        if (l != null) {
            ctx.layers.addAll(l);
        }
        return l;
    }

    Set<Layer> inspectDeployment(Path rootPath, DeploymentScanContext ctx) throws Exception {
        DeploymentFileRuleInspector inspector = new DeploymentFileRuleInspector(rootPath, this.isArchive);
        TreeSet<Layer> set = new TreeSet<Layer>();
        for (String layer : ctx.allLayers.keySet()) {
            Layer l = ctx.allLayers.get(layer);
            for (String k : l.getProperties().keySet()) {
                String hiddenCondition;
                List<Path> paths;
                DeploymentFileRuleInspector.ParsedRule parsedRule;
                ArrayList<Boolean> matchingRule = new ArrayList<Boolean>();
                matchingRule.add(Boolean.FALSE);
                boolean isCondition = LayerMapping.isCondition(k);
                Consumer<Layer> consumer = isCondition ? ll -> matchingRule.set(0, Boolean.TRUE) : ll -> {
                    set.add((Layer)ll);
                    matchingRule.set(0, Boolean.TRUE);
                };
                String originalKey = k;
                k = LayerMapping.cleanupKey(k);
                String val = l.getProperties().get(originalKey);
                if (k.startsWith("org.wildfly.rule.xml-path")) {
                    DeploymentFileRuleInspector.ParsedRule rule = inspector.extractParsedRule(val);
                    rule.iterateMatchedPaths((path, values) -> Utils.applyXPath(path, ((DeploymentFileRuleInspector.PatternOrValue)values.get(0)).getValue(), values.size() == 1 ? null : ((DeploymentFileRuleInspector.PatternOrValue)values.get(1)).getValue(), consumer, l));
                } else if (k.startsWith("org.wildfly.rule.properties-file-match")) {
                    parsedRule = inspector.extractParsedRule(val);
                    parsedRule.iterateMatchedPaths((path, values) -> {
                        Properties props = new Properties();
                        try (InputStream reader = Files.newInputStream(path, new OpenOption[0]);){
                            props.load(reader);
                            for (String prop : props.stringPropertyNames()) {
                                if (parsedRule.getValueParts().size() < 1) continue;
                                DeploymentFileRuleInspector.PatternOrValue key = parsedRule.getValueParts().get(0);
                                boolean match = key.equalsOrMatches(prop);
                                DeploymentFileRuleInspector.PatternOrValue value = null;
                                if (match && parsedRule.getValueParts().size() == 2 && (value = parsedRule.getValueParts().get(1)) != null) {
                                    match = value.equalsOrMatches(props.getProperty(prop));
                                }
                                if (!match) continue;
                                consumer.accept(l);
                                LayerMapping.addRule(LayerMapping.RULE.PROPERTIES_FILE, l, path.toString() + "==>" + prop + (String)(value != null ? "==" + props.getProperty(prop) : ""));
                            }
                        }
                    });
                } else if (k.startsWith("org.wildfly.rule.expected-file")) {
                    parsedRule = inspector.extractParsedRule(val);
                    parsedRule.iterateMatchedPaths((path, values) -> {
                        consumer.accept(l);
                        LayerMapping.addRule(LayerMapping.RULE.EXPECTED_FILE, l, path.toString());
                    });
                } else if (k.startsWith("org.wildfly.rule.not-expected-file") && (paths = (parsedRule = inspector.extractParsedRule(val)).getMatchedPaths()).size() == 0) {
                    LayerMapping.addRule(LayerMapping.RULE.NOT_EXPECTED_FILE, l, val);
                    consumer.accept(l);
                }
                if (!isCondition || !((Boolean)matchingRule.get(0)).booleanValue()) continue;
                String condition = ctx.mapping.getNoConfigurationConditions().get(l);
                if (originalKey.equals(condition)) {
                    l.getConfiguration().clear();
                }
                if (!originalKey.equals(hiddenCondition = ctx.mapping.getHiddenConditions().get(l))) continue;
                l.setBanned(true);
            }
        }
        ctx.errorSession.collectErrors(rootPath);
        return set;
    }

    private String pathRelativeToRoot(String path) {
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    private String adjustPatternInputRelativeToRoot(Path rootPath, String pathPattern) {
        if (rootPath.toString().endsWith("/")) {
            return rootPath + this.pathRelativeToRoot(pathPattern);
        }
        return rootPath + pathPattern;
    }

    private static class FileNameParts {
        private final String coreName;
        private final ArchiveType archiveType;

        public FileNameParts(String coreName, ArchiveType archiveType) {
            this.coreName = coreName;
            this.archiveType = archiveType;
        }

        static FileNameParts parse(Path binary) {
            String filename = binary.getFileName().toString();
            int index = filename.lastIndexOf(".");
            String suffix = filename.substring(index + 1);
            String core = filename.substring(0, index);
            return new FileNameParts(core, ArchiveType.parse(suffix));
        }
    }

    static enum ArchiveType {
        EAR(".ear"){

            @Override
            public boolean isValidArchiveLocation(Path pathInArchive) {
                return ArchiveType.isJar(pathInArchive) || ArchiveType.isWar(pathInArchive) || ArchiveType.isRar(pathInArchive) || ArchiveType.isSar(pathInArchive);
            }
        }
        ,
        WAR(".war"){

            @Override
            public boolean isValidArchiveLocation(Path pathInArchive) {
                if (!ArchiveType.isJar(pathInArchive)) {
                    return false;
                }
                if (pathInArchive.getNameCount() != 3) {
                    return false;
                }
                return pathInArchive.getName(0).toString().equals("WEB-INF") && pathInArchive.getName(1).toString().equals("lib");
            }
        }
        ,
        JAR(".jar"),
        RAR(".rar"){

            @Override
            public boolean isValidArchiveLocation(Path pathInArchive) {
                return pathInArchive.getNameCount() == 1 && ArchiveType.isJar(pathInArchive);
            }
        }
        ,
        SAR(".sar");

        private final String suffix;

        private ArchiveType(String suffix) {
            this.suffix = suffix;
        }

        public boolean isValidArchiveLocation(Path pathInArchive) {
            return false;
        }

        static ArchiveType parse(String s) {
            switch (s) {
                case "ear": {
                    return EAR;
                }
                case "war": {
                    return WAR;
                }
                case "jar": {
                    return JAR;
                }
                case "rar": {
                    return RAR;
                }
                case "sar": {
                    return SAR;
                }
            }
            throw new IllegalArgumentException(s);
        }

        private static boolean isJar(Path pathInArchive) {
            return ArchiveType.hasSuffix(pathInArchive, ArchiveType.JAR.suffix);
        }

        private static boolean isWar(Path pathInArchive) {
            return ArchiveType.hasSuffix(pathInArchive, ArchiveType.WAR.suffix);
        }

        private static boolean isRar(Path pathInArchive) {
            return ArchiveType.hasSuffix(pathInArchive, ArchiveType.RAR.suffix);
        }

        private static boolean isSar(Path pathInArchive) {
            return ArchiveType.hasSuffix(pathInArchive, ArchiveType.SAR.suffix);
        }

        private static boolean hasSuffix(Path pathInArchive, String suffix) {
            return pathInArchive.getFileName().toString().endsWith(suffix);
        }

        static boolean isArchiveName(Path path) {
            for (ArchiveType type : ArchiveType.values()) {
                if (!path.getFileName().toString().endsWith(type.suffix)) continue;
                return true;
            }
            return false;
        }
    }

    static class DeploymentScanContext {
        private final LayerMapping mapping;
        private final Set<Layer> layers;
        private final Map<String, Layer> allLayers;
        private final ErrorIdentificationSession errorSession;
        private final Set<String> allClasses = new HashSet<String>();
        private final Map<String, ResourceInjectionJndiInfo> resourceInjectionJndiInfos = new HashMap<String, ResourceInjectionJndiInfo>();
        public Set<ContextLookupInfo> contextLookupInfos = new HashSet<ContextLookupInfo>();

        private DeploymentScanContext(LayerMapping mapping, Set<Layer> layers, Map<String, Layer> allLayers, ErrorIdentificationSession errorSession) {
            this.mapping = mapping;
            this.layers = layers;
            this.allLayers = allLayers;
            this.errorSession = errorSession;
        }
    }

    private class ContextLookupClassVisitor
    extends ClassVisitor {
        private DeploymentScanContext ctx;
        private String clazz;

        public ContextLookupClassVisitor(DeploymentScanContext ctx) {
            super(589824);
            this.ctx = ctx;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.clazz = name;
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public void visitEnd() {
            this.clazz = null;
            super.visitEnd();
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            ContextLookupMethodVisitor visitor = new ContextLookupMethodVisitor(this.clazz, name, this.ctx);
            return visitor;
        }
    }

    private class ContextLookupMethodVisitor
    extends MethodVisitor {
        private DeploymentScanContext ctx;
        private String clazz;
        private String method;

        public ContextLookupMethodVisitor(String clazz, String method, DeploymentScanContext ctx) {
            super(589824);
            this.clazz = clazz;
            this.method = method;
            this.ctx = ctx;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            if (!"lookup".equals(name)) {
                return;
            }
            if ("javax/naming/Context".equals(owner) || "javax/naming/InitialContext".equals(owner)) {
                String lookupClass = owner.replace('/', '.');
                DeploymentScanner.this.lookup(lookupClass, this.ctx);
                String method = this.clazz.replace('/', '.') + "." + this.method + "()";
                this.ctx.contextLookupInfos.add(new ContextLookupInfo(method));
            }
        }
    }
}

