/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.error;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.wildfly.glow.Env;
import org.wildfly.glow.Layer;
import org.wildfly.glow.Utils;
import org.wildfly.glow.error.ErrorIdentification;
import org.wildfly.glow.error.Fix;
import org.wildfly.glow.error.IdentifiedError;
import org.wildfly.glow.error.MissingDefaultDatasourceError;
import org.wildfly.glow.error.UnboundDatasourceError;

public class DatasourceErrorIdentification
implements ErrorIdentification {
    private static final String DEFAULT_DATASOURCE_JNDI_NAME = "java:comp/DefaultDataSource";
    private static final String UNBOUND_DATASOURCES_ERROR = "unbound-datasources";
    private static final String NO_DEFAULT_DATASOURCE_ERROR = "no-default-datasource";
    private static final String UNBOUND_DATASOURCES_ERROR_DESCRIPTION = "unbound datasources error";
    private static final String NO_DEFAULT_DATASOURCE_ERROR_DESCRIPTION = "no default datasource found error";
    Map<String, Set<IdentifiedError>> errors = new HashMap<String, Set<IdentifiedError>>();

    @Override
    public void collectErrors(Path rootPath) throws Exception {
        Path persistence = rootPath.resolve("/WEB-INF/classes/META-INF/persistence.xml");
        Set<String> expectedDataSources = null;
        boolean persistenceExists = Files.exists(persistence, new LinkOption[0]);
        if (persistenceExists) {
            expectedDataSources = Utils.getXMLElementValues(persistence, "/persistence/persistence-unit/jta-data-source");
        }
        if (expectedDataSources != null && !expectedDataSources.isEmpty()) {
            final TreeSet allDS = new TreeSet();
            final Pattern p = Pattern.compile("/WEB-INF/.*.xml");
            Files.walkFileTree(rootPath, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (p.matcher(file.toString()).matches()) {
                        try {
                            Set<String> ds = Utils.getXMLElementValues(file, "/datasources/datasource/@jndi-name");
                            allDS.addAll(ds);
                            Set<String> xads = Utils.getXMLElementValues(file, "/datasources/xa-datasource/@jndi-name");
                            allDS.addAll(xads);
                        }
                        catch (Exception ex) {
                            throw new IOException(ex);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            TreeSet<String> unboundDatasources = new TreeSet<String>();
            for (String ds : expectedDataSources) {
                if (allDS.contains(ds)) continue;
                if (DEFAULT_DATASOURCE_JNDI_NAME.equals(ds)) {
                    HashSet<MissingDefaultDatasourceError> errs = new HashSet<MissingDefaultDatasourceError>();
                    errs.add(new MissingDefaultDatasourceError(NO_DEFAULT_DATASOURCE_ERROR, NO_DEFAULT_DATASOURCE_ERROR_DESCRIPTION));
                    this.errors.put(NO_DEFAULT_DATASOURCE_ERROR, errs);
                    continue;
                }
                unboundDatasources.add(ds);
            }
            if (!unboundDatasources.isEmpty()) {
                Set<IdentifiedError> errs = this.errors.get(UNBOUND_DATASOURCES_ERROR);
                if (errs == null) {
                    errs = new HashSet<IdentifiedError>();
                    this.errors.put(UNBOUND_DATASOURCES_ERROR, errs);
                }
                for (String ds : unboundDatasources) {
                    errs.add(new UnboundDatasourceError(UNBOUND_DATASOURCES_ERROR, UNBOUND_DATASOURCES_ERROR_DESCRIPTION, ds));
                }
            }
        } else if (persistenceExists) {
            HashSet<MissingDefaultDatasourceError> errs = new HashSet<MissingDefaultDatasourceError>();
            errs.add(new MissingDefaultDatasourceError(NO_DEFAULT_DATASOURCE_ERROR, NO_DEFAULT_DATASOURCE_ERROR_DESCRIPTION));
            this.errors.put(NO_DEFAULT_DATASOURCE_ERROR, errs);
        }
    }

    @Override
    public Map<Layer, Set<Env>> refreshErrors(Set<Layer> allBaseLayers) throws Exception {
        Set<IdentifiedError> noDefaultDataspourceErrors;
        String errorMessage;
        Set<Env> envs;
        String content;
        Fix fix;
        Set<IdentifiedError> unboundDatasourcesErrors = this.errors.get(UNBOUND_DATASOURCES_ERROR);
        HashSet<String> toRemove = new HashSet<String>();
        HashMap<Layer, Set<Env>> ret = new HashMap<Layer, Set<Env>>();
        if (unboundDatasourcesErrors != null) {
            block0: for (IdentifiedError error : unboundDatasourcesErrors) {
                UnboundDatasourceError uds = (UnboundDatasourceError)error;
                for (Layer l : allBaseLayers) {
                    if (l.getBringDatasources().contains(uds.unboundDatasource)) {
                        toRemove.add(uds.unboundDatasource);
                        continue block0;
                    }
                    if (l.getAddOn() == null || (fix = l.getAddOn().getFixes().get(error.getId())) == null) continue;
                    content = null;
                    if (!l.getBringDatasources().contains(uds.unboundDatasource)) {
                        content = fix.getContent();
                        if (content != null) {
                            content = content.replaceAll("##ITEM##", uds.unboundDatasource);
                        }
                        if (fix.isEnv()) {
                            envs = (Set)ret.get(l);
                            if (envs == null) {
                                envs = new HashSet();
                                ret.put(l, envs);
                            }
                            envs.add(new Env(fix.getEnvName(), Fix.getEnvValue(content), false, true));
                        }
                    }
                    errorMessage = Utils.getAddOnFix(l.getAddOn(), content);
                    error.setFixed(errorMessage);
                }
            }
            Iterator<IdentifiedError> it = unboundDatasourcesErrors.iterator();
            while (it.hasNext()) {
                UnboundDatasourceError uds = (UnboundDatasourceError)it.next();
                if (!toRemove.contains(uds.unboundDatasource)) continue;
                it.remove();
            }
        }
        if ((noDefaultDataspourceErrors = this.errors.get(NO_DEFAULT_DATASOURCE_ERROR)) != null) {
            for (IdentifiedError error : noDefaultDataspourceErrors) {
                for (Layer l : allBaseLayers) {
                    if (l.getAddOn() == null || (fix = l.getAddOn().getFixes().get(error.getId())) == null) continue;
                    content = fix.getContent();
                    if (fix.isEnv()) {
                        envs = (HashSet<Env>)ret.get(l);
                        if (envs == null) {
                            envs = new HashSet<Env>();
                            ret.put(l, envs);
                        }
                        envs.add(new Env(fix.getEnvName(), Fix.getEnvValue(content), false, true));
                    }
                    errorMessage = Utils.getAddOnFix(l.getAddOn(), content);
                    error.setFixed(errorMessage);
                }
            }
        }
        return ret;
    }

    @Override
    public List<IdentifiedError> getErrors() {
        ArrayList<IdentifiedError> ret = new ArrayList<IdentifiedError>();
        for (Set<IdentifiedError> err : this.errors.values()) {
            ret.addAll(err);
        }
        return ret;
    }
}

