/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.wildfly.glow.Arguments;
import org.wildfly.glow.ExecUtil;
import org.wildfly.glow.GlowMessageWriter;

public class DockerSupport {
    public static Path buildApplicationImage(String image, Path jbossHome, Arguments arguments, GlowMessageWriter writer) throws IOException {
        jbossHome = jbossHome.toAbsolutePath();
        String binary = ExecUtil.resolveImageBinary(writer);
        Path file = DockerSupport.generateDockerfile("quay.io/wildfly/wildfly-runtime:latest", jbossHome.getParent(), jbossHome);
        writer.info(String.format("Building application image %s using %s.", image, binary));
        CharSequence[] dockerArgs = new String[]{"build", "-t", image, "."};
        writer.info(String.format("Executing the following command to build application image: '%s %s'", binary, String.join((CharSequence)" ", dockerArgs)));
        ExecUtil.exec(jbossHome.getParent().toFile(), binary, writer, (String[])dockerArgs);
        return file;
    }

    public static String getImageName(String target) {
        return ("wildfly-glow-image-" + target.replaceAll("\\.", "_") + ":latest").toLowerCase();
    }

    private static Path generateDockerfile(String runtimeImage, Path targetDir, Path jbossHome) throws IOException {
        if (jbossHome.isAbsolute()) {
            jbossHome = targetDir.relativize(jbossHome);
        }
        Path file = targetDir.resolve("Dockerfile");
        Files.writeString(file, (CharSequence)("FROM " + runtimeImage + "\nCOPY --chown=jboss:root " + jbossHome + " $JBOSS_HOME\nRUN chmod -R ug+rwX $JBOSS_HOME\n"), StandardCharsets.UTF_8, new OpenOption[0]);
        return file;
    }
}

