/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.wildfly.glow.AddOn;
import org.wildfly.glow.LayerMapping;

public class Layer
implements Comparable<Layer> {
    private final String name;
    private final Set<Layer> dependencies = new TreeSet<Layer>();
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Map<LayerMapping.RULE, Set<String>> matchingRules = new HashMap<LayerMapping.RULE, Set<String>>();
    private final Set<FeaturePackLocation.FPID> featurePacks = new HashSet<FeaturePackLocation.FPID>();
    private AddOn addOn;
    private final Set<String> bringDatasources = new TreeSet<String>();
    private boolean isAutomaticInjection;
    private final Set<String> configuration = new TreeSet<String>();
    private String expectFamily;
    private boolean banned;

    Layer(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Layer other = (Layer)obj;
        return Objects.equals(this.name, other.name);
    }

    @Override
    public int compareTo(Layer t) {
        return this.name.compareTo(t.name);
    }

    public Set<Layer> getDependencies() {
        return this.dependencies;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<LayerMapping.RULE, Set<String>> getMatchingRules() {
        return this.matchingRules;
    }

    public Set<FeaturePackLocation.FPID> getFeaturePacks() {
        return this.featurePacks;
    }

    public AddOn getAddOn() {
        return this.addOn;
    }

    public void setAddOn(AddOn addOn) {
        this.addOn = addOn;
    }

    public Set<String> getBringDatasources() {
        return this.bringDatasources;
    }

    public boolean isIsAutomaticInjection() {
        return this.isAutomaticInjection;
    }

    public void setIsAutomaticInjection(boolean isAutomaticInjection) {
        this.isAutomaticInjection = isAutomaticInjection;
    }

    public Set<String> getConfiguration() {
        return this.configuration;
    }

    public String getExpectFamily() {
        return this.expectFamily;
    }

    public void setExpectFamily(String expectFamily) {
        this.expectFamily = expectFamily;
    }

    public boolean isBanned() {
        return this.banned;
    }

    public void setBanned(boolean isBanned) {
        this.banned = isBanned;
    }
}

