/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.plugin.doc;

import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.xml.ProvisioningXmlParser;
import org.wildfly.glow.FeaturePacks;
import org.wildfly.glow.GlowMessageWriter;
import org.wildfly.glow.Layer;
import org.wildfly.glow.LayerMetadata;
import org.wildfly.glow.Utils;

@Mojo(name="scan-doc", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PACKAGE)
public class ScanDocMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Component
    RepositorySystem repoSystem;
    @Component
    BuildPluginManager pluginManager;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    List<RemoteRepository> repositories;
    @Parameter(defaultValue="rules.adoc")
    String generatedFile;
    @Parameter(defaultValue="${project.build.directory}")
    String targetDir;
    @Parameter(required=false)
    String rulesPropertiesFile;
    @Parameter(required=false, defaultValue="true")
    boolean generateRuleDescriptions;
    @Parameter(required=false, defaultValue="true")
    boolean generateKnownFeaturePacks;
    @Parameter(required=false)
    String repoPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            StringBuilder rulesBuilder = new StringBuilder();
            if (this.generateRuleDescriptions) {
                Properties properties = new Properties();
                try (FileInputStream in = new FileInputStream(Paths.get(this.rulesPropertiesFile, new String[0]).toFile());){
                    properties.load(in);
                }
                rulesBuilder.append("== [[glow.table.rules]]Rules descriptions\n");
                rulesBuilder.append("[cols=\"1,2,1\"]\n");
                rulesBuilder.append("|===\n");
                rulesBuilder.append("|Rule |Description |Value\n");
                for (String k : LayerMetadata.getAllRules()) {
                    rulesBuilder.append("|[[glow." + k + "]]" + k + "\n");
                    String desc = properties.getProperty(k);
                    String val = properties.getProperty(k + ".value");
                    if (desc == null) {
                        throw new Exception("Missing rule description for " + k + " in " + this.rulesPropertiesFile);
                    }
                    if (val == null) {
                        throw new Exception("Missing rule example value for " + k + " in " + this.rulesPropertiesFile);
                    }
                    rulesBuilder.append("|" + desc + "\n");
                    rulesBuilder.append("|" + val + "\n");
                }
                rulesBuilder.append("|===\n");
            }
            if (this.generateKnownFeaturePacks) {
                if (this.repoPath != null) {
                    Path p = Paths.get(this.repoPath, new String[0]);
                    String repoUrl = "file://" + p.toAbsolutePath();
                    System.out.println("Using repo url " + repoUrl);
                    System.setProperty("wildfly-glow-galleon-feature-packs-url", repoUrl);
                }
                try {
                    Path outputFolder = Paths.get(this.project.getBuild().getDirectory(), new String[0]);
                    MavenArtifactRepositoryManager artifactResolver = new MavenArtifactRepositoryManager(this.repoSystem, this.repoSession, this.repositories);
                    UniverseResolver universeResolver = ((UniverseResolver.Builder)UniverseResolver.builder().addArtifactResolver((RepositoryArtifactResolver)artifactResolver)).build();
                    TreeMap<Layer, Map<String, String>> rules = new TreeMap<Layer, Map<String, String>>();
                    this.getRules("bare-metal", universeResolver, rules);
                    TreeMap<Layer, Map<String, String>> cloudRules = new TreeMap<Layer, Map<String, String>>();
                    this.getRules("cloud", universeResolver, cloudRules);
                    rulesBuilder.append("## Support for WildFly " + FeaturePacks.getLatestVersion() + "\n\n");
                    rulesBuilder.append(this.buildTable("bare-metal", rules, false));
                    rulesBuilder.append(this.buildTable("cloud", cloudRules, false));
                    rulesBuilder.append("## Support for WildFly Preview " + FeaturePacks.getLatestVersion() + "\n\n");
                    rulesBuilder.append(this.buildTable("bare-metal", rules, true));
                    rulesBuilder.append(this.buildTable("cloud", cloudRules, true));
                }
                finally {
                    System.clearProperty("wildfly-glow-galleon-feature-packs-url");
                }
            }
            Path dir = Paths.get(this.targetDir, new String[0]);
            Files.createDirectories(dir, new FileAttribute[0]);
            Files.writeString(dir.resolve(this.generatedFile), (CharSequence)rulesBuilder.toString(), new OpenOption[0]);
        }
        catch (Exception ex) {
            throw new MojoExecutionException((Throwable)ex);
        }
    }

    private String buildTable(String context, Map<Layer, Map<String, String>> rules, boolean preview) throws Exception {
        StringBuilder rulesBuilder = new StringBuilder();
        rulesBuilder.append("\n### " + context + "\n");
        rulesBuilder.append("\n#### Supported Galleon feature-packs \n");
        Path provisioningXML = FeaturePacks.getFeaturePacks(null, (String)context, (boolean)preview);
        ProvisioningConfig pConfig = ProvisioningXmlParser.parse((Path)provisioningXML);
        for (FeaturePackConfig c : pConfig.getFeaturePackDeps()) {
            rulesBuilder.append("* " + c.getLocation() + " \n");
        }
        rulesBuilder.append("\n#### [[glow.table." + context + "]]Galleon layers and associated discovery rules\n");
        rulesBuilder.append("[cols=\"25%,50%,25%\"]\n");
        rulesBuilder.append("|===\n");
        rulesBuilder.append("|Layer |Rule(s) |Feature-pack(s)\n");
        for (Layer l : rules.keySet()) {
            rulesBuilder.append("|" + l + "\n");
            rulesBuilder.append("|\n");
            Map<String, String> local = rules.get(l);
            for (String k : local.keySet()) {
                String ruleClass = LayerMetadata.getRuleClass((String)k);
                if (ruleClass == null) {
                    throw new Exception("Unknown rule " + k);
                }
                rulesBuilder.append("link:#glow." + ruleClass + "[" + k + "]=" + local.get(k)).append(" +\n");
            }
            rulesBuilder.append("l|\n");
            for (FeaturePackLocation.FPID id : l.getFeaturePacks()) {
                rulesBuilder.append(id + "\n");
            }
        }
        rulesBuilder.append("|===\n");
        return rulesBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getRules(String context, UniverseResolver universeResolver, Map<Layer, Map<String, String>> rules) throws Exception {
        try (ProvisioningLayout layout = Utils.buildLayout((String)context, null, null, (GlowMessageWriter)GlowMessageWriter.DEFAULT, (boolean)false);){
            Map all;
            HashMap fpDependencies = new HashMap();
            try {
                all = Utils.getAllLayers((UniverseResolver)universeResolver, (ProvisioningLayout)layout, fpDependencies);
            }
            finally {
                layout.close();
            }
            for (Layer l : all.values()) {
                if (l.getProperties().isEmpty()) continue;
                Map props = rules.computeIfAbsent(l, value -> new TreeMap());
                props.putAll(l.getProperties());
            }
        }
    }
}

