/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.plugin.doc;

import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;
import org.wildfly.glow.WildFlyMetadataProvider;

@Mojo(name="generate-maven-metadata", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PACKAGE)
public class GenerateMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Component
    RepositorySystem repoSystem;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    List<RemoteRepository> repositories;
    @Parameter(defaultValue="glow-maven-metadata.zip")
    String generatedFile;
    @Parameter(defaultValue="${project.build.directory}")
    String targetDir;
    @Parameter(required=true)
    String repoPath;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Path rootDir = Paths.get(this.repoPath, new String[0]);
            WildFlyMetadataProvider provider = new WildFlyMetadataProvider(rootDir.toFile().getAbsoluteFile().toURI());
            Set versions = provider.getAllVersions();
            Path dir = Paths.get(this.targetDir, new String[0]);
            Path generatedFilePath = dir.resolve(this.generatedFile);
            Path versionsFile = rootDir.resolve("versions.yaml");
            Path metadataDir = dir.resolve("metadata");
            Files.createDirectories(metadataDir, new FileAttribute[0]);
            Files.copy(versionsFile, metadataDir.resolve("versions.yaml"), new CopyOption[0]);
            for (String version : versions) {
                Path versionDir = rootDir.resolve(version);
                Path versionTargetDir = metadataDir.resolve(version);
                IoUtils.copy((Path)versionDir, (Path)versionTargetDir);
            }
            Path spacesDir = rootDir.resolve("spaces");
            Path spacesTargetDir = metadataDir.resolve("spaces");
            IoUtils.copy((Path)spacesDir, (Path)spacesTargetDir);
            ZipUtils.zip((Path)metadataDir, (Path)generatedFilePath);
            this.getLog().debug((CharSequence)("Attaching maven metadata " + generatedFilePath + " as a project artifact"));
            this.projectHelper.attachArtifact(this.project, "zip", generatedFilePath.toFile());
        }
        catch (Exception ex) {
            throw new MojoExecutionException((Throwable)ex);
        }
    }
}

