/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.plugin.doc;

import java.io.FileInputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;
import org.wildfly.channel.Channel;
import org.wildfly.glow.AddOn;
import org.wildfly.glow.Layer;
import org.wildfly.glow.LayerMapping;
import org.wildfly.glow.LayerMetadata;
import org.wildfly.glow.MetadataProvider;
import org.wildfly.glow.Space;
import org.wildfly.glow.Utils;
import org.wildfly.glow.WildFlyMavenMetadataProvider;
import org.wildfly.glow.WildFlyMetadataProvider;
import org.wildfly.glow.plugin.doc.ChannelConfiguration;
import org.wildfly.glow.plugin.doc.ChannelMavenArtifactRepositoryManager;

@Mojo(name="scan-doc", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PACKAGE)
public class ScanDocMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Component
    RepositorySystem repoSystem;
    @Component
    BuildPluginManager pluginManager;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    List<RemoteRepository> repositories;
    @Parameter(defaultValue="rules.adoc")
    String generatedFile;
    @Parameter(defaultValue="${project.build.directory}")
    String targetDir;
    @Parameter(required=false)
    String rulesPropertiesFile;
    @Parameter(required=false, defaultValue="true")
    boolean generateRuleDescriptions;
    @Parameter(required=false, defaultValue="true")
    boolean generateKnownFeaturePacks;
    @Parameter(required=false)
    String repoPath;
    @Parameter(required=false)
    List<ChannelConfiguration> channels;
    @Parameter(required=false, defaultValue="true")
    boolean preview;
    @Parameter(required=false, defaultValue="WildFly")
    String serverType;
    @Parameter(required=false, defaultValue="true")
    boolean spaces;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            StringBuilder rulesBuilder;
            block27: {
                rulesBuilder = new StringBuilder();
                if (this.generateRuleDescriptions) {
                    Properties properties = new Properties();
                    try (FileInputStream in = new FileInputStream(Paths.get(this.rulesPropertiesFile, new String[0]).toFile());){
                        properties.load(in);
                    }
                    rulesBuilder.append("== [[glow.table.rules]]Rules descriptions\n");
                    rulesBuilder.append("[cols=\"1,2,1\"]\n");
                    rulesBuilder.append("|===\n");
                    rulesBuilder.append("|Rule |Description |Value\n");
                    for (String string : LayerMetadata.getAllRules()) {
                        rulesBuilder.append("|[[glow." + string + "]]" + string + "\n");
                        String desc = properties.getProperty(string);
                        String val = properties.getProperty(string + ".value");
                        if (desc == null) {
                            throw new Exception("Missing rule description for " + string + " in " + this.rulesPropertiesFile);
                        }
                        if (val == null) {
                            throw new Exception("Missing rule example value for " + string + " in " + this.rulesPropertiesFile);
                        }
                        rulesBuilder.append("|" + desc + "\n");
                        rulesBuilder.append("|" + (String)val + "\n");
                    }
                    rulesBuilder.append("|===\n");
                }
                if (this.generateKnownFeaturePacks) {
                    Path tmpDirectory = null;
                    try {
                        void var4_9;
                        WildFlyMavenMetadataProvider metadataProvider;
                        if (this.channels != null && !this.channels.isEmpty()) {
                            this.getLog().debug((CharSequence)"WildFly channel enabled.");
                            ArrayList<Channel> lst = new ArrayList<Channel>();
                            for (ChannelConfiguration conf : this.channels) {
                                lst.add(conf.toChannel(this.repositories));
                            }
                            ChannelMavenArtifactRepositoryManager channelMavenArtifactRepositoryManager = new ChannelMavenArtifactRepositoryManager(lst, this.repoSystem, this.repoSession, this.repositories);
                        } else {
                            MavenArtifactRepositoryManager mavenArtifactRepositoryManager = new MavenArtifactRepositoryManager(this.repoSystem, this.repoSession, this.repositories);
                        }
                        if (this.repoPath != null) {
                            Path p = Paths.get(this.repoPath, new String[0]);
                            String repoUrl = "file://" + String.valueOf(p.toAbsolutePath());
                            System.out.println("Using repo url " + repoUrl);
                            metadataProvider = new WildFlyMetadataProvider(new URI(repoUrl));
                        } else {
                            tmpDirectory = Files.createTempDirectory("wildfly-glow-metadata", new FileAttribute[0]);
                            metadataProvider = new WildFlyMavenMetadataProvider((MavenRepoManager)var4_9, tmpDirectory);
                        }
                        UniverseResolver universeResolver = ((UniverseResolver.Builder)UniverseResolver.builder().addArtifactResolver((RepositoryArtifactResolver)var4_9)).build();
                        GalleonBuilder provider = new GalleonBuilder();
                        provider.addArtifactResolver((RepositoryArtifactResolver)var4_9);
                        TreeMap<Layer, Map<String, String>> rules = new TreeMap<Layer, Map<String, String>>();
                        this.getRules(Space.DEFAULT, provider, "bare-metal", universeResolver, rules, false, (MetadataProvider)metadataProvider);
                        TreeMap<Layer, Map<String, String>> cloudRules = new TreeMap<Layer, Map<String, String>>();
                        this.getRules(Space.DEFAULT, provider, "cloud", universeResolver, cloudRules, false, (MetadataProvider)metadataProvider);
                        rulesBuilder.append("## Support for " + this.serverType + " " + metadataProvider.getLatestVersion() + "\n\n");
                        rulesBuilder.append(this.buildTable(Space.DEFAULT, provider, "bare-metal", rules, false, (MetadataProvider)metadataProvider));
                        rulesBuilder.append(this.buildTable(Space.DEFAULT, provider, "cloud", cloudRules, false, (MetadataProvider)metadataProvider));
                        if (this.preview) {
                            TreeMap<Layer, Map<String, String>> previewRules = new TreeMap<Layer, Map<String, String>>();
                            this.getRules(Space.DEFAULT, provider, "bare-metal", universeResolver, previewRules, true, (MetadataProvider)metadataProvider);
                            TreeMap<Layer, Map<String, String>> previewCloudRules = new TreeMap<Layer, Map<String, String>>();
                            this.getRules(Space.DEFAULT, provider, "cloud", universeResolver, previewCloudRules, true, (MetadataProvider)metadataProvider);
                            rulesBuilder.append("## Support for WildFly Preview " + metadataProvider.getLatestVersion() + "\n\n");
                            rulesBuilder.append(this.buildTable(Space.DEFAULT, provider, "bare-metal", previewRules, true, (MetadataProvider)metadataProvider));
                            rulesBuilder.append(this.buildTable(Space.DEFAULT, provider, "cloud", previewCloudRules, true, (MetadataProvider)metadataProvider));
                        }
                        if (this.spaces) {
                            for (Space space : metadataProvider.getAllSpaces()) {
                                if (!metadataProvider.getAllVersions(space.getName()).contains(metadataProvider.getLatestVersion())) continue;
                                TreeMap<Layer, Map<String, String>> spaceRules = new TreeMap<Layer, Map<String, String>>();
                                this.getRules(space, provider, "bare-metal", universeResolver, spaceRules, false, (MetadataProvider)metadataProvider);
                                TreeMap<Layer, Map<String, String>> spaceCloudRules = new TreeMap<Layer, Map<String, String>>();
                                this.getRules(space, provider, "cloud", universeResolver, spaceCloudRules, false, (MetadataProvider)metadataProvider);
                                if (!spaceRules.isEmpty() || !spaceCloudRules.isEmpty()) {
                                    rulesBuilder.append("##  Additional '" + space.getName() + "' space\n\n");
                                    rulesBuilder.append(space.getDescription() + "\n\n");
                                    rulesBuilder.append("### Support for " + this.serverType + " " + metadataProvider.getLatestVersion() + "\n\n");
                                }
                                if (!spaceRules.isEmpty()) {
                                    rulesBuilder.append(this.buildTable(space, provider, "bare-metal", spaceRules, false, (MetadataProvider)metadataProvider));
                                }
                                if (!spaceCloudRules.isEmpty()) {
                                    rulesBuilder.append(this.buildTable(space, provider, "cloud", spaceCloudRules, false, (MetadataProvider)metadataProvider));
                                }
                                if (!this.preview) continue;
                                TreeMap<Layer, Map<String, String>> spacePreviewRules = new TreeMap<Layer, Map<String, String>>();
                                this.getRules(space, provider, "bare-metal", universeResolver, spacePreviewRules, true, (MetadataProvider)metadataProvider);
                                TreeMap<Layer, Map<String, String>> spacePreviewCloudRules = new TreeMap<Layer, Map<String, String>>();
                                this.getRules(space, provider, "cloud", universeResolver, spacePreviewCloudRules, true, (MetadataProvider)metadataProvider);
                                if (spacePreviewRules.isEmpty() && spacePreviewCloudRules.isEmpty()) continue;
                                rulesBuilder.append("### Support for WildFly Preview " + metadataProvider.getLatestVersion() + "\n\n");
                                if (!spacePreviewRules.isEmpty()) {
                                    rulesBuilder.append(this.buildTable(space, provider, "bare-metal", spacePreviewRules, true, (MetadataProvider)metadataProvider));
                                }
                                if (spacePreviewCloudRules.isEmpty()) continue;
                                rulesBuilder.append(this.buildTable(space, provider, "cloud", spacePreviewCloudRules, true, (MetadataProvider)metadataProvider));
                            }
                        }
                        if (tmpDirectory == null) break block27;
                    }
                    catch (Throwable throwable) {
                        if (tmpDirectory == null) throw throwable;
                        IoUtils.recursiveDelete(tmpDirectory);
                        throw throwable;
                    }
                    IoUtils.recursiveDelete((Path)tmpDirectory);
                }
            }
            Path dir = Paths.get(this.targetDir, new String[0]);
            Files.createDirectories(dir, new FileAttribute[0]);
            Files.writeString(dir.resolve(this.generatedFile), (CharSequence)rulesBuilder.toString(), new OpenOption[0]);
            return;
        }
        catch (Exception ex) {
            throw new MojoExecutionException((Throwable)ex);
        }
    }

    private String buildTable(Space space, GalleonBuilder provider, String context, Map<Layer, Map<String, String>> rules, boolean preview, MetadataProvider metadataProvider) throws Exception {
        StringBuilder rulesBuilder = new StringBuilder();
        rulesBuilder.append("\n### " + context + "\n");
        rulesBuilder.append("\n#### Supported Galleon feature-packs \n");
        Path provisioningXML = metadataProvider.getFeaturePacks(space, null, context, preview);
        try (Provisioning p = provider.newProvisioningBuilder(provisioningXML).build();){
            GalleonProvisioningConfig pConfig = p.loadProvisioningConfig(provisioningXML);
            for (Object c : pConfig.getFeaturePackDeps()) {
                rulesBuilder.append("* " + String.valueOf(c.getLocation()) + " \n");
            }
        }
        rulesBuilder.append("\n#### [[glow.table." + context + "]]Galleon layers and associated discovery rules\n");
        rulesBuilder.append("[cols=\"25%,50%,25%\"]\n");
        rulesBuilder.append("|===\n");
        rulesBuilder.append("|Layer |Rule(s) |Feature-pack(s)\n");
        for (Layer l : rules.keySet()) {
            rulesBuilder.append("|" + String.valueOf(l) + "\n");
            rulesBuilder.append("|\n");
            Map<String, String> local = rules.get(l);
            for (String k : local.keySet()) {
                String ruleClass = LayerMetadata.getRuleClass((String)k);
                if (ruleClass == null) {
                    throw new Exception("Unknown rule " + k);
                }
                rulesBuilder.append("link:#glow." + ruleClass + "[" + k + "]=" + local.get(k)).append(" +\n");
            }
            rulesBuilder.append("l|\n");
            for (FeaturePackLocation.FPID id : l.getFeaturePacks()) {
                rulesBuilder.append(String.valueOf(id) + "\n");
            }
        }
        rulesBuilder.append("|===\n");
        TreeMap<String, AddOn> addOns = new TreeMap<String, AddOn>();
        for (Layer l : rules.keySet()) {
            if (l.getAddOn() == null) continue;
            addOns.put(l.getAddOn().getName(), l.getAddOn());
        }
        if (!addOns.isEmpty()) {
            rulesBuilder.append("\n#### [[glow.table.addons." + context + "]]Add-ons\n");
            rulesBuilder.append("[cols=\"25%,25%,50%\"]\n");
            rulesBuilder.append("|===\n");
            rulesBuilder.append("|Add-on |Family |Description\n");
            for (String a : addOns.keySet()) {
                AddOn addon = (AddOn)addOns.get(a);
                rulesBuilder.append("|" + addon.getName() + "\n");
                rulesBuilder.append("|" + addon.getFamily() + "\n");
                rulesBuilder.append("|" + addon.getDescription() + "\n");
            }
            rulesBuilder.append("|===\n");
        }
        return rulesBuilder.toString();
    }

    private LayerMapping getRules(Space space, GalleonBuilder provider, String context, UniverseResolver universeResolver, Map<Layer, Map<String, String>> rules, boolean preview, MetadataProvider metadataProvider) throws Exception {
        Map all;
        Path provisioningXML = metadataProvider.getFeaturePacks(space, null, context, preview);
        try (Provisioning p = provider.newProvisioningBuilder(provisioningXML).build();){
            GalleonProvisioningConfig config = p.loadProvisioningConfig(provisioningXML);
            HashMap fpDependencies = new HashMap();
            all = Utils.getAllLayers((GalleonProvisioningConfig)config, (UniverseResolver)universeResolver, (Provisioning)p, fpDependencies);
            if (!Space.DEFAULT.equals((Object)space)) {
                HashSet<String> toRemove = new HashSet<String>();
                for (Map.Entry entry : all.entrySet()) {
                    Layer l = (Layer)entry.getValue();
                    boolean toInclude = false;
                    for (FeaturePackLocation.FPID fpid : l.getFeaturePacks()) {
                        if (config.getFeaturePackDep(fpid.getProducer()) == null) continue;
                        toInclude = true;
                        break;
                    }
                    if (toInclude) continue;
                    toRemove.add((String)entry.getKey());
                }
                for (String k : toRemove) {
                    all.remove(k);
                }
            }
        }
        LayerMapping mapping = Utils.buildMapping((Map)all, new HashSet());
        for (Layer l : all.values()) {
            if (l.getProperties().isEmpty()) continue;
            Map props = rules.computeIfAbsent(l, value -> new TreeMap());
            props.putAll(l.getProperties());
        }
        return mapping;
    }
}

