/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.maven;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.wildfly.glow.maven.MavenProxySelector;
import org.wildfly.glow.maven.MavenResolver;

public class MavenSettings {
    private static final String EXTERNAL = "external:";
    private static final String ALL = "*";
    private static final String NOT = "!";
    private final List<RemoteRepository> repositories;
    private final RepositorySystemSession session;
    private final Proxy proxy;
    private final MavenProxySelector proxySelector;

    MavenSettings(RepositorySystem repoSystem, Path settingsPath) throws Exception {
        Settings settings = MavenSettings.buildMavenSettings(settingsPath);
        org.apache.maven.settings.Proxy proxy = settings.getActiveProxy();
        if (proxy != null) {
            MavenProxySelector.Builder builder = new MavenProxySelector.Builder(proxy.getHost(), proxy.getPort(), proxy.getProtocol());
            builder.setPassword(proxy.getPassword());
            builder.setUserName(proxy.getUsername());
            if (proxy.getNonProxyHosts() != null) {
                String[] hosts = proxy.getNonProxyHosts().split("\\|");
                builder.addNonProxyHosts(Arrays.asList(hosts));
            }
            this.proxySelector = builder.build();
            Authentication auth = null;
            if (proxy.getPassword() != null && proxy.getUsername() != null) {
                auth = new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build();
            }
            this.proxy = new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), auth);
        } else {
            this.proxy = null;
            this.proxySelector = null;
        }
        this.repositories = Collections.unmodifiableList(this.buildRemoteRepositories(settings));
        this.session = MavenResolver.newMavenSession(repoSystem, settings.getLocalRepository() == null ? null : Paths.get(settings.getLocalRepository(), new String[0]), this.proxySelector, settings.isOffline());
    }

    static Path getMavenSettingsFile() throws Exception {
        Path globalSettingsPath;
        Path customSettingsPath;
        String customFile = System.getProperty("org.wildfly.glow.maven.settings.xml.url");
        if (customFile != null && Files.exists(customSettingsPath = Paths.get(new URL(customFile).toURI()), new LinkOption[0])) {
            return customSettingsPath;
        }
        Path m2 = Paths.get(System.getProperty("user.home"), ".m2");
        Path userSettingsPath = m2.resolve("settings.xml");
        if (Files.exists(userSettingsPath, new LinkOption[0])) {
            return userSettingsPath;
        }
        String mavenHome = System.getenv("M2_HOME");
        if (mavenHome != null && Files.exists(globalSettingsPath = Paths.get(mavenHome, "conf", "settings.xml"), new LinkOption[0])) {
            return globalSettingsPath;
        }
        return null;
    }

    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    public RepositorySystemSession getSession() {
        return this.session;
    }

    private static Settings buildMavenSettings(Path settingsPath) throws Exception {
        DefaultSettingsBuildingRequest settingsBuildingRequest = new DefaultSettingsBuildingRequest();
        settingsBuildingRequest.setSystemProperties(System.getProperties());
        settingsBuildingRequest.setUserSettingsFile(settingsPath.toFile());
        DefaultSettingsBuilderFactory mvnSettingBuilderFactory = new DefaultSettingsBuilderFactory();
        DefaultSettingsBuilder settingsBuilder = mvnSettingBuilderFactory.newInstance();
        SettingsBuildingResult settingsBuildingResult = settingsBuilder.build((SettingsBuildingRequest)settingsBuildingRequest);
        return settingsBuildingResult.getEffectiveSettings();
    }

    private List<RemoteRepository> buildRemoteRepositories(Settings settings) throws Exception {
        LinkedHashMap<String, RemoteRepository> repos = new LinkedHashMap<String, RemoteRepository>();
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
        HashSet<String> urls = new HashSet<String>();
        for (Profile profile : settings.getProfiles()) {
            if ((profile.getActivation() == null || !profile.getActivation().isActiveByDefault()) && !settings.getActiveProfiles().contains(profile.getId())) continue;
            List mavenRepositories = profile.getRepositories();
            Iterator iterator = mavenRepositories.iterator();
            while (iterator.hasNext()) {
                Repository repo = (Repository)iterator.next();
                repos.put(repo.getId(), this.buildRepository(repo.getId(), repo.getLayout(), repo.getUrl(), settings, repo.getReleases(), repo.getSnapshots(), null));
                urls.add(repo.getUrl());
            }
        }
        boolean ignoreDefaultRepos = Boolean.getBoolean("org.wildfly.glow.maven.ignore.default.repos");
        if (!ignoreDefaultRepos) {
            List<RemoteRepository> defaultRepositories = MavenResolver.getMissingDefaultRepositories(urls, this.proxySelector, this.proxy);
            for (RemoteRepository r : defaultRepositories) {
                repos.put(r.getId(), r);
            }
        }
        repositories.addAll(this.handleMirroring(settings, repos));
        for (Map.Entry entry : repos.entrySet()) {
            repositories.add((RemoteRepository)entry.getValue());
        }
        return repositories;
    }

    private List<RemoteRepository> handleMirroring(Settings settings, Map<String, RemoteRepository> repos) throws MalformedURLException {
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
        for (Mirror mirror : settings.getMirrors()) {
            String[] patterns = mirror.getMirrorOf().split(",");
            ArrayList<RemoteRepository> mirrored = new ArrayList<RemoteRepository>();
            boolean all = false;
            ArrayList<String> excluded = new ArrayList<String>();
            for (String p : patterns) {
                if (ALL.equals(p = p.trim())) {
                    all = true;
                    continue;
                }
                if (!p.startsWith(NOT)) continue;
                excluded.add(p.substring(NOT.length()));
            }
            if (all) {
                ArrayList<String> safeKeys = new ArrayList<String>(repos.keySet());
                for (String k : safeKeys) {
                    if (excluded.contains(k)) continue;
                    mirrored.add(repos.remove(k));
                }
            } else {
                for (String p : patterns) {
                    if ((p = p.trim()).startsWith(EXTERNAL)) {
                        System.err.println("external:* mirroring is not supported, skipping configuration item");
                        continue;
                    }
                    RemoteRepository m = repos.get(p);
                    if (m == null) continue;
                    mirrored.add(repos.remove(p));
                }
            }
            if (mirrored.isEmpty()) continue;
            repositories.add(this.buildRepository(mirror.getId(), mirror.getLayout(), mirror.getUrl(), settings, null, null, mirrored));
        }
        return repositories;
    }

    private static RepositoryPolicy fromMavenRepositoryPolicy(org.apache.maven.settings.RepositoryPolicy repositoryPolicy) {
        return new RepositoryPolicy(repositoryPolicy.isEnabled(), repositoryPolicy.getUpdatePolicy(), repositoryPolicy.getChecksumPolicy());
    }

    private static Consumer<org.apache.maven.settings.RepositoryPolicy> forPolicy(Consumer<RepositoryPolicy> mappedPolicyConsumer) {
        return repositoryPolicy -> Optional.ofNullable(repositoryPolicy).map(MavenSettings::fromMavenRepositoryPolicy).ifPresent(mappedPolicyConsumer);
    }

    private static Optional<Authentication> authenticationForServer(Server server) {
        if (server.getUsername() != null) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addPassword(server.getPassword());
            authBuilder.addUsername(server.getUsername());
            return Optional.of(authBuilder.build());
        }
        if (server.getPrivateKey() != null) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            return Optional.of(authBuilder.build());
        }
        return Optional.empty();
    }

    private RemoteRepository buildRepository(String id, String type, String url, Settings settings, org.apache.maven.settings.RepositoryPolicy releasePolicy, org.apache.maven.settings.RepositoryPolicy snapshotPolicy, List<RemoteRepository> mirrored) throws MalformedURLException {
        RemoteRepository.Builder builder = new RemoteRepository.Builder(id, type == null ? "default" : type, url);
        MavenSettings.forPolicy(arg_0 -> ((RemoteRepository.Builder)builder).setReleasePolicy(arg_0)).accept(releasePolicy);
        MavenSettings.forPolicy(arg_0 -> ((RemoteRepository.Builder)builder).setSnapshotPolicy(arg_0)).accept(snapshotPolicy);
        for (Server server : settings.getServers()) {
            if (!server.getId().equals(id)) continue;
            MavenSettings.authenticationForServer(server).ifPresent(arg_0 -> ((RemoteRepository.Builder)builder).setAuthentication(arg_0));
        }
        if (mirrored != null) {
            builder.setMirroredRepositories(mirrored);
        }
        if (this.proxySelector != null && this.proxySelector.proxyFor(new URL(url).getHost())) {
            builder.setProxy(this.proxy);
        }
        return builder.build();
    }
}

