/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.maven;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.wildfly.channel.Channel;
import org.wildfly.glow.maven.ChannelMavenArtifactRepositoryManager;
import org.wildfly.glow.maven.MavenProxySelector;
import org.wildfly.glow.maven.MavenSettings;

public final class MavenResolver {
    public static final String JBOSS_REPO_URL = "https://repository.jboss.org/nexus/content/groups/public/";
    public static final String CENTRAL_REPO_URL = "https://repo1.maven.org/maven2/";
    public static final String GA_REPO_URL = "https://maven.repository.redhat.com/ga/";
    public static final String SPRING_REPO_URL = "https://repo.spring.io/milestone";
    public static final String DEFAULT_REPOSITORY_TYPE = "default";

    public static MavenRepoManager newMavenResolver() throws Exception {
        List<RemoteRepository> repos;
        RepositorySystemSession session;
        RepositorySystem repoSystem = MavenResolver.newRepositorySystem();
        Path settingsPath = MavenSettings.getMavenSettingsFile();
        if (settingsPath == null) {
            session = MavenResolver.newMavenSession(repoSystem);
            repos = MavenResolver.getRemoteRepositories();
        } else {
            MavenSettings settings = new MavenSettings(repoSystem, settingsPath);
            session = settings.getSession();
            repos = settings.getRepositories();
        }
        MavenArtifactRepositoryManager resolver = new MavenArtifactRepositoryManager(repoSystem, session, repos);
        return resolver;
    }

    public static MavenRepoManager newMavenResolver(List<Channel> channels) throws Exception {
        List<RemoteRepository> repos;
        RepositorySystemSession session;
        RepositorySystem repoSystem = MavenResolver.newRepositorySystem();
        Path settingsPath = MavenSettings.getMavenSettingsFile();
        if (settingsPath == null) {
            session = MavenResolver.newMavenSession(repoSystem);
            repos = MavenResolver.getRemoteRepositories();
        } else {
            MavenSettings settings = new MavenSettings(repoSystem, settingsPath);
            session = settings.getSession();
            repos = settings.getRepositories();
        }
        ChannelMavenArtifactRepositoryManager resolver = new ChannelMavenArtifactRepositoryManager(channels, repoSystem, session, repos);
        return resolver;
    }

    public static MavenRepoManager newRHMavenResolver(List<Channel> channels) throws Exception {
        RepositorySystem repoSystem = MavenResolver.newRepositorySystem();
        ChannelMavenArtifactRepositoryManager resolver = new ChannelMavenArtifactRepositoryManager(channels, repoSystem, MavenResolver.newMavenSession(repoSystem), MavenResolver.getRHRemoteRepositories());
        return resolver;
    }

    public static MavenRepoManager newRHMavenResolver() {
        RepositorySystem repoSystem = MavenResolver.newRepositorySystem();
        MavenArtifactRepositoryManager resolver = new MavenArtifactRepositoryManager(repoSystem, MavenResolver.newMavenSession(repoSystem), MavenResolver.getRHRemoteRepositories());
        return resolver;
    }

    static List<RemoteRepository> getMissingDefaultRepositories(Set<String> configuredRepos, MavenProxySelector selector, Proxy proxy) throws MalformedURLException {
        ArrayList<RemoteRepository> lst = new ArrayList<RemoteRepository>();
        for (RemoteRepository rep : MavenResolver.getRemoteRepositories(selector, proxy)) {
            if (configuredRepos.contains(rep.getUrl())) continue;
            lst.add(rep);
        }
        return lst;
    }

    public static List<RemoteRepository> getRemoteRepositories() throws MalformedURLException {
        return MavenResolver.getRemoteRepositories(null, null);
    }

    public static List<RemoteRepository> getRemoteRepositories(MavenProxySelector proxySelector, Proxy proxy) throws MalformedURLException {
        ArrayList<RemoteRepository> repos = new ArrayList<RemoteRepository>();
        repos.add(MavenResolver.createRepository(proxySelector, proxy, "central", CENTRAL_REPO_URL));
        repos.add(MavenResolver.createRepository(proxySelector, proxy, "redhat-ga", GA_REPO_URL));
        repos.add(MavenResolver.createRepository(proxySelector, proxy, "jboss-nexus", JBOSS_REPO_URL));
        repos.add(MavenResolver.createRepository(proxySelector, proxy, "spring-repo", SPRING_REPO_URL));
        return repos;
    }

    public static List<RemoteRepository> getRHRemoteRepositories() {
        ArrayList<RemoteRepository> repos = new ArrayList<RemoteRepository>();
        RemoteRepository.Builder ga = new RemoteRepository.Builder("redhat-ga", DEFAULT_REPOSITORY_TYPE, GA_REPO_URL);
        ga.setSnapshotPolicy(new RepositoryPolicy(false, "never", "ignore"));
        ga.setReleasePolicy(new RepositoryPolicy(true, "never", "ignore"));
        repos.add(ga.build());
        return repos;
    }

    public static RepositorySystemSession newMavenSession(RepositorySystem repoSystem) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        String localPath = System.getProperty("maven.repo.local");
        Path localCache = localPath == null ? Paths.get(System.getProperty("user.home"), ".m2", "repository") : Paths.get(localPath, new String[0]);
        LocalRepository localRepo = new LocalRepository(localCache.toFile());
        session.setLocalRepositoryManager(repoSystem.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        return session;
    }

    public static RepositorySystemSession newMavenSession(RepositorySystem repoSystem, Path path, ProxySelector proxySelector, boolean offline) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setOffline(offline);
        String localPath = System.getProperty("maven.repo.local");
        Path localCache = localPath == null ? (path == null ? Paths.get(System.getProperty("user.home"), ".m2", "repository") : path) : Paths.get(localPath, new String[0]);
        LocalRepository localRepo = new LocalRepository(localCache.toFile());
        session.setLocalRepositoryManager(repoSystem.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        if (proxySelector != null) {
            session.setProxySelector(proxySelector);
        }
        return session;
    }

    public static RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    private static RemoteRepository createRepository(MavenProxySelector proxySelector, Proxy proxy, String repoName, String repoUrl) throws MalformedURLException {
        boolean useProxy = MavenResolver.useProxy(proxySelector, proxy, new URL(repoUrl).getHost());
        RemoteRepository.Builder remoteRepository = new RemoteRepository.Builder(repoName, DEFAULT_REPOSITORY_TYPE, repoUrl);
        remoteRepository.setSnapshotPolicy(new RepositoryPolicy(false, "never", "ignore"));
        if (useProxy) {
            remoteRepository.setProxy(proxy);
        }
        return remoteRepository.build();
    }

    private static boolean useProxy(MavenProxySelector proxySelector, Proxy proxy, String host) {
        if (proxySelector != null && proxy != null) {
            return proxySelector.proxyFor(host);
        }
        return false;
    }
}

