/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.cli.commands;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.wildfly.glow.AddOn;
import org.wildfly.glow.GlowMessageWriter;
import org.wildfly.glow.Layer;
import org.wildfly.glow.LayerMapping;
import org.wildfly.glow.Utils;
import org.wildfly.glow.cli.commands.AbstractCommand;
import org.wildfly.glow.maven.MavenResolver;
import picocli.CommandLine;

@CommandLine.Command(name="show-add-ons", sortOptions=true)
public class ShowAddOnsCommand
extends AbstractCommand {
    @CommandLine.Option(names={"-c", "--cloud"})
    Optional<Boolean> cloud;
    @CommandLine.Option(names={"-wp", "--wildfly-preview"})
    Optional<Boolean> wildflyPreview;
    @CommandLine.Option(names={"-sv", "--server-version"}, paramLabel="<server version>")
    Optional<String> wildflyServerVersion;
    @CommandLine.Option(names={"--input-feature-packs-file"}, paramLabel="<provisioning file path>")
    Optional<Path> provisioningXml;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() throws Exception {
        this.print("Wildfly Glow is retrieving add-ons...");
        MavenRepoManager resolver = MavenResolver.newMavenResolver();
        UniverseResolver universeResolver = ((UniverseResolver.Builder)UniverseResolver.builder().addArtifactResolver(resolver)).build();
        String context = "bare-metal";
        if (this.cloud.orElse(false).booleanValue()) {
            context = "cloud";
        }
        try (ProvisioningLayout<FeaturePackLayout> layout = Utils.buildLayout(context, this.provisioningXml.orElse(null), this.wildflyServerVersion.orElse(null), GlowMessageWriter.DEFAULT, this.wildflyPreview.orElse(false));){
            Map<String, Layer> all;
            try {
                all = Utils.getAllLayers(universeResolver, layout, new HashMap<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>>());
            }
            finally {
                layout.close();
            }
            LayerMapping mapping = Utils.buildMapping(all, Collections.emptySet());
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, Set<AddOn>> entry : mapping.getAddOnFamilyMembers().entrySet()) {
                builder.append("* @|bold ").append(entry.getKey()).append("|@ add-ons:%n");
                for (AddOn member : mapping.getAddOnFamilyMembers().get(entry.getKey())) {
                    if (member.getName().endsWith(":default")) continue;
                    builder.append(" - ").append(member.getName()).append((String)(member.getDescription() == null ? "" : ": " + member.getDescription())).append("%n");
                }
            }
            this.print(builder.toString());
            this.print("@|bold Add-ons can be set using the|@ @|fg(yellow) %s=<list of add-ons>|@ @|bold option of the|@ @|fg(yellow) %s|@ @|bold command|@", "--add-ons", "scan");
        }
        return 0;
    }
}

