/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.cli.commands;

import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.wildfly.glow.AddOn;
import org.wildfly.glow.Layer;
import org.wildfly.glow.LayerMapping;
import org.wildfly.glow.cli.commands.AbstractCommand;
import org.wildfly.glow.cli.commands.CommandsUtils;
import picocli.CommandLine;

@CommandLine.Command(name="show-add-ons", sortOptions=true)
public class ShowAddOnsCommand
extends AbstractCommand {
    @CommandLine.Option(names={"-c", "--cloud"})
    Optional<Boolean> cloud;
    @CommandLine.Option(names={"-wp", "--wildfly-preview"})
    Optional<Boolean> wildflyPreview;
    @CommandLine.Option(names={"-sv", "--server-version"}, paramLabel="<server version>")
    Optional<String> wildflyServerVersion;
    @CommandLine.Option(names={"--input-feature-packs-file"}, paramLabel="<provisioning file path>")
    Optional<Path> provisioningXml;

    @Override
    public Integer call() throws Exception {
        this.print("Wildfly Glow is retrieving add-ons...");
        String context = "bare-metal";
        if (this.cloud.orElse(false).booleanValue()) {
            context = "cloud";
        }
        CommandsUtils.ProvisioningConsumer consumer = new CommandsUtils.ProvisioningConsumer(){

            @Override
            public void consume(GalleonProvisioningConfig provisioning, Map<String, Layer> all, LayerMapping mapping, Map<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>> fpDependencies) {
                StringBuilder builder = new StringBuilder();
                for (Map.Entry<String, Set<AddOn>> entry : mapping.getAddOnFamilyMembers().entrySet()) {
                    builder.append("* @|bold ").append(entry.getKey()).append("|@ add-ons:%n");
                    for (AddOn member : mapping.getAddOnFamilyMembers().get(entry.getKey())) {
                        if (member.getName().endsWith(":default")) continue;
                        builder.append(" - ").append(member.getName()).append((String)(member.getDescription() == null ? "" : ": " + member.getDescription())).append("%n");
                    }
                }
                ShowAddOnsCommand.this.print(builder.toString());
                ShowAddOnsCommand.this.print("@|bold Add-ons can be set using the|@ @|fg(yellow) %s=<list of add-ons>|@ @|bold option of the|@ @|fg(yellow) %s|@ @|bold command|@", "--add-ons", "scan");
            }
        };
        CommandsUtils.buildProvisioning(consumer, context, this.provisioningXml.orElse(null), this.wildflyServerVersion.isEmpty(), context, this.wildflyPreview.orElse(false));
        return 0;
    }
}

