/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.wildfly.glow.DeploymentScanner;

public abstract class NestedWarOrExplodedArchiveFileVisitor
implements FileVisitor<Path> {
    private final Path rootPath;
    private final boolean archive;

    public NestedWarOrExplodedArchiveFileVisitor(Path rootPath, boolean archive) {
        this.rootPath = rootPath;
        this.archive = archive;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return this.shouldTraversePossibleArchiveDirectory(dir) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    protected boolean shouldTraversePossibleArchiveDirectory(Path dir) {
        if (dir.equals(this.rootPath) || this.archive) {
            return true;
        }
        return !DeploymentScanner.ArchiveType.isArchiveName(dir.getFileName());
    }
}

