/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.cli;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.xml.ProvisioningXmlParser;
import org.wildfly.glow.FeaturePacks;
import org.wildfly.glow.GlowMessageWriter;
import org.wildfly.glow.GlowSession;
import org.wildfly.glow.Layer;
import org.wildfly.glow.LayerMapping;
import org.wildfly.glow.ScanResults;
import org.wildfly.glow.Utils;
import org.wildfly.glow.Version;
import org.wildfly.glow.cli.CLIArguments;
import org.wildfly.glow.maven.MavenResolver;

public class GlowCLI {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        boolean dumpInfos;
        CLIArguments arguments = CLIArguments.fromMainArguments(args);
        if (arguments.isVersion()) {
            System.out.println(Version.getVersion());
            return;
        }
        boolean bl = dumpInfos = args.length == 0 || arguments.isHelp();
        if (dumpInfos || arguments.isDisplayConfigurationInfo()) {
            MavenRepoManager resolver = MavenResolver.newMavenResolver();
            UniverseResolver universeResolver = ((UniverseResolver.Builder)UniverseResolver.builder().addArtifactResolver(resolver)).build();
            try (ProvisioningLayout<FeaturePackLayout> layout = Utils.buildLayout(arguments.getExecutionContext(), null, arguments.getVersion(), GlowMessageWriter.DEFAULT, arguments.isTechPreview());){
                Map<String, Layer> all;
                try {
                    all = Utils.getAllLayers(universeResolver, layout, new HashMap<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>>());
                }
                finally {
                    layout.close();
                }
                Set<String> profiles = Utils.getAllProfiles(all);
                LayerMapping mapping = Utils.buildMapping(all, Collections.emptySet());
                if (dumpInfos) {
                    CLIArguments.dumpInfos(profiles);
                } else {
                    boolean isLatest = arguments.getVersion() == null;
                    String serverVersion = isLatest ? FeaturePacks.getLatestVersion() : arguments.getVersion();
                    Path fps = FeaturePacks.getFeaturePacks(serverVersion, arguments.getExecutionContext(), arguments.isTechPreview());
                    ProvisioningConfig config = ProvisioningXmlParser.parse(fps);
                    CLIArguments.dumpConfiguration(arguments.getExecutionContext(), serverVersion, all, mapping, config, isLatest, arguments.isTechPreview());
                }
            }
            finally {
                IoUtils.recursiveDelete(GlowSession.OFFLINE_CONTENT);
            }
            return;
        }
        if (arguments.isGoOffline()) {
            GlowSession.goOffline(MavenResolver.newMavenResolver(), arguments, GlowMessageWriter.DEFAULT);
        } else {
            ScanResults scanResults = GlowSession.scan(MavenResolver.newMavenResolver(), arguments, GlowMessageWriter.DEFAULT);
            if (arguments.getOutput() == null) {
                scanResults.outputInformation();
            } else {
                scanResults.outputConfig(Paths.get("server", new String[0]), true);
            }
        }
    }
}

