/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow;

import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.progresstracking.ProgressCallback;
import org.jboss.galleon.progresstracking.ProgressTracker;
import org.wildfly.glow.GlowMessageWriter;

public class ProvisioningTracker<T>
implements ProgressCallback<T> {
    private static final String DELAYED_EXECUTION_MSG = "Delayed generation, waiting...";
    private final String msgStart;
    private long lastTime;
    private final boolean delayed;
    private final GlowMessageWriter writer;

    private ProvisioningTracker(String msgStart, boolean delayed, GlowMessageWriter writer) {
        this.msgStart = msgStart;
        this.delayed = delayed;
        this.writer = writer;
    }

    @Override
    public void starting(ProgressTracker<T> tracker) {
        this.writer.info(this.msgStart);
        this.lastTime = System.currentTimeMillis();
    }

    @Override
    public void processing(ProgressTracker<T> tracker) {
        if (this.delayed && tracker.getItem() == null) {
            this.writer.info(DELAYED_EXECUTION_MSG);
            return;
        }
        if (System.currentTimeMillis() - this.lastTime > 5000L) {
            if (tracker.getTotalVolume() > 0L) {
                this.writer.info(String.format("%s of %s (%s%%)", tracker.getProcessedVolume(), tracker.getTotalVolume(), (double)Math.round(tracker.getProgress() * 10.0) / 10.0));
            } else {
                this.writer.info("In progress...");
            }
            this.lastTime = System.currentTimeMillis();
        }
    }

    @Override
    public void processed(ProgressTracker<T> tracker) {
    }

    @Override
    public void pulse(ProgressTracker<T> tracker) {
    }

    @Override
    public void complete(ProgressTracker<T> tracker) {
    }

    public static void initTrackers(ProvisioningManager pm, GlowMessageWriter writer) {
        pm.getLayoutFactory().setProgressCallback("PACKAGES", new ProvisioningTracker("Installing packages", false, writer));
        pm.getLayoutFactory().setProgressCallback("CONFIGS", new ProvisioningTracker("Generating configurations", true, writer));
        pm.getLayoutFactory().setProgressCallback("LAYOUT_BUILD", new ProvisioningTracker("Resolving feature-packs", false, writer));
        pm.getLayoutFactory().setProgressCallback("JBMODULES", new ProvisioningTracker("Resolving artifacts", false, writer));
        pm.getLayoutFactory().setProgressCallback("JBEXTRACONFIGS", new ProvisioningTracker("Generating extra configurations", true, writer));
    }
}

