/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.cli.commands;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.xml.ProvisioningXmlParser;
import org.wildfly.glow.FeaturePacks;
import org.wildfly.glow.GlowMessageWriter;
import org.wildfly.glow.Layer;
import org.wildfly.glow.LayerMapping;
import org.wildfly.glow.Utils;
import org.wildfly.glow.cli.CLIArguments;
import org.wildfly.glow.cli.commands.AbstractCommand;
import org.wildfly.glow.maven.MavenResolver;
import picocli.CommandLine;

@CommandLine.Command(name="show-configuration", sortOptions=true)
public class ShowConfigurationCommand
extends AbstractCommand {
    @CommandLine.Option(names={"-c", "--cloud"})
    Optional<Boolean> cloud;
    @CommandLine.Option(names={"-wp", "--wildfly-preview"})
    Optional<Boolean> wildflyPreview;
    @CommandLine.Option(names={"-sv", "--server-version"}, paramLabel="<server version>")
    Optional<String> wildflyServerVersion;
    @CommandLine.Option(names={"--input-feature-packs-file"}, paramLabel="<provisioning file path>")
    Optional<Path> provisioningXml;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() throws Exception {
        this.print("Wildfly Glow is retrieving know provisioning configuration...");
        MavenRepoManager resolver = MavenResolver.newMavenResolver();
        UniverseResolver universeResolver = ((UniverseResolver.Builder)UniverseResolver.builder().addArtifactResolver(resolver)).build();
        String context = "bare-metal";
        if (this.cloud.orElse(false).booleanValue()) {
            context = "cloud";
        }
        try (ProvisioningLayout<FeaturePackLayout> layout = Utils.buildLayout(context, this.provisioningXml.orElse(null), this.wildflyServerVersion.orElse(null), GlowMessageWriter.DEFAULT, this.wildflyPreview.orElse(false));){
            Map<String, Layer> all;
            HashMap<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>> fpDependencies = new HashMap<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>>();
            try {
                all = Utils.getAllLayers(universeResolver, layout, fpDependencies);
            }
            finally {
                layout.close();
            }
            LayerMapping mapping = Utils.buildMapping(all, Collections.emptySet());
            boolean isLatest = this.wildflyServerVersion.isEmpty();
            String vers = this.wildflyServerVersion.isPresent() ? this.wildflyServerVersion.get() : FeaturePacks.getLatestVersion();
            Path fps = FeaturePacks.getFeaturePacks(vers, context, this.wildflyPreview.orElse(false));
            ProvisioningConfig config = ProvisioningXmlParser.parse(fps);
            String configStr = CLIArguments.dumpConfiguration(fpDependencies, context, vers, all, mapping, config, isLatest, this.wildflyPreview.orElse(false));
            this.print(configStr);
        }
        return 0;
    }
}

