/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.galleon.DefaultMessageWriter;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.diff.FsDiff;
import org.jboss.galleon.diff.FsEntry;
import org.jboss.galleon.diff.FsEntryFactory;
import org.jboss.galleon.diff.ProvisioningDiffProvider;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.FeaturePackPluginVisitor;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.layout.ProvisioningPlan;
import org.jboss.galleon.plugin.StateDiffPlugin;
import org.jboss.galleon.runtime.FeaturePackRuntimeBuilder;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntimeBuilder;
import org.jboss.galleon.state.ProvisionedState;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseFactoryLoader;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.universe.UniverseResolverBuilder;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.util.HashUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.LayoutUtils;
import org.jboss.galleon.util.PathsUtils;
import org.jboss.galleon.util.StateHistoryUtils;
import org.jboss.galleon.xml.ProvisionedStateXmlParser;
import org.jboss.galleon.xml.ProvisioningXmlParser;
import org.jboss.galleon.xml.ProvisioningXmlWriter;

public class ProvisioningManager
implements AutoCloseable {
    private final Path home;
    private final MessageWriter log;
    private boolean logTime;
    private final UniverseResolver universeResolver;
    private ProvisioningLayoutFactory layoutFactory;
    private boolean closeLayoutFactory;
    private ProvisioningConfig provisioningConfig;
    private boolean recordState;

    public static Builder builder() {
        return new Builder();
    }

    private ProvisioningManager(Builder builder) throws ProvisioningException {
        PathsUtils.assertInstallationDir(builder.installationHome);
        this.home = builder.installationHome;
        MessageWriter messageWriter = this.log = builder.messageWriter == null ? DefaultMessageWriter.getDefaultInstance() : builder.messageWriter;
        if (builder.layoutFactory != null) {
            this.layoutFactory = builder.layoutFactory;
            this.closeLayoutFactory = false;
            this.universeResolver = this.layoutFactory.getUniverseResolver();
        } else {
            this.universeResolver = builder.getUniverseResolver();
        }
        this.logTime = builder.logTime;
        this.recordState = builder.recordState;
    }

    public ProvisioningLayoutFactory getLayoutFactory() {
        if (this.layoutFactory == null) {
            this.closeLayoutFactory = true;
            this.layoutFactory = ProvisioningLayoutFactory.getInstance(this.universeResolver);
        }
        return this.layoutFactory;
    }

    public Path getInstallationHome() {
        return this.home;
    }

    public boolean isLogTime() {
        return this.logTime;
    }

    public void setLogTime(boolean logTime) {
        this.logTime = logTime;
    }

    public boolean isRecordState() {
        return this.recordState;
    }

    public void setRecordState(boolean recordState) {
        this.recordState = recordState;
    }

    public void addUniverse(String name, UniverseSpec universeSpec) throws ProvisioningException {
        ProvisioningConfig config = ((ProvisioningConfig.Builder)ProvisioningConfig.builder(this.getProvisioningConfig()).addUniverse(name, universeSpec)).build();
        try {
            ProvisioningXmlWriter.getInstance().write(config, PathsUtils.getProvisioningXml(this.home));
        }
        catch (Exception e) {
            throw new ProvisioningException(Errors.writeFile(PathsUtils.getProvisioningXml(this.home)), e);
        }
        this.provisioningConfig = config;
    }

    public void removeUniverse(String name) throws ProvisioningException {
        ProvisioningConfig config = this.getProvisioningConfig();
        if (config == null || !config.hasUniverse(name)) {
            return;
        }
        config = ((ProvisioningConfig.Builder)ProvisioningConfig.builder(config).removeUniverse(name)).build();
        try {
            ProvisioningXmlWriter.getInstance().write(config, PathsUtils.getProvisioningXml(this.home));
        }
        catch (Exception e) {
            throw new ProvisioningException(Errors.writeFile(PathsUtils.getProvisioningXml(this.home)), e);
        }
        this.provisioningConfig = config;
    }

    public void setDefaultUniverse(UniverseSpec universeSpec) throws ProvisioningException {
        this.addUniverse(null, universeSpec);
    }

    public ProvisioningConfig getProvisioningConfig() throws ProvisioningException {
        return this.provisioningConfig == null ? (this.provisioningConfig = ProvisioningXmlParser.parse(PathsUtils.getProvisioningXml(this.home))) : this.provisioningConfig;
    }

    public ProvisionedState getProvisionedState() throws ProvisioningException {
        return ProvisionedStateXmlParser.parse(PathsUtils.getProvisionedStateXml(this.home));
    }

    public void install(Path featurePack) throws ProvisioningException {
        this.install(featurePack, true);
    }

    public void install(Path featurePack, boolean installInUniverse) throws ProvisioningException {
        this.install(this.getLayoutFactory().addLocal(featurePack, installInUniverse));
    }

    public void install(FeaturePackLocation fpl) throws ProvisioningException {
        this.install(FeaturePackConfig.forLocation(fpl));
    }

    public void install(FeaturePackLocation fpl, Map<String, String> options) throws ProvisioningException {
        this.install(FeaturePackConfig.forLocation(fpl), options);
    }

    public void install(FeaturePackConfig fpConfig) throws ProvisioningException {
        this.install(fpConfig, Collections.emptyMap());
    }

    public void install(FeaturePackConfig fpConfig, Map<String, String> options) throws ProvisioningException {
        ProvisioningConfig config = this.getProvisioningConfig();
        if (config == null) {
            config = ProvisioningConfig.builder().build();
        }
        try (ProvisioningLayout<FeaturePackRuntimeBuilder> layout = this.getLayoutFactory().newConfigLayout(config, ProvisioningRuntimeBuilder.FP_RT_FACTORY, false);){
            UniverseSpec configuredUniverse = this.getConfiguredUniverse(fpConfig.getLocation());
            layout.install(configuredUniverse == null ? fpConfig : FeaturePackConfig.builder(fpConfig.getLocation().replaceUniverse(configuredUniverse)).init(fpConfig).build(), options);
            this.doProvision(layout, this.getFsDiff(), false);
        }
    }

    public void uninstall(FeaturePackLocation.FPID fpid) throws ProvisioningException {
        this.uninstall(fpid, Collections.emptyMap());
    }

    public void uninstall(FeaturePackLocation.FPID fpid, Map<String, String> pluginOptions) throws ProvisioningException {
        ProvisioningConfig config = this.getProvisioningConfig();
        if (config == null || !config.hasFeaturePackDeps()) {
            throw new ProvisioningException(Errors.unknownFeaturePack(fpid));
        }
        try (ProvisioningLayout<FeaturePackRuntimeBuilder> layout = this.getLayoutFactory().newConfigLayout(config, ProvisioningRuntimeBuilder.FP_RT_FACTORY, false);){
            layout.uninstall(this.resolveUniverseSpec(fpid.getLocation()).getFPID(), pluginOptions);
            this.doProvision(layout, this.getFsDiff(), false);
        }
    }

    public void provision(ProvisioningConfig provisioningConfig) throws ProvisioningException {
        this.provision(provisioningConfig, Collections.emptyMap());
    }

    public void provision(ProvisioningConfig provisioningConfig, Map<String, String> options) throws ProvisioningException {
        try (ProvisioningLayout<FeaturePackRuntimeBuilder> layout = this.newConfigLayout(provisioningConfig, options);){
            this.doProvision(layout, this.getFsDiff(), false);
        }
    }

    public void provision(ProvisioningLayout<?> provisioningLayout) throws ProvisioningException {
        try (ProvisioningLayout<FeaturePackRuntimeBuilder> layout = provisioningLayout.transform(ProvisioningRuntimeBuilder.FP_RT_FACTORY);){
            this.doProvision(layout, this.getFsDiff(), false);
        }
    }

    public void provision(Path provisioningXml) throws ProvisioningException {
        this.provision(provisioningXml, Collections.emptyMap());
    }

    public void provision(Path provisioningXml, Map<String, String> options) throws ProvisioningException {
        try (ProvisioningLayout<FeaturePackRuntimeBuilder> layout = this.newConfigLayout(ProvisioningXmlParser.parse(provisioningXml), options);){
            this.doProvision(layout, this.getFsDiff(), false);
        }
    }

    public ProvisioningPlan getUpdates(boolean includeTransitive) throws ProvisioningException {
        ProvisioningPlan plan;
        ProvisioningConfig config = this.getProvisioningConfig();
        if (config == null) {
            plan = ProvisioningPlan.builder();
        } else {
            try (ProvisioningLayout<FeaturePackLayout> layout = this.getLayoutFactory().newConfigLayout(config);){
                plan = layout.getUpdates(includeTransitive);
            }
        }
        return plan;
    }

    public ProvisioningPlan getUpdates(FeaturePackLocation.ProducerSpec ... producers) throws ProvisioningException {
        ProvisioningPlan plan;
        ProvisioningConfig config = this.getProvisioningConfig();
        if (config == null) {
            plan = ProvisioningPlan.builder();
        } else {
            try (ProvisioningLayout<FeaturePackLayout> layout = this.getLayoutFactory().newConfigLayout(config);){
                plan = layout.getUpdates(producers);
            }
        }
        return plan;
    }

    public void apply(ProvisioningPlan plan) throws ProvisioningException {
        this.apply(plan, Collections.emptyMap());
    }

    public void apply(ProvisioningPlan plan, Map<String, String> options) throws ProvisioningException {
        ProvisioningConfig config = this.getProvisioningConfig();
        if (config == null) {
            config = ProvisioningConfig.builder().build();
        }
        try (ProvisioningLayout<FeaturePackRuntimeBuilder> layout = this.getLayoutFactory().newConfigLayout(config, ProvisioningRuntimeBuilder.FP_RT_FACTORY, false);){
            layout.apply(plan, options);
            this.doProvision(layout, this.getFsDiff(), false);
        }
    }

    public boolean persistChanges() throws ProvisioningException {
        ProvisioningDiffProvider diffProvider = this.getDiffMergedConfig();
        if (diffProvider == null) {
            return false;
        }
        ProvisioningConfig mergedConfig = diffProvider.getMergedConfig();
        if (mergedConfig.equals(this.getProvisioningConfig())) {
            return false;
        }
        try (ProvisioningLayout<FeaturePackRuntimeBuilder> layout = this.getLayoutFactory().newConfigLayout(mergedConfig, ProvisioningRuntimeBuilder.FP_RT_FACTORY, false);){
            this.doProvision(layout, diffProvider.getFsDiff(), false);
        }
        return true;
    }

    public boolean isUndoAvailable() throws ProvisioningException {
        return StateHistoryUtils.isUndoAvailable(this.home, this.log);
    }

    public int getStateHistoryLimit() throws ProvisioningException {
        return StateHistoryUtils.readStateHistoryLimit(this.home, this.log);
    }

    public void setStateHistoryLimit(int limit) throws ProvisioningException {
        StateHistoryUtils.writeStateHistoryLimit(this.home, limit, this.log);
    }

    public void clearStateHistory() throws ProvisioningException {
        StateHistoryUtils.clearStateHistory(this.home, this.log);
    }

    public void undo() throws ProvisioningException {
        try (ProvisioningLayout<FeaturePackRuntimeBuilder> layout = this.newConfigLayout(StateHistoryUtils.readUndoConfig(this.home, this.log), Collections.emptyMap());){
            this.doProvision(layout, this.getFsDiff(), true);
        }
    }

    public void exportProvisioningConfig(Path location) throws ProvisioningException, IOException {
        Path exportPath = location;
        Path userProvisionedXml = PathsUtils.getProvisioningXml(this.home);
        if (!Files.exists(userProvisionedXml, new LinkOption[0])) {
            throw new ProvisioningException("Provisioned state record is missing for " + this.home);
        }
        if (Files.isDirectory(exportPath, new LinkOption[0])) {
            exportPath = exportPath.resolve(userProvisionedXml.getFileName());
        }
        IoUtils.copy(userProvisionedXml, exportPath);
    }

    public ProvisioningRuntime getRuntime(ProvisioningConfig provisioningConfig) throws ProvisioningException {
        return this.getRuntimeInternal(this.newConfigLayout(provisioningConfig, Collections.emptyMap()), null);
    }

    private ProvisioningLayout<FeaturePackRuntimeBuilder> newConfigLayout(ProvisioningConfig provisioningConfig, Map<String, String> pluginOptions) throws ProvisioningException {
        return this.getLayoutFactory().newConfigLayout(provisioningConfig, ProvisioningRuntimeBuilder.FP_RT_FACTORY, pluginOptions);
    }

    public ProvisioningRuntime getRuntime(ProvisioningLayout<?> provisioningLayout) throws ProvisioningException {
        return this.getRuntimeInternal(provisioningLayout.transform(ProvisioningRuntimeBuilder.FP_RT_FACTORY), null);
    }

    private ProvisioningRuntime getRuntimeInternal(ProvisioningLayout<FeaturePackRuntimeBuilder> layout, FsDiff fsDiff) throws ProvisioningException {
        return this.getRuntimeInternal(layout, fsDiff, false);
    }

    private ProvisioningRuntime getRuntimeInternal(ProvisioningLayout<FeaturePackRuntimeBuilder> layout, FsDiff fsDiff, boolean setStagedDir) throws ProvisioningException {
        ProvisioningRuntimeBuilder rtBuilder = ProvisioningRuntimeBuilder.newInstance(this.log).initRtLayout(layout).setLogTime(this.logTime).setFsDiff(fsDiff).setRecordState(this.recordState);
        if (setStagedDir) {
            rtBuilder.setStagedDir(this.home);
        }
        return rtBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProvision(ProvisioningLayout<FeaturePackRuntimeBuilder> layout, FsDiff fsDiff, boolean undo) throws ProvisioningException {
        boolean freshInstall = PathsUtils.isNewHome(this.home);
        try (ProvisioningRuntime runtime = this.getRuntimeInternal(layout, fsDiff, freshInstall);){
            Path stagedDir;
            block37: {
                Map<Object, Object> undoTasks;
                runtime.provision();
                if (this.recordState) {
                    if (runtime.getProvisioningConfig().hasFeaturePackDeps()) {
                        this.persistHashes(runtime);
                    }
                    if (undo && !(undoTasks = StateHistoryUtils.readUndoTasks(this.home, this.log)).isEmpty()) {
                        Path staged = runtime.getStagedDir();
                        for (Map.Entry<Object, Object> entry : undoTasks.entrySet()) {
                            Path stagedPath = staged.resolve((String)entry.getKey());
                            if (((Boolean)entry.getValue()).booleanValue()) {
                                Path homePath = this.home.resolve((String)entry.getKey());
                                if (!Files.exists(homePath, new LinkOption[0])) continue;
                                try {
                                    IoUtils.copy(homePath, stagedPath);
                                    continue;
                                }
                                catch (IOException e) {
                                    throw new ProvisioningException(Errors.copyFile(homePath, stagedPath), e);
                                }
                            }
                            IoUtils.recursiveDelete(stagedPath);
                        }
                    }
                }
                undoTasks = Collections.emptyMap();
                if (fsDiff != null && !fsDiff.isEmpty()) {
                    undoTasks = FsDiff.replay(fsDiff, runtime.getStagedDir(), this.log, Boolean.parseBoolean(runtime.getProvisioningConfig().getOption("print-only-conflicts")), runtime.getSystemPaths());
                }
                if (freshInstall) {
                    return;
                }
                this.log.verbose("Moving the provisioned installation from the staged directory to %s", this.home);
                stagedDir = runtime.getStagedDir();
                if (Files.exists(this.home, new LinkOption[0])) {
                    if (this.recordState) {
                        if (undo) {
                            StateHistoryUtils.removeLastUndoConfig(this.home, stagedDir, this.log);
                        } else {
                            StateHistoryUtils.addNewUndoConfig(this.home, stagedDir, undoTasks, this.log);
                        }
                        IoUtils.recursiveDelete(this.home);
                    } else {
                        if (Files.exists(PathsUtils.getProvisionedStateDir(this.home), new LinkOption[0])) {
                            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.home);){
                                for (Path p : stream) {
                                    if (p.getFileName().toString().equals(".galleon")) continue;
                                    IoUtils.recursiveDelete(p);
                                }
                                break block37;
                            }
                            catch (IOException e) {
                                throw new ProvisioningException(Errors.readDirectory(this.home), e);
                            }
                        }
                        IoUtils.recursiveDelete(this.home);
                    }
                }
            }
            try {
                IoUtils.copy(stagedDir, this.home, true);
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.copyFile(stagedDir, this.home));
            }
        }
        finally {
            this.provisioningConfig = null;
        }
    }

    public FsDiff getFsDiff() throws ProvisioningException {
        ProvisioningConfig config = this.getProvisioningConfig();
        if (config == null || !config.hasFeaturePackDeps()) {
            return null;
        }
        this.log.verbose("Detecting user changes");
        Path hashesDir = LayoutUtils.getHashesDir(this.getInstallationHome());
        if (Files.exists(hashesDir, new LinkOption[0])) {
            FsEntry originalState = new FsEntry(null, hashesDir);
            ProvisioningManager.readHashes(originalState, new ArrayList<FsEntry>());
            FsEntry currentState = ProvisioningManager.getDefaultFsEntryFactory().forPath(this.getInstallationHome());
            return FsDiff.diff(originalState, currentState);
        }
        try (ProvisioningRuntime rt = this.getRuntime(config);){
            rt.provision();
            FsEntryFactory fsFactory = ProvisioningManager.getDefaultFsEntryFactory();
            FsEntry originalState = fsFactory.forPath(rt.getStagedDir());
            FsEntry currentState = fsFactory.forPath(this.getInstallationHome());
            long startTime = this.log.isVerboseEnabled() ? System.nanoTime() : -1L;
            FsDiff fsDiff = FsDiff.diff(originalState, currentState);
            if (startTime != -1L) {
                this.log.verbose(Errors.tookTime("  filesystem diff", startTime));
            }
            FsDiff fsDiff2 = fsDiff;
            return fsDiff2;
        }
    }

    private ProvisioningDiffProvider getDiffMergedConfig() throws ProvisioningException {
        FsDiff diff = this.getFsDiff();
        if (diff == null || diff.isEmpty()) {
            return null;
        }
        try (ProvisioningLayout<FeaturePackRuntimeBuilder> layout = this.layoutFactory.newConfigLayout(this.getProvisioningConfig(), ProvisioningRuntimeBuilder.FP_RT_FACTORY, false);){
            final ProvisioningDiffProvider diffProvider = ProvisioningDiffProvider.newInstance(layout, this.getProvisionedState(), diff, this.log);
            layout.visitPlugins(new FeaturePackPluginVisitor<StateDiffPlugin>(){

                @Override
                public void visitPlugin(StateDiffPlugin plugin) throws ProvisioningException {
                    plugin.diff(diffProvider);
                }
            }, StateDiffPlugin.class);
            ProvisioningDiffProvider provisioningDiffProvider = diffProvider;
            return provisioningDiffProvider;
        }
    }

    private FeaturePackLocation resolveUniverseSpec(FeaturePackLocation fpl) throws ProvisioningException {
        UniverseSpec universeSpec = this.getConfiguredUniverse(fpl);
        return universeSpec == null ? fpl : fpl.replaceUniverse(universeSpec);
    }

    private UniverseSpec getConfiguredUniverse(FeaturePackLocation fpl) throws ProvisioningException, ProvisioningDescriptionException {
        ProvisioningConfig config = this.getProvisioningConfig();
        if (config == null) {
            return null;
        }
        if (fpl.hasUniverse()) {
            String name = fpl.getUniverse().toString();
            if (config.hasUniverse(name)) {
                return config.getUniverseSpec(name);
            }
            return null;
        }
        return config.getDefaultUniverse();
    }

    @Override
    public void close() {
        if (this.closeLayoutFactory) {
            this.layoutFactory.close();
        }
    }

    private static void readHashes(FsEntry parent, List<FsEntry> dirs) throws ProvisioningException {
        int dirsTotal = 0;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(parent.getPath());){
            for (Path child : stream) {
                if (child.getFileName().toString().equals("hashes")) {
                    try {
                        BufferedReader reader = Files.newBufferedReader(child);
                        try {
                            String line = reader.readLine();
                            while (line != null) {
                                new FsEntry(parent, line, HashUtils.hexStringToByteArray(reader.readLine()));
                                line = reader.readLine();
                            }
                            continue;
                        }
                        finally {
                            if (reader == null) continue;
                            reader.close();
                            continue;
                        }
                    }
                    catch (IOException e) {
                        throw new ProvisioningException("Failed to read hashes", e);
                    }
                }
                dirs.add(new FsEntry(parent, child));
                ++dirsTotal;
            }
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to read hashes", e);
        }
        while (dirsTotal > 0) {
            ProvisioningManager.readHashes(dirs.remove(dirs.size() - 1), dirs);
            --dirsTotal;
        }
    }

    private static FsEntryFactory getDefaultFsEntryFactory() {
        return FsEntryFactory.getInstance().filterGalleonPaths();
    }

    private void persistHashes(ProvisioningRuntime runtime) throws ProvisioningException {
        long startTime = this.log.isVerboseEnabled() ? System.nanoTime() : -1L;
        FsEntry root = ProvisioningManager.getDefaultFsEntryFactory().forPath(runtime.getStagedDir());
        if (root.hasChildren()) {
            Path hashes = LayoutUtils.getHashesDir(runtime.getStagedDir());
            try {
                Files.createDirectories(hashes, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ProvisioningException("Failed to persist hashes", e);
            }
            ArrayList<FsEntry> dirs = new ArrayList<FsEntry>();
            this.persistChildHashes(hashes, root, dirs, hashes);
            if (!dirs.isEmpty()) {
                for (int i = dirs.size() - 1; i >= 0; --i) {
                    this.persistDirHashes(hashes, (FsEntry)dirs.get(i), dirs);
                }
            }
        }
        if (startTime != -1L) {
            this.log.verbose(Errors.tookTime("Hashing", startTime));
        }
    }

    private void persistDirHashes(Path hashes, FsEntry entry, List<FsEntry> dirs) throws ProvisioningException {
        Path target = hashes.resolve(entry.getRelativePath());
        try {
            Files.createDirectory(target, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.hashesNotPersisted(), e);
        }
        if (entry.hasChildren()) {
            this.persistChildHashes(hashes, entry, dirs, target);
        }
    }

    private void persistChildHashes(Path hashes, FsEntry entry, List<FsEntry> dirs, Path target) throws ProvisioningException {
        int dirsTotal = 0;
        BufferedWriter writer = null;
        try {
            for (FsEntry child : entry.getChildren()) {
                if (!child.isDir()) {
                    if (writer == null) {
                        writer = Files.newBufferedWriter(target.resolve("hashes"), new OpenOption[0]);
                    }
                    writer.write(child.getName());
                    writer.newLine();
                    writer.write(HashUtils.bytesToHexString(child.getHash()));
                    writer.newLine();
                    continue;
                }
                dirs.add(child);
                ++dirsTotal;
            }
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.hashesNotPersisted(), e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    this.log.error(e, Errors.fileClose(target.resolve("hashes")));
                }
            }
        }
        while (dirsTotal > 0) {
            this.persistDirHashes(hashes, dirs.remove(dirs.size() - 1), dirs);
            --dirsTotal;
        }
    }

    public static class Builder
    extends UniverseResolverBuilder<Builder> {
        private Path installationHome;
        private ProvisioningLayoutFactory layoutFactory;
        private MessageWriter messageWriter;
        private UniverseResolver resolver;
        private boolean logTime;
        private boolean recordState = true;

        private Builder() {
        }

        public Builder setInstallationHome(Path installationHome) {
            this.installationHome = installationHome;
            return this;
        }

        public Builder setLayoutFactory(ProvisioningLayoutFactory layoutFactory) throws ProvisioningException {
            if (this.ufl != null) {
                throw new ProvisioningException("Universe factory loader has already been initialized which conflicts with the initialization of provisioning layout factory");
            }
            if (this.resolver != null) {
                throw new ProvisioningException("Universe resolver has already been initialized which conflicts with the initialization of provisioning layout factory");
            }
            this.layoutFactory = layoutFactory;
            return this;
        }

        @Override
        protected UniverseFactoryLoader getUfl() throws ProvisioningException {
            if (this.layoutFactory != null) {
                throw new ProvisioningException("Provisioning layout factory has already been initialized which conflicts with the initialization of universe factory loader");
            }
            if (this.resolver != null) {
                throw new ProvisioningException("Universe resolver has already been initialized which conflicts with the initialization of universe factory loader");
            }
            return super.getUfl();
        }

        public Builder setMessageWriter(MessageWriter messageWriter) {
            this.messageWriter = messageWriter;
            return this;
        }

        public Builder setUniverseResolver(UniverseResolver resolver) throws ProvisioningException {
            if (this.ufl != null) {
                throw new ProvisioningException("Universe factory loader has already been initialized which conflicts with the initialization of universe resolver");
            }
            if (this.layoutFactory != null) {
                throw new ProvisioningException("Provisioning layout factory has already been initialized which conflicts with the initialization of universe resolver");
            }
            this.resolver = resolver;
            return this;
        }

        public Builder setLogTime(boolean logTime) {
            this.logTime = logTime;
            return this;
        }

        public Builder setRecordState(boolean recordState) {
            this.recordState = recordState;
            return this;
        }

        public ProvisioningManager build() throws ProvisioningException {
            return new ProvisioningManager(this);
        }

        protected UniverseResolver getUniverseResolver() throws ProvisioningException {
            return this.resolver == null ? this.buildUniverseResolver() : this.resolver;
        }
    }
}

