/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.runtime.FeaturePackRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;
import org.wildfly.plugins.bootablejar.ArtifactLog;
import org.wildfly.plugins.bootablejar.ScannedArtifacts;

public class BootableJarSupport {
    public static final String BOOTABLE_SUFFIX = "bootable";
    public static final String JBOSS_MODULES_GROUP_ID = "org.jboss.modules";
    public static final String JBOSS_MODULES_ARTIFACT_ID = "jboss-modules";
    private static final String MODULE_ID_JAR_RUNTIME = "org.wildfly.bootable-jar";
    private static final String BOOT_ARTIFACT_ID = "wildfly-jar-boot";
    public static final String WILDFLY_ARTIFACT_VERSIONS_RESOURCE_PATH = "wildfly/artifact-versions.properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void packageBootableJar(Path targetJarFile, Path target, ProvisioningConfig config, Path serverHome, MavenRepoManager resolver, MessageWriter writer, ArtifactLog log, String bootableJARVersion) throws Exception {
        Path contentRootDir = target.resolve("bootable-jar-build-artifacts");
        if (Files.exists(contentRootDir, new LinkOption[0])) {
            IoUtils.recursiveDelete(contentRootDir);
        }
        Files.createDirectories(contentRootDir, new FileAttribute[0]);
        try {
            ScannedArtifacts bootable;
            BootableJarSupport.zipServer(serverHome, contentRootDir);
            Path emptyHome = contentRootDir.resolve("tmp-home");
            Files.createDirectories(emptyHome, new FileAttribute[0]);
            try (ProvisioningManager pm = ((ProvisioningManager.Builder)ProvisioningManager.builder().addArtifactResolver(resolver)).setInstallationHome(emptyHome).setMessageWriter(writer).build();){
                bootable = BootableJarSupport.scanArtifacts(pm, config, log);
            }
            if (bootableJARVersion != null) {
                try (InputStream stream = BootableJarSupport.class.getClassLoader().getResourceAsStream("config.properties");){
                    Properties props = new Properties();
                    props.load(stream);
                    BootableJarSupport.unzipCloudExtension(contentRootDir, bootableJARVersion, resolver);
                    Path marker = contentRootDir.resolve("openshift.properties");
                    Files.createFile(marker, new FileAttribute[0]);
                }
            }
            BootableJarSupport.buildJar(contentRootDir, targetJarFile, bootable, resolver);
        }
        finally {
            IoUtils.recursiveDelete(contentRootDir);
        }
    }

    public static void unzipCloudExtension(Path contentDir, String version, MavenRepoManager resolver) throws MavenUniverseException, IOException {
        MavenArtifact ma = new MavenArtifact();
        ma.setGroupId("org.wildfly.plugins");
        ma.setArtifactId("wildfly-jar-cloud-extension");
        ma.setExtension("jar");
        ma.setVersion(version);
        resolver.resolve(ma);
        ZipUtils.unzip(ma.getPath(), contentDir);
    }

    public static void zipServer(Path home, Path contentDir) throws IOException {
        BootableJarSupport.cleanupServer(home);
        Path target = contentDir.resolve("wildfly.zip");
        BootableJarSupport.zip(home, target);
    }

    private static void cleanupServer(Path jbossHome) throws IOException {
        Path history = jbossHome.resolve("standalone").resolve("configuration").resolve("standalone_xml_history");
        IoUtils.recursiveDelete(history);
        Files.deleteIfExists(jbossHome.resolve("README.txt"));
    }

    public static void zip(Path contentDir, Path jarFile) throws IOException {
        ZipUtils.zip(contentDir, jarFile);
    }

    public static ScannedArtifacts scanArtifacts(ProvisioningManager pm, ProvisioningConfig config, ArtifactLog log) throws Exception {
        HashSet<MavenArtifact> cliArtifacts = new HashSet<MavenArtifact>();
        MavenArtifact jbossModules = null;
        MavenArtifact bootArtifact = null;
        try (ProvisioningRuntime rt = pm.getRuntime(config);){
            for (FeaturePackRuntime fprt : rt.getFeaturePacks()) {
                MavenArtifact a;
                String value;
                HashMap<String, String> propsMap;
                Path artifactProps;
                if (fprt.getPackage(MODULE_ID_JAR_RUNTIME) != null) {
                    artifactProps = fprt.getResource(WILDFLY_ARTIFACT_VERSIONS_RESOURCE_PATH);
                    propsMap = new HashMap<String, String>();
                    try {
                        BootableJarSupport.readProperties(artifactProps, propsMap);
                    }
                    catch (Exception ex) {
                        throw new Exception("Error reading artifact versions", ex);
                    }
                    for (Map.Entry entry : propsMap.entrySet()) {
                        value = (String)entry.getValue();
                        a = BootableJarSupport.getArtifact(value);
                        if (!BOOT_ARTIFACT_ID.equals(a.getArtifactId())) continue;
                        log.info(fprt.getFPID(), a);
                        bootArtifact = a;
                        break;
                    }
                }
                artifactProps = fprt.getResource(WILDFLY_ARTIFACT_VERSIONS_RESOURCE_PATH);
                propsMap = new HashMap();
                try {
                    BootableJarSupport.readProperties(artifactProps, propsMap);
                }
                catch (Exception ex) {
                    throw new Exception("Error reading artifact versions", ex);
                }
                for (Map.Entry entry : propsMap.entrySet()) {
                    value = (String)entry.getValue();
                    a = BootableJarSupport.getArtifact(value);
                    if ("wildfly-cli".equals(a.getArtifactId()) && "org.wildfly.core".equals(a.getGroupId())) {
                        a.setClassifier("client");
                        log.debug(fprt.getFPID(), a);
                        cliArtifacts.add(a);
                        continue;
                    }
                    if ("wildfly-patching".equals(a.getArtifactId()) && "org.wildfly.core".equals(a.getGroupId())) {
                        log.debug(fprt.getFPID(), a);
                        cliArtifacts.add(a);
                        continue;
                    }
                    if ("wildfly-controller".equals(a.getArtifactId()) && "org.wildfly.core".equals(a.getGroupId())) {
                        log.debug(fprt.getFPID(), a);
                        cliArtifacts.add(a);
                        continue;
                    }
                    if ("wildfly-version".equals(a.getArtifactId()) && "org.wildfly.core".equals(a.getGroupId())) {
                        log.debug(fprt.getFPID(), a);
                        cliArtifacts.add(a);
                        continue;
                    }
                    if ("vdx-core".equals(a.getArtifactId()) && "org.projectodd.vdx".equals(a.getGroupId())) {
                        log.debug(fprt.getFPID(), a);
                        cliArtifacts.add(a);
                        continue;
                    }
                    if (!JBOSS_MODULES_ARTIFACT_ID.equals(a.getArtifactId()) || !JBOSS_MODULES_GROUP_ID.equals(a.getGroupId())) continue;
                    jbossModules = a;
                }
            }
        }
        if (bootArtifact == null) {
            throw new ProvisioningException("Server doesn't support bootable jar packaging");
        }
        if (jbossModules == null) {
            throw new ProvisioningException("JBoss Modules not found in dependency, can't create a Bootable JAR");
        }
        return new ScannedArtifacts(bootArtifact, jbossModules, cliArtifacts);
    }

    public static void buildJar(Path contentDir, Path jarFile, ScannedArtifacts bootable, MavenRepoManager resolver) throws Exception {
        resolver.resolve(bootable.getBoot());
        Path rtJarFile = bootable.getBoot().getPath();
        resolver.resolve(bootable.getJbossModules());
        Path jbossModulesFile = bootable.getJbossModules().getPath();
        ZipUtils.unzip(jbossModulesFile, contentDir);
        ZipUtils.unzip(rtJarFile, contentDir);
        BootableJarSupport.zip(contentDir, jarFile);
    }

    private static void readProperties(Path propsFile, Map<String, String> propsMap) throws Exception {
        try (BufferedReader reader = Files.newBufferedReader(propsFile);){
            String line = reader.readLine();
            while (line != null) {
                if (!(line = line.trim()).isEmpty() && line.charAt(0) != '#') {
                    int i = line.indexOf(61);
                    if (i < 0) {
                        throw new Exception("Failed to parse property " + line + " from " + propsFile);
                    }
                    propsMap.put(line.substring(0, i), line.substring(i + 1));
                }
                line = reader.readLine();
            }
        }
    }

    static MavenArtifact getArtifact(String str) {
        String[] parts = str.split(":");
        String groupId = parts[0];
        String artifactId = parts[1];
        String version = parts[2];
        String classifier = parts[3];
        String extension = parts[4];
        MavenArtifact ma = new MavenArtifact();
        ma.setGroupId(groupId);
        ma.setArtifactId(artifactId);
        ma.setVersion(version);
        ma.setClassifier(classifier);
        ma.setExtension(extension);
        return ma;
    }
}

