/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.maven.plugin.util;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.apache.maven.shared.dependencies.DependableCoordinate;
import org.jboss.galleon.maven.plugin.util.ConfigurationId;
import org.jboss.galleon.util.StringUtils;

public class FeaturePack
implements DependableCoordinate,
ArtifactCoordinate {
    private String groupId;
    private String artifactId;
    private String version;
    private String type = "zip";
    private String classifier;
    private String extension = "zip";
    private boolean transitiveDep;
    private String location;
    private Boolean inheritConfigs;
    private List<ConfigurationId> includedConfigs = Collections.emptyList();
    private List<ConfigurationId> excludedConfigs = Collections.emptyList();
    private Boolean inheritPackages;
    private List<String> excludedPackages = Collections.emptyList();
    private List<String> includedPackages = Collections.emptyList();
    private Path path;

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.assertGalleon1Location();
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.assertGalleon1Location();
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.assertGalleon1Location();
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.assertGalleon1Location();
        this.type = type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.assertGalleon1Location();
        this.classifier = classifier;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.assertGalleon1Location();
        this.extension = extension;
    }

    public boolean isTransitive() {
        return this.transitiveDep;
    }

    public void setTransitive(boolean transitiveDep) {
        this.transitiveDep = transitiveDep;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.assertGalleon2Location();
        this.location = location;
    }

    public Boolean isInheritPackages() {
        return this.inheritPackages;
    }

    public void setInheritPackages(boolean inheritPackages) {
        this.inheritPackages = inheritPackages;
    }

    public Boolean isInheritConfigs() {
        return this.inheritConfigs;
    }

    public void setInheritConfigs(boolean inheritConfigs) {
        this.inheritConfigs = inheritConfigs;
    }

    public List<ConfigurationId> getIncludedConfigs() {
        return this.includedConfigs;
    }

    public void setIncludedConfigs(List<ConfigurationId> includedConfigs) {
        this.includedConfigs = includedConfigs;
    }

    public List<ConfigurationId> getExcludedConfigs() {
        return this.excludedConfigs;
    }

    public void setExcludedConfigs(List<ConfigurationId> excludedConfigs) {
        this.excludedConfigs = excludedConfigs;
    }

    public List<String> getExcludedPackages() {
        return this.excludedPackages;
    }

    public void setExcludedPackages(List<String> excludedPackages) {
        this.excludedPackages = excludedPackages;
    }

    public List<String> getIncludedPackages() {
        return this.includedPackages;
    }

    public void setIncludedPackages(List<String> includedPackages) {
        this.includedPackages = includedPackages;
    }

    public void setPath(File path) {
        this.assertPathLocation();
        this.path = path.toPath().normalize();
    }

    public Path getNormalizedPath() {
        return this.path;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        if (this.transitiveDep) {
            buf.append("transitive ");
        }
        if (this.location != null) {
            buf.append(this.location);
        } else {
            buf.append(this.groupId).append(':').append(this.artifactId).append(':').append(this.version);
        }
        buf.append(" inherit-packages=").append(this.inheritPackages);
        if (!this.includedPackages.isEmpty()) {
            buf.append(" included-packages=");
            StringUtils.appendList(buf, this.includedPackages);
        }
        if (!this.excludedPackages.isEmpty()) {
            buf.append(" excluded-packages=");
            StringUtils.appendList(buf, this.excludedPackages);
        }
        buf.append(" inherit-configs=").append(this.inheritConfigs);
        if (!this.includedConfigs.isEmpty()) {
            buf.append(" included-configs=");
            StringUtils.appendList(buf, this.includedConfigs);
        }
        if (!this.excludedConfigs.isEmpty()) {
            buf.append(" excluded-configs=");
            StringUtils.appendList(buf, this.excludedConfigs);
        }
        return buf.append('}').toString();
    }

    private void assertPathLocation() {
        if (this.groupId != null || this.artifactId != null || this.version != null) {
            throw new IllegalStateException("feature-pack Path cannot be used: Galleon 1.x feature-pack Maven coordinates have already been initialized");
        }
        if (this.location != null) {
            throw new IllegalStateException("feature-pack Path cannot be used: Galleon 2.x location has already been initialized");
        }
    }

    private void assertGalleon2Location() {
        if (this.groupId != null || this.artifactId != null || this.version != null) {
            throw new IllegalStateException("Galleon 2.x location cannot be used: feature-pack Maven coordinates have already been initialized");
        }
        if (this.path != null) {
            throw new IllegalStateException("Galleon 2.x location cannot be used: feature-pack Path has already been initialized");
        }
    }

    private void assertGalleon1Location() {
        if (this.location != null) {
            throw new IllegalStateException("Galleon 1.x feature-pack Maven coordinates cannot be used: Galleon 2.x feature-pack location has already been initialized");
        }
        if (this.path != null) {
            throw new IllegalStateException("Galleon 1.x feature-pack Maven coordinates cannot be used: feature-pack Path has already been initialized");
        }
    }
}

