/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.wildfly.glow.GoOfflineArguments;
import org.wildfly.glow.OutputFormat;

public interface ScanArguments {
    public Set<String> getExecutionProfiles();

    public Set<String> getUserEnabledAddOns();

    public List<Path> getBinaries();

    public Path getProvisioningXML();

    public OutputFormat getOutput();

    public String getExecutionContext();

    public boolean isSuggest();

    public boolean isCloud();

    public String getVersion();

    public Boolean isCompact();

    public boolean isTechPreview();

    public Set<Pattern> getExcludeArchivesFromScan();

    default public Builder createScanArgumentsBuilder() {
        return new Builder();
    }

    public static class Builder
    extends GoOfflineArguments.Builder {
        Builder() {
        }

        public Builder setExecutionProfiles(Set<String> executionProfiles) {
            this.executionProfiles = executionProfiles;
            return this;
        }

        public Builder setUserEnabledAddOns(Set<String> userEnabledAddOns) {
            this.userEnabledAddOns = userEnabledAddOns;
            return this;
        }

        public Builder setBinaries(List<Path> binaries) {
            this.binaries = binaries;
            return this;
        }

        @Override
        public Builder setProvisoningXML(Path provisoningXML) {
            this.provisioningXML = provisoningXML;
            return this;
        }

        public Builder setOutput(OutputFormat output) {
            this.output = output;
            return this;
        }

        public Builder setSuggest(boolean suggest) {
            this.suggest = suggest;
            return this;
        }

        @Override
        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder setExecutionContext(String executionContext) {
            this.executionContext = executionContext;
            return this;
        }

        public Builder setConfigName(String configName) {
            this.configName = configName;
            return this;
        }

        public Builder setJndiLayers(Set<String> layersForJndi) {
            this.layersForJndi = layersForJndi;
            return this;
        }

        public Builder setVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder setTechPreview(boolean techPreview) {
            this.techPreview = techPreview;
            return this;
        }

        public Builder setExcludeArchivesFromScan(String ... archives) {
            return this.setExcludeArchivesFromScan(new HashSet<String>(Arrays.asList(archives)));
        }

        public Builder setExcludeArchivesFromScan(Set<String> archives) {
            this.excludeJarsFromScan = archives;
            return this;
        }
    }
}

