/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.deployment.openshift.artemis;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.Updatable;
import io.fabric8.openshift.client.OpenShiftClient;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.wildfly.glow.GlowMessageWriter;
import org.wildfly.glow.deployment.openshift.api.Deployer;
import org.wildfly.glow.deployment.openshift.api.Utils;

public class ArtemisDeployer
implements Deployer {
    private static final String REMOTE_BROKER_NAME = "artemis-broker";
    private static final String REMOTE_BROKER_PASSWORD = "admin";
    private static final String REMOTE_BROKER_USER = "admin";
    private static final Map<String, String> REMOTE_BROKER_CONNECTION_MAP = new HashMap<String, String>();
    private static final Map<String, String> REMOTE_BROKER_APP_MAP = new HashMap<String, String>();

    @Override
    public Map<String, String> deploy(GlowMessageWriter writer, Path target, OpenShiftClient osClient, Map<String, String> env, String appHost, String appName, String matching) throws Exception {
        writer.info("\nDeploying Artemis Messaging Broker");
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("deployment", REMOTE_BROKER_NAME);
        ContainerPort port = new ContainerPort();
        port.setContainerPort(61616);
        port.setProtocol("TCP");
        ArrayList<ContainerPort> ports = new ArrayList<ContainerPort>();
        ports.add(port);
        ArrayList<EnvVar> vars = new ArrayList<EnvVar>();
        for (Map.Entry<String, String> entry : REMOTE_BROKER_CONNECTION_MAP.entrySet()) {
            vars.add(((EnvVarBuilder)((EnvVarBuilder)new EnvVar().toBuilder().withName(entry.getKey())).withValue(entry.getValue())).build());
        }
        Container container = new Container();
        container.setName(REMOTE_BROKER_NAME);
        container.setImage("quay.io/artemiscloud/activemq-artemis-broker-kubernetes");
        container.setPorts(ports);
        container.setEnv(vars);
        container.setImagePullPolicy("IfNotPresent");
        Deployment deployment = ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.StrategyNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(REMOTE_BROKER_NAME)).endMetadata()).withNewSpec().withReplicas(1)).withNewSelector().withMatchLabels(labels)).endSelector()).withNewTemplate().withNewMetadata().withLabels(labels)).endMetadata()).withNewSpec().withContainers(container)).withRestartPolicy("Always")).endSpec()).endTemplate()).withNewStrategy().withType("RollingUpdate")).endStrategy()).endSpec()).build();
        ((Resource)osClient.resources(Deployment.class).resource(deployment)).createOr(Updatable::update);
        Utils.persistResource(target, deployment, "artemis-broker-deployment.yaml");
        IntOrString v = new IntOrString();
        v.setValue(61616);
        Service service = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(REMOTE_BROKER_NAME)).endMetadata()).withNewSpec().withPorts(((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePort().toBuilder().withName("61616-tcp")).withProtocol("TCP")).withPort(61616)).withTargetPort(v)).build())).withType("ClusterIP")).withSessionAffinity("None")).withSelector(labels)).endSpec()).build();
        ((ServiceResource)osClient.services().resource(service)).createOr(Updatable::update);
        Utils.persistResource(target, service, "artemis-broker-service.yaml");
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.putAll(REMOTE_BROKER_APP_MAP);
        return REMOTE_BROKER_APP_MAP;
    }

    @Override
    public Map<String, String> disabledDeploy(String appHost, String appName, String matching, Map<String, String> env) {
        HashMap<String, String> ret = new HashMap<String, String>();
        String descriptionPrefix = " Replace the PREFIX with the prefix used in the MQ_SERVICE_PREFIX_MAPPING env variable";
        String descriptionServiceName = " Replace the SERVICE-NAME with the service name used in the MQ_SERVICE_PREFIX_MAPPING env variable";
        for (Map.Entry<String, String> entry : env.entrySet()) {
            String k;
            if (entry.getKey().startsWith("{PREFIX}")) {
                k = entry.getKey().replace("{PREFIX}", "PREFIX");
                ret.put(k, entry.getValue() + descriptionPrefix);
                continue;
            }
            if (entry.getKey().startsWith("{SERVICE-NAME}")) {
                k = entry.getKey().replace("{SERVICE-NAME}", "SERVICE-NAME");
                ret.put(k, entry.getValue() + descriptionServiceName);
                continue;
            }
            if (!entry.getKey().startsWith("MQ_SERVICE_PREFIX_MAPPING")) continue;
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    @Override
    public String getSupportedAddOnFamily() {
        return "messaging";
    }

    @Override
    public Set<String> getSupportedAddOns() {
        HashSet<String> ret = new HashSet<String>();
        ret.add("cloud-remote-activemq");
        return ret;
    }

    @Override
    public String getName() {
        return "artemis_jms_broker";
    }

    static {
        REMOTE_BROKER_CONNECTION_MAP.put("AMQ_USER", "admin");
        REMOTE_BROKER_CONNECTION_MAP.put("AMQ_PASSWORD", "admin");
        REMOTE_BROKER_CONNECTION_MAP.put("AMQ_DATA_DIR", "/home/jboss/data");
        REMOTE_BROKER_APP_MAP.put("MQ_SERVICE_PREFIX_MAPPING", "broker-amq7=BROKER_AMQ");
        REMOTE_BROKER_APP_MAP.put("MQ_SERVICE_PREFIX_MAPPING", "broker-amq7=BROKER_AMQ");
        REMOTE_BROKER_APP_MAP.put("BROKER_AMQ_TCP_SERVICE_HOST", REMOTE_BROKER_NAME);
        REMOTE_BROKER_APP_MAP.put("BROKER_AMQ_TCP_SERVICE_PORT", "61616");
        REMOTE_BROKER_APP_MAP.put("BROKER_AMQ_PASSWORD", "admin");
        REMOTE_BROKER_APP_MAP.put("BROKER_AMQ_USERNAME", "admin");
    }
}

