/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.deployment.openshift.api;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.HTTPGetAction;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.Updatable;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildOutputFluent;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import io.fabric8.openshift.api.model.DockerBuildStrategyFluent;
import io.fabric8.openshift.api.model.ImageLookupPolicy;
import io.fabric8.openshift.api.model.ImageSource;
import io.fabric8.openshift.api.model.ImageSourceBuilder;
import io.fabric8.openshift.api.model.ImageSourcePath;
import io.fabric8.openshift.api.model.ImageSourcePathBuilder;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.RouteTargetReference;
import io.fabric8.openshift.api.model.SourceBuildStrategyFluent;
import io.fabric8.openshift.api.model.TLSConfig;
import io.fabric8.openshift.api.model.TLSConfigBuilder;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.BuildResource;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayers;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;
import org.wildfly.glow.ConfigurationResolver;
import org.wildfly.glow.Env;
import org.wildfly.glow.GlowMessageWriter;
import org.wildfly.glow.Layer;
import org.wildfly.glow.deployment.openshift.api.Deployer;
import org.wildfly.glow.deployment.openshift.api.OpenShiftConfiguration;
import org.wildfly.glow.deployment.openshift.api.Utils;

public class OpenShiftSupport {
    private static void createAppDeployment(GlowMessageWriter writer, Path target, OpenShiftClient osClient, String name, Map<String, String> env, boolean ha) throws Exception {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("deployment", name);
        ContainerPort port = new ContainerPort();
        port.setContainerPort(8080);
        port.setName("http");
        port.setProtocol("TCP");
        ContainerPort portAdmin = new ContainerPort();
        portAdmin.setContainerPort(9990);
        portAdmin.setName("admin");
        portAdmin.setProtocol("TCP");
        ArrayList<ContainerPort> ports = new ArrayList<ContainerPort>();
        ports.add(port);
        ports.add(portAdmin);
        ArrayList<EnvVar> vars = new ArrayList<EnvVar>();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            vars.add(((EnvVarBuilder)((EnvVarBuilder)new EnvVar().toBuilder().withName(entry.getKey())).withValue(entry.getValue())).build());
        }
        if (ha) {
            writer.info("\n HA enabled, 2 replicas will be started.");
            vars.add(((EnvVarBuilder)((EnvVarBuilder)new EnvVar().toBuilder().withName("JGROUPS_PING_PROTOCOL")).withValue("DNS_PING")).build());
            vars.add(((EnvVarBuilder)((EnvVarBuilder)new EnvVar().toBuilder().withName("OPENSHIFT_DNS_PING_SERVICE_PORT")).withValue("8888")).build());
            vars.add(((EnvVarBuilder)((EnvVarBuilder)new EnvVar().toBuilder().withName("OPENSHIFT_DNS_PING_SERVICE_NAME")).withValue(name + "-ping")).build());
            IntOrString v = new IntOrString();
            v.setValue(8888);
            Service pingService = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(name + "-ping")).endMetadata()).withNewSpec().withPorts(((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePort().toBuilder().withProtocol("TCP")).withPort(8888)).withName("ping")).withTargetPort(v)).build())).withClusterIP("None")).withPublishNotReadyAddresses()).withIpFamilies("IPv4")).withInternalTrafficPolicy("Cluster")).withClusterIPs("None")).withType("ClusterIP")).withIpFamilyPolicy("SingleStack")).withSessionAffinity("None")).withSelector(labels)).endSpec()).build();
            ((ServiceResource)osClient.services().resource(pingService)).createOr(Updatable::update);
            Utils.persistResource(target, pingService, name + "-ping-service.yaml");
        }
        Container container = new Container();
        container.setName(name);
        container.setImage(name + ":latest");
        container.setPorts(ports);
        container.setEnv(vars);
        container.setImagePullPolicy("IfNotPresent");
        Probe readinessProbe = new Probe();
        HTTPGetAction getAction = new HTTPGetAction();
        getAction.setPath("/health/ready");
        IntOrString pp = new IntOrString("admin");
        getAction.setPort(pp);
        getAction.setScheme("HTTP");
        readinessProbe.setHttpGet(getAction);
        readinessProbe.setTimeoutSeconds(1);
        readinessProbe.setPeriodSeconds(10);
        readinessProbe.setSuccessThreshold(1);
        readinessProbe.setFailureThreshold(3);
        container.setReadinessProbe(readinessProbe);
        container.setTerminationMessagePath("/dev/termination-log");
        Probe livenessProbe = new Probe();
        HTTPGetAction getAction2 = new HTTPGetAction();
        getAction2.setPath("/health/live");
        IntOrString pp2 = new IntOrString("admin");
        getAction2.setPort(pp2);
        getAction2.setScheme("HTTP");
        livenessProbe.setHttpGet(getAction);
        livenessProbe.setTimeoutSeconds(1);
        livenessProbe.setPeriodSeconds(10);
        livenessProbe.setSuccessThreshold(1);
        livenessProbe.setFailureThreshold(3);
        container.setLivenessProbe(livenessProbe);
        Deployment deployment = ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.StrategyNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(name)).endMetadata()).withNewSpec().withReplicas(ha ? 2 : 1)).withNewSelector().withMatchLabels(labels)).endSelector()).withNewTemplate().withNewMetadata().withLabels(labels)).endMetadata()).withNewSpec().withContainers(container)).withRestartPolicy("Always")).endSpec()).endTemplate()).withNewStrategy().withType("RollingUpdate")).endStrategy()).endSpec()).build();
        ((Resource)osClient.resources(Deployment.class).resource(deployment)).createOr(Updatable::update);
        Utils.persistResource(target, deployment, name + "-deployment.yaml");
        IntOrString v = new IntOrString();
        v.setValue(8080);
        Service service = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(name)).endMetadata()).withNewSpec().withPorts(((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePort().toBuilder().withProtocol("TCP")).withPort(8080)).withTargetPort(v)).build())).withType("ClusterIP")).withSessionAffinity("None")).withSelector(labels)).endSpec()).build();
        ((ServiceResource)osClient.services().resource(service)).createOr(Updatable::update);
        Utils.persistResource(target, service, name + "-service.yaml");
        writer.info("\nWaiting until the application is ready ...");
        ((Resource)osClient.resources(Deployment.class).resource(deployment)).waitUntilReady(5L, TimeUnit.MINUTES);
    }

    public static ConfigurationResolver.ResolvedEnvs getResolvedEnvs(Layer layer, Set<Env> input, Set<String> disabledDeployers) throws Exception {
        ConfigurationResolver.ResolvedEnvs resolved = null;
        List<Deployer> deployers = OpenShiftSupport.getEnabledDeployers(disabledDeployers);
        for (Deployer d : deployers) {
            Set<Env> envs;
            if (!d.getSupportedLayers().contains(layer.getName()) || (envs = d.getResolvedEnvs(input)) == null || envs.isEmpty()) continue;
            resolved = new ConfigurationResolver.ResolvedEnvs("openshift/" + d.getName(), envs);
            break;
        }
        return resolved;
    }

    private static List<Deployer> getEnabledDeployers(Set<String> disabledDeployers) throws Exception {
        HashMap<String, Deployer> existingDeployers = new HashMap<String, Deployer>();
        for (Deployer d : ServiceLoader.load(Deployer.class)) {
            existingDeployers.put(d.getName(), d);
        }
        for (String disabled : disabledDeployers) {
            if ("ALL".equals(disabled) || existingDeployers.containsKey(disabled)) continue;
            throw new Exception("Invalid deployer to disable: " + disabled);
        }
        ArrayList<Deployer> deployers = new ArrayList<Deployer>();
        for (Deployer d : existingDeployers.values()) {
            boolean isDisabled = OpenShiftSupport.isDisabled(d.getName(), disabledDeployers);
            if (isDisabled) continue;
            deployers.add(d);
        }
        return deployers;
    }

    public static void deploy(GlowMessageWriter writer, Path target, String appName, Map<String, String> env, Set<Layer> layers, Set<Layer> metadataOnlyLayers, boolean ha, Map<String, String> extraEnv, Map<String, String> buildExtraEnv, Map<Layer, Set<Env>> requiredBuildTime, Set<String> disabledDeployers, Path initScript, Path cliScript, OpenShiftConfiguration config, MavenRepoManager mvnResolver) throws Exception {
        LinkedHashSet<Layer> allLayers = new LinkedHashSet<Layer>();
        allLayers.addAll(layers);
        allLayers.addAll(metadataOnlyLayers);
        TreeMap<String, String> actualEnv = new TreeMap<String, String>();
        TreeMap<String, String> actualBuildEnv = new TreeMap<String, String>();
        OpenShiftClient osClient = new KubernetesClientBuilder().build().adapt(OpenShiftClient.class);
        writer.info("\nConnected to OpenShift cluster");
        Route route = ((RouteBuilder)((RouteFluent.SpecNested)((RouteFluent.SpecNested)((RouteBuilder)((RouteFluent.MetadataNested)new RouteBuilder().withNewMetadata().withName(appName)).endMetadata()).withNewSpec().withTo(new RouteTargetReference("Service", appName, 100))).withTls(((TLSConfigBuilder)((TLSConfigBuilder)new TLSConfig().toBuilder().withTermination("edge")).withInsecureEdgeTerminationPolicy("Redirect")).build())).endSpec()).build();
        ((Resource)osClient.routes().resource(route)).createOr(Updatable::update);
        Utils.persistResource(target, route, appName + "-route.yaml");
        String host = ((Route)((Resource)osClient.routes().resource(route)).get()).getSpec().getHost();
        List<Deployer> deployers = OpenShiftSupport.getEnabledDeployers(disabledDeployers);
        block0: for (Deployer deployer : deployers) {
            boolean isDisabled = OpenShiftSupport.isDisabled(deployer.getName(), disabledDeployers);
            for (Layer l : allLayers) {
                if (!deployer.getSupportedLayers().contains(l.getName())) continue;
                if (!isDisabled) {
                    writer.info("\nFound deployer " + deployer.getName() + " for " + l.getName());
                } else {
                    writer.warn("\nThe deployer " + deployer.getName() + " has been disabled");
                }
                actualEnv.putAll(isDisabled ? Collections.emptyMap() : deployer.deploy(writer, target, osClient, env, host, appName, l.getName(), extraEnv));
                Set<Env> buildEnv = requiredBuildTime.get(l);
                if (buildEnv == null) continue block0;
                HashSet<String> names = new HashSet<String>();
                for (Env e : buildEnv) {
                    if (buildExtraEnv.containsKey(e.getName())) continue;
                    names.add(e.getName());
                }
                actualBuildEnv.putAll(deployer.handleBuildTimeDefault(names, mvnResolver));
                continue block0;
            }
        }
        actualEnv.put("APPLICATION_ROUTE_HOST", host);
        actualEnv.putAll(extraEnv);
        if (!disabledDeployers.isEmpty()) {
            writer.warn("The following environment variables will be set in the " + appName + " deployment. Make sure that the required env variables for the disabled deployer(s) have been set:\n");
        } else {
            writer.warn("The following environment variables will be set in the " + appName + " deployment:\n");
        }
        for (Map.Entry entry : actualEnv.entrySet()) {
            writer.warn((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        actualBuildEnv.putAll(buildExtraEnv);
        OpenShiftSupport.createBuild(writer, target, osClient, appName, initScript, cliScript, actualBuildEnv, config);
        writer.info("Deploying application image on OpenShift");
        OpenShiftSupport.createAppDeployment(writer, target, osClient, appName, actualEnv, ha);
        writer.info("Application route: https://" + host + (String)("ROOT.war".equals(appName) ? "" : "/" + appName));
    }

    private static void createBuild(GlowMessageWriter writer, Path target, OpenShiftClient osClient, String name, Path initScript, Path cliScript, Map<String, String> buildExtraEnv, OpenShiftConfiguration config) throws Exception {
        String serverImageName = OpenShiftSupport.doServerImageBuild(writer, target, osClient, buildExtraEnv, config);
        OpenShiftSupport.doAppImageBuild(serverImageName, writer, target, osClient, name, initScript, cliScript, config);
    }

    private static boolean packageInitScript(Path initScript, Path cliScript, Path target) throws Exception {
        if (initScript != null || cliScript != null) {
            Path extensions = target.resolve("extensions");
            Files.createDirectories(extensions, new FileAttribute[0]);
            StringBuilder initExecution = new StringBuilder();
            initExecution.append("#!/bin/bash").append("\n");
            if (initScript != null) {
                initExecution.append("echo \"Calling initialization script\"").append("\n");
                Path init = extensions.resolve("init-script.sh");
                Files.copy(initScript, init, new CopyOption[0]);
                initExecution.append("sh $JBOSS_HOME/extensions/init-script.sh").append("\n");
            }
            if (cliScript != null) {
                initExecution.append("echo \"Calling CLI script\"").append("\n");
                Path cli = extensions.resolve("cli-script.cli");
                Files.copy(cliScript, cli, new CopyOption[0]);
                initExecution.append("cat $JBOSS_HOME/extensions/cli-script.cli >> \"${CLI_SCRIPT_FILE}\"");
            }
            Path postconfigure = extensions.resolve("postconfigure.sh");
            Files.write(postconfigure, initExecution.toString().getBytes(), new OpenOption[0]);
            return true;
        }
        return false;
    }

    private static boolean isDisabled(String name, Set<String> disabledDeployers) {
        return disabledDeployers.contains("ALL") || disabledDeployers.contains(name);
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(0xFF & hash[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    private static Map<String, String> createLabels(Path target, Path provisioning, OpenShiftConfiguration osConfig) throws Exception {
        GalleonBuilder provider = new GalleonBuilder();
        Path dir = target.resolve("tmp").resolve("tmpHome");
        Files.createDirectory(dir, new FileAttribute[0]);
        StringBuilder fps = new StringBuilder();
        HashMap<String, String> labels = new HashMap<String, String>();
        try (Provisioning p = provider.newProvisioningBuilder(provisioning).setInstallationHome(dir).build();){
            GalleonProvisioningConfig config = provider.newProvisioningBuilder(provisioning).setInstallationHome(dir).build().loadProvisioningConfig(provisioning);
            GalleonConfigurationWithLayers cl = config.getDefinedConfig(new ConfigId("standalone", "standalone.xml"));
            for (String s : cl.getIncludedLayers()) {
                labels.put(osConfig.getLabelRadical() + ".layer." + s, "");
            }
            for (String s : cl.getExcludedLayers()) {
                labels.put(osConfig.getLabelRadical() + ".excluded.layer." + s, "");
            }
            for (GalleonFeaturePackConfig gfpc : config.getFeaturePackDeps()) {
                if (fps.length() != 0) {
                    fps.append("_");
                }
                String producerName = gfpc.getLocation().getProducerName();
                int i = (producerName = producerName.replaceAll("::zip", "")).indexOf(":");
                if (i > 0) {
                    producerName = producerName.substring(i + 1);
                }
                producerName = producerName.replaceAll(":", "-");
                labels.put(osConfig.getLabelRadical() + ".feature-pack." + producerName, "");
            }
        }
        return labels;
    }

    private static String doServerImageBuild(GlowMessageWriter writer, Path target, OpenShiftClient osClient, Map<String, String> buildExtraEnv, OpenShiftConfiguration config) throws Exception {
        StringBuilder contentBuilder = new StringBuilder();
        Path provisioning = target.resolve("galleon").resolve("provisioning.xml");
        contentBuilder.append(Files.readString(provisioning, Charset.forName("UTF-8")));
        for (Map.Entry<String, String> entry : buildExtraEnv.entrySet()) {
            contentBuilder.append(entry.getKey() + "=" + entry.getValue());
        }
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] encodedhash = digest.digest(contentBuilder.toString().getBytes());
        String key = OpenShiftSupport.bytesToHex(encodedhash);
        String serverImageName = config.getServerImageNameRadical() + key;
        ImageStream stream = ((ImageStreamBuilder)((ImageStreamFluent.SpecNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(serverImageName)).endMetadata()).withNewSpec().withLookupPolicy(new ImageLookupPolicy(Boolean.TRUE))).endSpec()).build();
        ImageStream existingStream = (ImageStream)((Resource)osClient.imageStreams().resource(stream)).get();
        if (existingStream == null) {
            writer.info("\nBuilding server image (this can take up to few minutes)...");
            Path file = target.resolve("tmp").resolve("openshiftServer.zip");
            if (Files.exists(file, new LinkOption[0])) {
                Files.delete(file);
            }
            Path stepOne = target.resolve("tmp").resolve("step-one");
            Files.createDirectories(stepOne, new FileAttribute[0]);
            IoUtils.copy(target.resolve("galleon"), stepOne.resolve("galleon"));
            ZipUtils.zip(stepOne, file);
            stream = ((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)stream.toBuilder().editOrNewMetadata().withLabels(OpenShiftSupport.createLabels(target, provisioning, config))).endMetadata()).build();
            ((Resource)osClient.imageStreams().resource(stream)).createOr(Updatable::update);
            Utils.persistResource(target, stream, serverImageName + "-image-stream.yaml");
            BuildConfigBuilder builder = new BuildConfigBuilder();
            ObjectReference ref = new ObjectReference();
            ref.setKind("ImageStreamTag");
            ref.setName(serverImageName + ":latest");
            ArrayList<EnvVar> vars = new ArrayList<EnvVar>();
            vars.add(((EnvVarBuilder)((EnvVarBuilder)new EnvVar().toBuilder().withName("GALLEON_USE_LOCAL_FILE")).withValue("true")).build());
            if (!buildExtraEnv.isEmpty()) {
                writer.warn("\nThe following environment variables have been set in the " + serverImageName + " buildConfig:\n");
                for (Map.Entry<String, String> entry : buildExtraEnv.entrySet()) {
                    String val = buildExtraEnv.get(entry.getKey());
                    writer.warn(entry.getKey() + "=" + entry.getValue());
                    vars.add(((EnvVarBuilder)((EnvVarBuilder)new EnvVar().toBuilder().withName(entry.getKey())).withValue(val == null ? entry.getValue() : val)).build());
                }
            }
            BuildConfig buildConfig = ((BuildConfigBuilder)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.StrategyNested)((BuildStrategyFluent.SourceStrategyNested)((BuildStrategyFluent.SourceStrategyNested)((BuildStrategyFluent.SourceStrategyNested)((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.OutputNested)((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)((BuildConfigBuilder)((BuildConfigFluent.MetadataNested)builder.withNewMetadata().withName(serverImageName + "-build")).endMetadata()).withNewSpec().withNewOutput().withNewTo().withKind("ImageStreamTag")).withName(serverImageName + ":latest")).endTo()).endOutput()).withNewStrategy().withNewSourceStrategy().withNewFrom().withKind("DockerImage")).withName(config.getBuilderImage())).endFrom()).withIncremental(true)).withEnv(vars)).endSourceStrategy()).endStrategy()).withNewSource().withType("Binary")).endSource()).endSpec()).build();
            ((BuildConfigResource)osClient.buildConfigs().resource(buildConfig)).createOr(Updatable::update);
            Utils.persistResource(target, buildConfig, serverImageName + "-build-config.yaml");
            Build build = (Build)((BuildConfigResource)osClient.buildConfigs().withName(serverImageName + "-build")).instantiateBinary().fromFile(file.toFile());
            BuildWatcher buildWatcher = new BuildWatcher(writer);
            try (Watch watcher = ((BuildResource)osClient.builds().withName(build.getMetadata().getName())).watch(buildWatcher);){
                buildWatcher.await();
            }
            if (buildWatcher.isFailed()) {
                ((Resource)osClient.imageStreams().resource(stream)).delete();
                throw new Exception("Server image build has failed. Check the OpenShift build log.");
            }
        }
        return serverImageName;
    }

    private static void doAppImageBuild(String serverImageName, GlowMessageWriter writer, Path target, OpenShiftClient osClient, String name, Path initScript, Path cliScript, OpenShiftConfiguration config) throws Exception {
        Path stepTwo = target.resolve("tmp").resolve("step-two");
        IoUtils.copy(target.resolve("deployments"), stepTwo.resolve("deployments"));
        StringBuilder dockerFileBuilder = new StringBuilder();
        dockerFileBuilder.append("FROM " + config.getRuntimeImage() + "\n");
        dockerFileBuilder.append("COPY --chown=jboss:root /server $JBOSS_HOME\n");
        dockerFileBuilder.append("COPY --chown=jboss:root deployments/* $JBOSS_HOME/standalone/deployments\n");
        if (OpenShiftSupport.packageInitScript(initScript, cliScript, stepTwo)) {
            dockerFileBuilder.append("COPY --chown=jboss:root extensions $JBOSS_HOME/extensions\n");
            dockerFileBuilder.append("RUN chmod ug+rwx $JBOSS_HOME/extensions/postconfigure.sh\n");
        }
        dockerFileBuilder.append("RUN chmod -R ug+rwX $JBOSS_HOME\n");
        Path dockerFile = stepTwo.resolve("Dockerfile");
        Files.write(dockerFile, dockerFileBuilder.toString().getBytes(), new OpenOption[0]);
        Path file2 = target.resolve("tmp").resolve("openshiftApp.zip");
        if (Files.exists(file2, new LinkOption[0])) {
            Files.delete(file2);
        }
        ZipUtils.zip(stepTwo, file2);
        writer.info("\nBuilding application image...");
        ImageStream appStream = ((ImageStreamBuilder)((ImageStreamFluent.SpecNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(name)).endMetadata()).withNewSpec().withLookupPolicy(new ImageLookupPolicy(Boolean.TRUE))).endSpec()).build();
        ((Resource)osClient.imageStreams().resource(appStream)).createOr(Updatable::update);
        BuildConfigBuilder builder = new BuildConfigBuilder();
        ObjectReference ref = new ObjectReference();
        ref.setKind("ImageStreamTag");
        ref.setName(serverImageName + ":latest");
        ImageSourcePath srcPath = ((ImageSourcePathBuilder)((ImageSourcePathBuilder)new ImageSourcePathBuilder().withSourcePath("/opt/server")).withDestinationDir(".")).build();
        ImageSource imageSource = ((ImageSourceBuilder)((ImageSourceBuilder)new ImageSourceBuilder().withFrom(ref)).withPaths(srcPath)).build();
        BuildConfig buildConfig2 = ((BuildConfigBuilder)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.StrategyNested)((BuildStrategyFluent.DockerStrategyNested)((BuildStrategyFluent.DockerStrategyNested)((DockerBuildStrategyFluent.FromNested)((DockerBuildStrategyFluent.FromNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BuildConfigSpecFluent.SourceNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.OutputNested)((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)((BuildConfigBuilder)((BuildConfigFluent.MetadataNested)builder.withNewMetadata().withName(name + "-build")).endMetadata()).withNewSpec().withNewOutput().withNewTo().withKind("ImageStreamTag")).withName(name + ":latest")).endTo()).endOutput()).withNewSource().withType("Binary")).withImages(imageSource)).endSource()).withNewStrategy().withNewDockerStrategy().withNewFrom().withKind("DockerImage")).withName("quay.io/wildfly/wildfly-runtime:latest")).endFrom()).withDockerfilePath("./Dockerfile")).endDockerStrategy()).endStrategy()).endSpec()).build();
        ((BuildConfigResource)osClient.buildConfigs().resource(buildConfig2)).createOr(Updatable::update);
        Utils.persistResource(target, buildConfig2, name + "-build-config.yaml");
        Build build = (Build)((BuildConfigResource)osClient.buildConfigs().withName(name + "-build")).instantiateBinary().fromFile(file2.toFile());
        CountDownLatch latch = new CountDownLatch(1);
        BuildWatcher buildWatcher = new BuildWatcher(writer);
        try (Watch watcher = ((BuildResource)osClient.builds().withName(build.getMetadata().getName())).watch(buildWatcher);){
            buildWatcher.await();
        }
        if (buildWatcher.isFailed()) {
            ((Resource)osClient.imageStreams().resource(appStream)).delete();
            throw new Exception("Application image build has failed. Check the OpenShift build log.");
        }
    }

    private static class BuildWatcher
    implements Watcher<Build>,
    AutoCloseable {
        private final CountDownLatch latch = new CountDownLatch(1);
        private final GlowMessageWriter writer;
        private boolean failed;

        BuildWatcher(GlowMessageWriter writer) {
            this.writer = writer;
        }

        @Override
        public void eventReceived(Watcher.Action action, Build build) {
            String phase = build.getStatus().getPhase();
            if ("Running".equals(phase)) {
                this.writer.info("Build is running...");
            }
            if ("Complete".equals(phase)) {
                this.writer.info("Build is complete.");
                this.latch.countDown();
            }
            if ("Failed".equals(phase)) {
                this.writer.info("Build Failed.");
                this.failed = true;
                this.latch.countDown();
            }
        }

        @Override
        public void onClose(WatcherException cause) {
        }

        void await() throws InterruptedException {
            this.latch.await();
        }

        boolean isFailed() {
            return this.failed;
        }

        @Override
        public void close() throws Exception {
        }
    }
}

