/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.cli.commands;

import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.as.version.Stability;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;
import org.wildfly.channel.ChannelSession;
import org.wildfly.glow.Arguments;
import org.wildfly.glow.ConfigurationResolver;
import org.wildfly.glow.Env;
import org.wildfly.glow.GlowMessageWriter;
import org.wildfly.glow.GlowSession;
import org.wildfly.glow.HiddenPropertiesAccessor;
import org.wildfly.glow.Layer;
import org.wildfly.glow.OutputContent;
import org.wildfly.glow.OutputFormat;
import org.wildfly.glow.ScanArguments;
import org.wildfly.glow.ScanResults;
import org.wildfly.glow.cli.commands.AbstractCommand;
import org.wildfly.glow.deployment.openshift.api.OpenShiftConfiguration;
import org.wildfly.glow.deployment.openshift.api.OpenShiftSupport;
import org.wildfly.glow.error.IdentifiedError;
import org.wildfly.glow.maven.ChannelMavenArtifactRepositoryManager;
import org.wildfly.glow.maven.MavenResolver;
import picocli.CommandLine;

@CommandLine.Command(name="scan", sortOptions=true)
public class ScanCommand
extends AbstractCommand {
    private static final String ADD_ADD_ONS_MSG = "@|bold To enable add-ons, add the|@ @|fg(yellow) --add-ons=<list of add-ons>|@ @|bold option to the|@ @|fg(yellow) scan|@ @|bold command|@";
    @CommandLine.Option(names={"-c", "--cloud"})
    Optional<Boolean> cloud;
    @CommandLine.Option(names={"-wp", "--wildfly-preview"})
    Optional<Boolean> wildflyPreview;
    @CommandLine.Option(names={"-s", "--suggest"})
    Optional<Boolean> suggest;
    @CommandLine.Option(names={"--ha"})
    Optional<Boolean> haProfile;
    @CommandLine.Option(names={"-sv", "--server-version"}, paramLabel="<server version>")
    Optional<String> wildflyServerVersion;
    @CommandLine.Option(names={"-di", "--docker-image-name"}, paramLabel="<docker image name>")
    Optional<String> dockerImageName;
    @CommandLine.Option(names={"--add-layers-for-jndi"}, split=",", paramLabel="<layer>")
    Set<String> layersForJndi = new LinkedHashSet<String>();
    @CommandLine.Option(names={"-ao", "--add-ons"}, split=",", paramLabel="<add-on>")
    Set<String> addOns = new LinkedHashSet<String>();
    @CommandLine.Parameters(descriptionKey="deployments")
    List<Path> deployments;
    @CommandLine.Option(names={"--input-feature-packs-file"}, paramLabel="<provisioning file path>")
    Optional<Path> provisioningXml;
    @CommandLine.Option(converter={ProvisionConverter.class}, names={"-p", "--provision"}, paramLabel="<SERVER|BOOTABLE_JAR|OPENSHIFT|DOCKER_IMAGE|PROVISIONING_XML>")
    Optional<OutputFormat> provision;
    @CommandLine.Option(names={"-d", "--output-dir"}, paramLabel="<output directory>")
    Optional<String> provisionOutputDir;
    @CommandLine.Option(names={"-ea", "--exclude-archives-from-scan"}, split=",", paramLabel="<list of nested archive names>")
    Set<String> excludeArchivesFromScan = new HashSet<String>();
    @CommandLine.Option(converter={StabilityConverter.class}, names={"--stability-level", "-sl"}, paramLabel="<default|community|preview|experimental>")
    Optional<Stability> stability;
    @CommandLine.Option(converter={StabilityConverter.class}, names={"--package-stability-level", "-psl"}, paramLabel="<default|community|preview|experimental>")
    Optional<Stability> packageStability;
    @CommandLine.Option(converter={StabilityConverter.class}, names={"--config-stability-level", "-csl"}, paramLabel="<default|community|preview|experimental>")
    Optional<Stability> configStability;
    @CommandLine.Option(names={"-ef", "--env-file"}, paramLabel="<env file path>")
    Optional<Path> envFile;
    @CommandLine.Option(names={"-bef", "--build-env-file"}, paramLabel="<build env file path>")
    Optional<Path> buildEnvFile;
    @CommandLine.Option(names={"-is", "--init-script"}, paramLabel="<init script file path>")
    Optional<Path> initScriptFile;
    @CommandLine.Option(names={"-cs", "--cli-script"}, paramLabel="<CLI script file path>")
    Optional<Path> cliScriptFile;
    @CommandLine.Option(names={"--disable-deployers"}, split=",", paramLabel="<add-on>")
    Set<String> disableDeployers = new LinkedHashSet<String>();
    @CommandLine.Option(names={"-pp", "--properties"}, split=" ", paramLabel="\"<-DpropName[=value] [-DpropName[=value]]>\"")
    Set<String> systemProperties = new HashSet<String>();
    @CommandLine.Option(names={"-foe", "--fails-on-error"}, defaultValue="true")
    Optional<Boolean> failsOnError;
    @CommandLine.Option(names={"-cc", "--channels"}, paramLabel="<Channels yaml file path>")
    Optional<Path> channelsFile;

    @Override
    public Integer call() throws Exception {
        Path p;
        HiddenPropertiesAccessor hiddenPropertiesAccessor;
        boolean compact;
        if (!this.systemProperties.isEmpty()) {
            for (String p2 : this.systemProperties) {
                if (p2.startsWith("-D")) {
                    String propName;
                    int i = p2.indexOf("=");
                    String value = "";
                    if (i > 0) {
                        propName = p2.substring(2, i);
                        value = p2.substring(i + 1);
                    } else {
                        propName = p2.substring(2);
                    }
                    System.setProperty(propName, value);
                    continue;
                }
                throw new Exception("Invalid system property " + p2 + ". A property must start with -D");
            }
        }
        if (!(compact = Boolean.parseBoolean((hiddenPropertiesAccessor = new HiddenPropertiesAccessor()).getProperty("compact")))) {
            this.print("Wildfly Glow is scanning...");
        }
        ScanArguments.Builder builder = Arguments.scanBuilder();
        if (this.haProfile.orElse(false).booleanValue()) {
            HashSet<String> profiles = new HashSet<String>();
            profiles.add("ha");
            builder.setExecutionProfiles(profiles);
        }
        if (!this.layersForJndi.isEmpty()) {
            builder.setJndiLayers(this.layersForJndi);
        }
        if (this.suggest.orElse(false).booleanValue()) {
            builder.setSuggest(true);
        }
        if (this.wildflyPreview.orElse(false).booleanValue()) {
            if (this.channelsFile.isPresent()) {
                throw new Exception("--wildfly-previewcan't be set when --channels is set.");
            }
            builder.setTechPreview(true);
        }
        if (this.wildflyServerVersion.isPresent()) {
            if (this.channelsFile.isPresent()) {
                throw new Exception("--server-versioncan't be set when --channels is set.");
            }
            builder.setVersion(this.wildflyServerVersion.get());
        }
        HashMap<String, String> extraEnv = new HashMap<String, String>();
        HashMap<String, String> buildExtraEnv = new HashMap<String, String>();
        if (this.envFile.isPresent()) {
            if (this.provision.isPresent()) {
                if (!OutputFormat.OPENSHIFT.equals((Object)this.provision.get())) {
                    throw new Exception("Env file is only usable when --provision=" + OutputFormat.OPENSHIFT + " option is set.");
                }
            } else {
                throw new Exception("Env file is only usable when --provision=" + OutputFormat.OPENSHIFT + " option is set.");
            }
            extraEnv.putAll(this.handleOpenShiftEnvFile(this.envFile.get()));
        }
        if (this.buildEnvFile.isPresent()) {
            if (this.provision.isPresent()) {
                if (!OutputFormat.OPENSHIFT.equals((Object)this.provision.get())) {
                    throw new Exception("Build env file is only usable when --provision=" + OutputFormat.OPENSHIFT + " option is set.");
                }
            } else {
                throw new Exception("Build env file is only usable when --provision=" + OutputFormat.OPENSHIFT + " option is set.");
            }
            buildExtraEnv.putAll(this.handleOpenShiftEnvFile(this.buildEnvFile.get()));
        }
        if (this.cliScriptFile.isPresent()) {
            if (this.provision.isPresent()) {
                if (!OutputFormat.OPENSHIFT.equals((Object)this.provision.get())) {
                    throw new Exception("CLI script file is only usable when --provision=" + OutputFormat.OPENSHIFT + " option is set.");
                }
            } else {
                throw new Exception("CLI script file file is only usable when --provision=" + OutputFormat.OPENSHIFT + " option is set.");
            }
            p = this.cliScriptFile.get();
            if (!Files.exists(p, new LinkOption[0])) {
                throw new Exception(p + " file doesn't exist");
            }
        }
        if (this.initScriptFile.isPresent()) {
            if (this.provision.isPresent()) {
                if (!OutputFormat.OPENSHIFT.equals((Object)this.provision.get())) {
                    throw new Exception("Init script file is only usable when --provision=" + OutputFormat.OPENSHIFT + " option is set.");
                }
            } else {
                throw new Exception("Init script file file is only usable when --provision=" + OutputFormat.OPENSHIFT + " option is set.");
            }
            p = this.initScriptFile.get();
            if (!Files.exists(p, new LinkOption[0])) {
                throw new Exception(p + " file doesn't exist");
            }
        }
        builder.setVerbose(this.verbose);
        if (!this.addOns.isEmpty()) {
            builder.setUserEnabledAddOns(this.addOns);
        }
        if (this.deployments != null && !this.deployments.isEmpty()) {
            builder.setBinaries(this.deployments);
        }
        if (this.provisioningXml.isPresent()) {
            builder.setProvisoningXML(this.provisioningXml.get());
        }
        ChannelMavenArtifactRepositoryManager repoManager = null;
        if (this.channelsFile.isPresent()) {
            Path channelsFilePath = this.channelsFile.get();
            if (!Files.exists(channelsFilePath, new LinkOption[0])) {
                throw new Exception(channelsFilePath + " file doesn't exist");
            }
            ChannelSession session = MavenResolver.buildChannelSession(channelsFilePath);
            builder.setChannelSession(session);
            repoManager = new ChannelMavenArtifactRepositoryManager(session);
        }
        if (this.provision.isPresent()) {
            if (OutputFormat.BOOTABLE_JAR.equals((Object)this.provision.get()) && this.cloud.orElse(false).booleanValue()) {
                throw new Exception("Can't produce a Bootable JAR for cloud. Use the --provision=SERVER option for cloud.");
            }
            if (OutputFormat.DOCKER_IMAGE.equals((Object)this.provision.get()) && !this.cloud.orElse(false).booleanValue()) {
                this.cloud = Optional.of(Boolean.TRUE);
            }
            if (OutputFormat.OPENSHIFT.equals((Object)this.provision.get()) && !this.cloud.orElse(false).booleanValue()) {
                this.cloud = Optional.of(Boolean.TRUE);
            }
            builder.setOutput(this.provision.get());
        }
        if (this.cloud.orElse(false).booleanValue()) {
            builder.setExecutionContext("cloud");
        }
        builder.setExcludeArchivesFromScan(this.excludeArchivesFromScan);
        if (this.stability.isPresent()) {
            if (this.configStability.isPresent()) {
                throw new Exception("--config-stability-level can't be set when --stability-level is set");
            }
            if (this.packageStability.isPresent()) {
                throw new Exception("--package-stability-level can't be set when --stability-level is set");
            }
            builder.setConfigStability(this.stability.get());
            builder.setPackageStability(this.stability.get());
        }
        if (this.configStability.isPresent()) {
            builder.setConfigStability(this.configStability.get());
        }
        if (this.packageStability.isPresent()) {
            builder.setPackageStability(this.packageStability.get());
        }
        if (this.dockerImageName.isPresent() && this.provision.isPresent() && !OutputFormat.DOCKER_IMAGE.equals((Object)this.provision.get())) {
            throw new Exception("Can only set a docker image name when provisioning a docker image. Remove the --docker-image-name option");
        }
        builder.setIsCli(true);
        MavenRepoManager directMavenResolver = MavenResolver.newMavenResolver();
        ScanResults scanResults = GlowSession.scan(repoManager == null ? directMavenResolver : repoManager, builder.build(), GlowMessageWriter.DEFAULT);
        ConfigurationResolver configurationResolver = new ConfigurationResolver(){

            @Override
            public ConfigurationResolver.ResolvedEnvs getResolvedEnvs(Layer layer, Set<Env> input) throws Exception {
                if (ScanCommand.this.provision.get().equals((Object)OutputFormat.OPENSHIFT)) {
                    return OpenShiftSupport.getResolvedEnvs(layer, input, ScanCommand.this.disableDeployers);
                }
                return null;
            }
        };
        scanResults.outputInformation(configurationResolver);
        if (this.provision.isEmpty()) {
            if (!compact) {
                if (this.suggest.orElse(false).booleanValue()) {
                    if (!scanResults.getSuggestions().getPossibleAddOns().isEmpty() && this.addOns.isEmpty()) {
                        this.print(ADD_ADD_ONS_MSG);
                    }
                    if (!scanResults.getSuggestions().getPossibleProfiles().isEmpty()) {
                        this.print("@|bold To enable the HA profile, add the|@ @|fg(yellow) %s|@ @|bold option to the|@ @|fg(yellow) %s|@ @|bold command|@", "--ha", "scan");
                    }
                }
                if (scanResults.getErrorSession().hasErrors()) {
                    if (!this.suggest.orElse(false).booleanValue()) {
                        boolean hasAddOn = false;
                        for (IdentifiedError err : scanResults.getErrorSession().getErrors()) {
                            if (err.getPossibleAddons().isEmpty()) continue;
                            hasAddOn = true;
                            break;
                        }
                        if (hasAddOn) {
                            System.out.println(CommandLine.Help.Ansi.AUTO.string(ADD_ADD_ONS_MSG));
                        }
                    }
                    this.print("@|bold Some errors have been reported. You should fix them prior provisioning a server with the|@ @|fg(yellow) --provision|@ @|bold option of the|@ @|fg(yellow) scan|@ @|bold command|@");
                } else {
                    this.print("@|bold If you had included a|@ @|fg(yellow) --provision=<SERVER|BOOTABLE_JAR|OPENSHIFT|DOCKER_IMAGE|PROVISIONING_XML>|@ @|bold option to the|@ @|fg(yellow) scan|@ @|bold command, after outputting this report, WildFly Glow will continue on to provisioning your WildFly server, bootable jar, a Docker image or deploy your application to OpenShift.|@");
                }
            }
        } else {
            this.print();
            if (this.failsOnError.orElse(false).booleanValue() && scanResults.getErrorSession().hasErrors()) {
                throw new Exception("Your are provisioning although errors have been reported. If you want to enforce provisioning, set --fails-on-error=false to ignore errors.");
            }
            FeaturePackLocation.ProducerSpec baseProducer = scanResults.getProvisioningConfig().getFeaturePackDeps().iterator().next().getLocation().getProducer();
            String vers = scanResults.getFeaturePackVersions().get(baseProducer).getBuild();
            Path target = Paths.get(this.provisionOutputDir.orElse("server-" + vers), new String[0]);
            IoUtils.recursiveDelete(target);
            switch (this.provision.get()) {
                case BOOTABLE_JAR: {
                    if (this.provisionOutputDir.isEmpty()) {
                        target = Paths.get("", new String[0]);
                    }
                    this.print("@|bold Building WildFly Bootable JAR file...|@");
                    break;
                }
                case PROVISIONING_XML: {
                    this.print("@|bold Generating Galleon provisioning configuration file...|@");
                    break;
                }
                case SERVER: {
                    this.print("@|bold Provisioning server...|@", target);
                    break;
                }
                case DOCKER_IMAGE: {
                    this.print("@|bold Generating docker image...|@");
                    break;
                }
                case OPENSHIFT: {
                    this.print("@|bold Openshift build and deploy...|@");
                }
            }
            OutputContent content = scanResults.outputConfig(target, this.dockerImageName.orElse(null));
            Path base = Paths.get("", new String[0]).toAbsolutePath();
            String envMessage = null;
            String completedMessage = null;
            for (OutputContent.OutputFile f : content.getFiles().keySet()) {
                Path rel = base.relativize(content.getFiles().get((Object)f));
                block7 : switch (f) {
                    case BOOTABLE_JAR_FILE: {
                        completedMessage = "@|bold To run the jar call: 'java -jar " + (Path)rel + "'|@";
                        break;
                    }
                    case DOCKER_FILE: {
                        this.print("@|bold Docker file generated in %s|@.", rel);
                        break;
                    }
                    case ENV_FILE: {
                        switch (this.provision.get()) {
                            case SERVER: {
                                envMessage = "WARNING: You have to export the suggested env variables prior to start the server.";
                                break block7;
                            }
                            case BOOTABLE_JAR: {
                                envMessage = "WARNING: You have to export the suggested env variables prior to start the bootable JAR.";
                                break block7;
                            }
                            case DOCKER_IMAGE: {
                                envMessage = "WARNING: For each suggested env variable add `-e <env name>=<env value>` to the `[docker | podman] run` command.";
                            }
                        }
                        break;
                    }
                    case PROVISIONING_XML_FILE: {
                        switch (this.provision.get()) {
                            case PROVISIONING_XML: {
                                this.print("@|bold Galleon Provisioning configuration is located in " + (Path)rel + " file|@");
                            }
                        }
                        break;
                    }
                    case SERVER_DIR: {
                        completedMessage = this.cloud.orElse(false) != false ? "@|bold To run the server call: 'JBOSS_HOME=" + (Path)rel + " sh " + (Path)rel + "/bin/openshift-launch.sh'|@" : "@|bold To run the server call: 'sh " + (Path)rel + "/bin/standalone.sh'|@";
                    }
                }
            }
            if (OutputFormat.OPENSHIFT.equals((Object)this.provision.get())) {
                Object name = "";
                Path deploymentsDir = target.resolve("deployments");
                Files.createDirectories(deploymentsDir, new FileAttribute[0]);
                for (Path p3 : this.deployments) {
                    Files.copy(p3, deploymentsDir.resolve(p3.getFileName()), new CopyOption[0]);
                    int ext = p3.getFileName().toString().indexOf(".");
                    name = (String)name + p3.getFileName().toString().substring(0, ext);
                }
                HashMap<String, String> envMap = new HashMap<String, String>();
                for (Set<Env> envs : scanResults.getSuggestions().getStronglySuggestedConfigurations().values()) {
                    for (Env env : envs) {
                        envMap.put(env.getName(), env.getDescription());
                    }
                }
                OpenShiftSupport.deploy(GlowMessageWriter.DEFAULT, target, ((String)name).isEmpty() ? "app-from-glow" : ((String)name).toLowerCase(), envMap, scanResults.getDiscoveredLayers(), scanResults.getMetadataOnlyLayers(), this.haProfile.orElse(false), extraEnv, buildExtraEnv, scanResults.getSuggestions().getBuildTimeRequiredConfigurations(), this.disableDeployers, this.initScriptFile.orElse(null), this.cliScriptFile.orElse(null), new OpenShiftConfiguration.Builder().build(), directMavenResolver);
                this.print("@|bold \nOpenshift build and deploy DONE.|@");
            } else if (content.getDockerImageName() != null) {
                this.print("@|bold To run the image call: '[docker | podman] run -p 8080:8080 -p 9990:9990 " + content.getDockerImageName() + "'|@");
                if (envMessage != null) {
                    GlowMessageWriter.DEFAULT.warn(envMessage);
                }
            } else if (completedMessage != null) {
                this.print(completedMessage);
                if (envMessage != null) {
                    GlowMessageWriter.DEFAULT.warn(envMessage);
                }
            }
        }
        return 0;
    }

    private Map<String, String> handleOpenShiftEnvFile(Path envFile) throws Exception {
        HashMap<String, String> extraEnv = new HashMap<String, String>();
        if (!Files.exists(envFile, new LinkOption[0])) {
            throw new Exception(envFile + " file doesn't exist");
        }
        for (String l : Files.readAllLines(envFile)) {
            if ((l = l.trim()).isEmpty() || l.startsWith("#")) continue;
            int i = l.indexOf("=");
            if (i < 0 || i == l.length() - 1) {
                throw new Exception("Invalid environment variable " + l + " in " + envFile);
            }
            extraEnv.put(l.substring(0, i), l.substring(i + 1));
        }
        return extraEnv;
    }

    private static class ProvisionConverter
    implements CommandLine.ITypeConverter<OutputFormat> {
        private ProvisionConverter() {
        }

        @Override
        public OutputFormat convert(String value) throws Exception {
            return OutputFormat.valueOf(value.toUpperCase());
        }
    }

    private static class StabilityConverter
    implements CommandLine.ITypeConverter<Stability> {
        private StabilityConverter() {
        }

        @Override
        public Stability convert(String value) throws Exception {
            return Stability.fromString(value);
        }
    }
}

