/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.cli;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;
import org.wildfly.glow.FeaturePacks;
import org.wildfly.glow.GlowMessageWriter;
import org.wildfly.glow.GlowSession;
import org.wildfly.glow.Layer;
import org.wildfly.glow.LayerMapping;
import org.wildfly.glow.ScanResults;
import org.wildfly.glow.Utils;
import org.wildfly.glow.Version;
import org.wildfly.glow.cli.CLIArguments;
import org.wildfly.glow.cli.ExecutionExceptionHandler;
import org.wildfly.glow.cli.commands.CompletionCommand;
import org.wildfly.glow.cli.commands.GoOfflineCommand;
import org.wildfly.glow.cli.commands.MainCommand;
import org.wildfly.glow.cli.commands.ScanCommand;
import org.wildfly.glow.cli.commands.ShowAddOnsCommand;
import org.wildfly.glow.cli.commands.ShowConfigurationCommand;
import org.wildfly.glow.cli.commands.ShowServerVersionsCommand;
import org.wildfly.glow.maven.MavenResolver;
import picocli.CommandLine;

public class GlowCLI {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        boolean dumpInfos;
        MainCommand command = new MainCommand();
        try {
            CommandLine commandLine = new CommandLine(command);
            commandLine.addSubcommand(new ScanCommand());
            commandLine.addSubcommand(new ShowAddOnsCommand());
            commandLine.addSubcommand(new ShowServerVersionsCommand());
            commandLine.addSubcommand(new ShowConfigurationCommand());
            commandLine.addSubcommand(new GoOfflineCommand());
            commandLine.addSubcommand(new CompletionCommand());
            commandLine.setUsageHelpAutoWidth(true);
            boolean isVerbose = Arrays.stream(args).anyMatch(s -> s.equals("-vv") || s.equals("--verbose"));
            commandLine.setExecutionExceptionHandler(new ExecutionExceptionHandler(isVerbose, command));
            int exitCode = commandLine.execute(args);
            System.exit(exitCode);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
        CLIArguments arguments = CLIArguments.fromMainArguments(args);
        if (arguments.isVersion()) {
            command.print(Version.getVersion());
            return;
        }
        boolean bl = dumpInfos = args.length == 0 || arguments.isHelp();
        if (dumpInfos || arguments.isDisplayConfigurationInfo()) {
            MavenRepoManager resolver = MavenResolver.newMavenResolver();
            UniverseResolver universeResolver = ((UniverseResolver.Builder)UniverseResolver.builder().addArtifactResolver(resolver)).build();
            GalleonBuilder provider = new GalleonBuilder();
            provider.addArtifactResolver(resolver);
            Provisioning provisioning = null;
            try {
                GalleonProvisioningConfig config = Utils.buildOfflineProvisioningConfig(provider, GlowMessageWriter.DEFAULT);
                if (config == null) {
                    Path provisioningXML = FeaturePacks.getFeaturePacks(arguments.getVersion(), arguments.getExecutionContext(), arguments.isTechPreview());
                    provisioning = provider.newProvisioningBuilder(provisioningXML).build();
                    config = provisioning.loadProvisioningConfig(provisioningXML);
                } else {
                    provisioning = provider.newProvisioningBuilder(config).build();
                }
                Map<String, Layer> all = Utils.getAllLayers(config, universeResolver, provisioning, new HashMap<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>>());
                Set<String> profiles = Utils.getAllProfiles(all);
                LayerMapping mapping = Utils.buildMapping(all, Collections.emptySet());
                if (dumpInfos) {
                    CLIArguments.dumpInfos(profiles);
                } else {
                    boolean isLatest = arguments.getVersion() == null;
                    String serverVersion = isLatest ? FeaturePacks.getLatestVersion() : arguments.getVersion();
                    CLIArguments.dumpConfiguration(null, arguments.getExecutionContext(), serverVersion, all, mapping, config, isLatest, arguments.isTechPreview());
                }
            }
            finally {
                IoUtils.recursiveDelete(GlowSession.OFFLINE_CONTENT);
                if (provisioning != null) {
                    provisioning.close();
                }
            }
            return;
        }
        if (arguments.isGoOffline()) {
            GlowSession.goOffline(MavenResolver.newMavenResolver(), arguments, GlowMessageWriter.DEFAULT);
        } else {
            try (ScanResults scanResults = GlowSession.scan(MavenResolver.newMavenResolver(), arguments, GlowMessageWriter.DEFAULT);){
                if (arguments.getOutput() == null) {
                    scanResults.outputInformation();
                } else {
                    scanResults.outputConfig(Paths.get("server", new String[0]), null);
                }
            }
        }
    }
}

