/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.lang.reflect.Array;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public class JandexReflection {
    public static Class<?> loadRawType(Type type) {
        if (type == null) {
            return null;
        }
        switch (type.kind()) {
            case VOID: {
                return Void.TYPE;
            }
            case PRIMITIVE: {
                switch (type.asPrimitiveType().primitive()) {
                    case BOOLEAN: {
                        return Boolean.TYPE;
                    }
                    case BYTE: {
                        return Byte.TYPE;
                    }
                    case SHORT: {
                        return Short.TYPE;
                    }
                    case INT: {
                        return Integer.TYPE;
                    }
                    case LONG: {
                        return Long.TYPE;
                    }
                    case FLOAT: {
                        return Float.TYPE;
                    }
                    case DOUBLE: {
                        return Double.TYPE;
                    }
                    case CHAR: {
                        return Character.TYPE;
                    }
                }
                throw new IllegalArgumentException("Unknown primitive type: " + type);
            }
            case CLASS: {
                return JandexReflection.load(type.asClassType().name());
            }
            case PARAMETERIZED_TYPE: {
                return JandexReflection.load(type.asParameterizedType().name());
            }
            case ARRAY: {
                Class<?> component = JandexReflection.loadRawType(type.asArrayType().component());
                int dimensions = type.asArrayType().dimensions();
                return Array.newInstance(component, new int[dimensions]).getClass();
            }
            case WILDCARD_TYPE: {
                return JandexReflection.loadRawType(type.asWildcardType().extendsBound());
            }
            case TYPE_VARIABLE: {
                return JandexReflection.load(type.asTypeVariable().name());
            }
            case TYPE_VARIABLE_REFERENCE: {
                return JandexReflection.load(type.asTypeVariableReference().name());
            }
            case UNRESOLVED_TYPE_VARIABLE: {
                return Object.class;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    public static Class<?> loadClass(ClassInfo clazz) {
        if (clazz == null) {
            return null;
        }
        return JandexReflection.load(clazz.name());
    }

    private static Class<?> load(DotName name) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = JandexReflection.class.getClassLoader();
            }
            return cl.loadClass(name.toString());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

