/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools;

import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.wildfly.plugin.tools.DeploymentException;

public class DeploymentResult {
    static final DeploymentResult SUCCESSFUL = new DeploymentResult();
    private final boolean successful;
    private final String failureMessage;
    private final ModelNode result;

    private DeploymentResult() {
        this.successful = true;
        this.failureMessage = null;
        this.result = new ModelNode();
        this.result.protect();
    }

    DeploymentResult(ModelNode result) {
        this.successful = Operations.isSuccessfulOutcome(result);
        this.failureMessage = this.successful ? null : Operations.getFailureDescription(result).asString();
        this.result = result.clone();
        this.result.protect();
    }

    DeploymentResult(CharSequence failureMessage) {
        this.successful = false;
        this.failureMessage = failureMessage.toString();
        this.result = new ModelNode();
        this.result.protect();
    }

    DeploymentResult(String format, Object ... args) {
        this(String.format(format, args));
    }

    public boolean successful() {
        return this.successful;
    }

    public void assertSuccess() throws DeploymentException {
        if (!this.successful) {
            throw new DeploymentException(this.failureMessage);
        }
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public ModelNode asModelNode() {
        return this.result;
    }
}

