/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools;

import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;

public class OperationExecutionException
extends RuntimeException {
    private final ModelNode result;

    public OperationExecutionException(Operation operation, ModelNode result) {
        this(null, operation, result);
    }

    public OperationExecutionException(ModelNode operation, ModelNode result) {
        this(null, operation, result);
    }

    public OperationExecutionException(String message, Operation operation, ModelNode result) {
        this(message, operation.getOperation(), result);
    }

    public OperationExecutionException(String message, ModelNode operation, ModelNode result) {
        super(OperationExecutionException.formatMessage(message, operation, result));
        this.result = result;
        this.result.protect();
    }

    public ModelNode getExecutionResult() {
        return this.result;
    }

    private static String formatMessage(String message, ModelNode operation, ModelNode result) {
        if (message == null) {
            return String.format("Failed to execute %s%nReason:%s", operation, Operations.getFailureDescription(result).asString());
        }
        Object msg = message.endsWith(".") ? message : message + ".";
        return String.format("%s Failed to execute %s%nReason:%s", msg, operation, Operations.getFailureDescription(result).asString());
    }
}

