/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools;

import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.ConfigurationId;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.GalleonFeaturePack;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayersBuilder;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;

public class GalleonUtils {
    private static final String WILDFLY_DEFAULT_FEATURE_PACK_LOCATION = "wildfly@maven(org.jboss.universe:community-universe)";

    public static void provision(Path jbossHome, String featurePackLocation, String version, MavenRepoManager artifactResolver) throws ProvisioningException {
        GalleonProvisioningConfig config = GalleonUtils.buildDefaultConfig(featurePackLocation, version);
        try (Provisioning pm = ((GalleonBuilder)new GalleonBuilder().addArtifactResolver(artifactResolver)).newProvisioningBuilder(config).setInstallationHome(jbossHome).build();){
            pm.provision(config);
        }
    }

    public static GalleonProvisioningConfig buildDefaultConfig() throws ProvisioningException {
        return GalleonUtils.buildDefaultConfig(WILDFLY_DEFAULT_FEATURE_PACK_LOCATION, null);
    }

    public static GalleonProvisioningConfig buildDefaultConfig(String featurePackLocation, String version) throws ProvisioningException {
        String location = GalleonUtils.getFeaturePackLocation(featurePackLocation, version);
        GalleonProvisioningConfig.Builder state = GalleonProvisioningConfig.builder();
        GalleonFeaturePackConfig.Builder fp = GalleonFeaturePackConfig.builder(FeaturePackLocation.fromString(location));
        fp.setInheritConfigs(true);
        fp.setInheritPackages(true);
        state.addFeaturePackDep(fp.build());
        state.addOptions(Map.of("jboss-fork-embedded", "true"));
        return state.build();
    }

    public static GalleonProvisioningConfig buildConfig(GalleonBuilder pm, List<GalleonFeaturePack> featurePacks, List<String> layers, List<String> excludedLayers, Map<String, String> pluginOptions, String layersConfigFileName) throws ProvisioningException, IllegalArgumentException {
        GalleonProvisioningConfig.Builder state = GalleonProvisioningConfig.builder();
        boolean hasLayers = !layers.isEmpty();
        boolean fpWithDefaults = true;
        if (!hasLayers) {
            for (GalleonFeaturePack fp : featurePacks) {
                if (fp.isInheritConfigs() == null && fp.isInheritPackages() == null && fp.getIncludedConfigs().isEmpty() && fp.getExcludedConfigs().isEmpty() && !fp.isTransitive() && fp.getExcludedPackages().isEmpty() && fp.getIncludedPackages().isEmpty()) continue;
                fpWithDefaults = false;
                break;
            }
        }
        for (GalleonFeaturePack fp : featurePacks) {
            GalleonFeaturePackConfig.Builder fpConfig;
            FeaturePackLocation fpl;
            if (fp.getLocation() == null && (fp.getGroupId() == null || fp.getArtifactId() == null) && fp.getNormalizedPath() == null) {
                throw new IllegalArgumentException("Feature-pack location, Maven GAV or feature pack path is missing");
            }
            if (fp.getNormalizedPath() != null) {
                fpl = pm.addLocal(fp.getNormalizedPath(), false);
            } else if (fp.getGroupId() != null && fp.getArtifactId() != null) {
                String coords = GalleonUtils.getMavenCoords(fp);
                fpl = FeaturePackLocation.fromString(coords);
            } else {
                long numSeparators;
                Object location = fp.getLocation();
                if (!FeaturePackLocation.fromString((String)location).hasUniverse() && (numSeparators = ((String)location).chars().filter(ch -> ch == 58).count()) <= 1L) {
                    location = (String)location + ":";
                }
                fpl = FeaturePackLocation.fromString((String)location);
            }
            GalleonFeaturePackConfig.Builder builder = fpConfig = fp.isTransitive() ? GalleonFeaturePackConfig.transitiveBuilder(fpl) : GalleonFeaturePackConfig.builder(fpl);
            if (fp.isInheritConfigs() == null) {
                if (hasLayers) {
                    fpConfig.setInheritConfigs(false);
                } else if (fpWithDefaults) {
                    fpConfig.setInheritConfigs(true);
                }
            } else {
                fpConfig.setInheritConfigs(fp.isInheritConfigs());
            }
            if (fp.isInheritPackages() == null) {
                if (hasLayers) {
                    fpConfig.setInheritPackages(false);
                } else if (fpWithDefaults) {
                    fpConfig.setInheritConfigs(true);
                }
            } else {
                fpConfig.setInheritPackages(fp.isInheritPackages());
            }
            if (!fp.getExcludedConfigs().isEmpty()) {
                for (ConfigurationId configId : fp.getExcludedConfigs()) {
                    if (configId.isModelOnly()) {
                        fpConfig.excludeConfigModel(configId.getId().getModel());
                        continue;
                    }
                    fpConfig.excludeDefaultConfig(configId.getId());
                }
            }
            if (!fp.getIncludedConfigs().isEmpty()) {
                for (ConfigurationId configId : fp.getIncludedConfigs()) {
                    if (configId.isModelOnly()) {
                        fpConfig.includeConfigModel(configId.getId().getModel());
                        continue;
                    }
                    fpConfig.includeDefaultConfig(configId.getId());
                }
            }
            if (!fp.getIncludedPackages().isEmpty()) {
                for (String includedPackage : fp.getIncludedPackages()) {
                    fpConfig.includePackage(includedPackage);
                }
            }
            if (!fp.getExcludedPackages().isEmpty()) {
                for (String excludedPackage : fp.getExcludedPackages()) {
                    fpConfig.excludePackage(excludedPackage);
                }
            }
            state.addFeaturePackDep(fpConfig.build());
        }
        LinkedHashMap<String, String> copiedOptions = new LinkedHashMap<String, String>(pluginOptions);
        if (!layers.isEmpty()) {
            GalleonConfigurationWithLayersBuilder config = GalleonConfigurationWithLayersBuilder.builder("standalone", layersConfigFileName);
            for (String l : layers) {
                config.includeLayer(l);
            }
            for (String l : excludedLayers) {
                config.excludeLayer(l);
            }
            state.addConfig(config.build());
            if (pluginOptions.isEmpty()) {
                copiedOptions.put("optional-packages", "passive+");
            } else if (!copiedOptions.containsKey("optional-packages")) {
                copiedOptions.put("optional-packages", "passive+");
            }
        }
        state.addOptions(copiedOptions);
        return state.build();
    }

    private static String getMavenCoords(GalleonFeaturePack fp) {
        String type;
        StringBuilder builder = new StringBuilder();
        builder.append(fp.getGroupId()).append(":").append(fp.getArtifactId());
        String string = type = fp.getExtension() == null ? fp.getType() : fp.getExtension();
        if (fp.getClassifier() != null || type != null) {
            builder.append(":").append(fp.getClassifier() == null ? "" : fp.getClassifier()).append(":").append(type == null ? "" : type);
        }
        if (fp.getVersion() != null) {
            builder.append(":").append(fp.getVersion());
        }
        return builder.toString();
    }

    private static String getFeaturePackLocation(String featurePackLocation, String version) {
        StringBuilder fplBuilder = new StringBuilder();
        fplBuilder.append(Objects.requireNonNull(featurePackLocation, "The feature pack location is required."));
        if (version != null) {
            fplBuilder.append("#").append(version);
        }
        return fplBuilder.toString();
    }
}

