/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.as.controller.client.helpers.domain.ServerIdentity;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.wildfly.common.Assert;
import org.wildfly.plugin.tools.ContainerDescription;
import org.wildfly.plugin.tools.DeploymentOperations;
import org.wildfly.plugin.tools.OperationExecutionException;
import org.wildfly.plugin.tools.util.Utils;

public class ServerHelper {
    private static final ModelNode EMPTY_ADDRESS = new ModelNode().setEmptyList();
    private static final Logger LOGGER = Logger.getLogger(ServerHelper.class);

    public static boolean isValidHomeDirectory(Path path) {
        return Utils.isValidHomeDirectory(path);
    }

    public static boolean isValidHomeDirectory(String path) {
        return path != null && ServerHelper.isValidHomeDirectory(Paths.get(path, new String[0]));
    }

    public static ContainerDescription getContainerDescription(ModelControllerClient client) throws IOException, OperationExecutionException {
        return ContainerDescription.lookup(Assert.checkNotNullParam("client", client));
    }

    public static void reloadIfRequired(ModelControllerClient client, long timeout) {
        String launchType = ServerHelper.launchType(client);
        if ("STANDALONE".equalsIgnoreCase(launchType)) {
            String runningState = ServerHelper.serverState(client);
            if ("reload-required".equalsIgnoreCase(runningState)) {
                ServerHelper.executeReload(client, Operations.createOperation("reload"));
                try {
                    ServerHelper.waitForStandalone(client, timeout);
                }
                catch (InterruptedException | TimeoutException e) {
                    throw new RuntimeException("Failed to reload the serve.", e);
                }
            }
        } else {
            LOGGER.warnf("Server type %s is not supported for a reload.", (Object)launchType);
        }
    }

    public static void executeReload(ModelControllerClient client, ModelNode reloadOp) {
        block3: {
            try {
                ModelNode result = client.execute(reloadOp);
                if (!Operations.isSuccessfulOutcome(result)) {
                    throw new RuntimeException(String.format("Failed to reload the server with %s: %s", reloadOp, Operations.getFailureDescription(result)));
                }
            }
            catch (IOException e) {
                Throwable cause = e.getCause();
                if (cause instanceof ExecutionException || cause instanceof CancellationException) break block3;
                throw new RuntimeException(e);
            }
        }
    }

    public static String launchType(ModelControllerClient client) {
        try {
            ModelNode response = client.execute(Operations.createReadAttributeOperation(EMPTY_ADDRESS, "launch-type"));
            if (Operations.isSuccessfulOutcome(response)) {
                return Operations.readResult(response).asString();
            }
        }
        catch (IOException | RuntimeException e) {
            LOGGER.trace((Object)"Interrupted determining the launch type", e);
        }
        return "unknown";
    }

    public static String serverState(ModelControllerClient client) {
        String launchType = ServerHelper.launchType(client);
        if ("STANDALONE".equalsIgnoreCase(launchType)) {
            try {
                ModelNode response = client.execute(Operations.createReadAttributeOperation(EMPTY_ADDRESS, "server-state"));
                return Operations.isSuccessfulOutcome(response) ? Operations.readResult(response).asString() : "failed";
            }
            catch (IOException | RuntimeException e) {
                LOGGER.tracef("Interrupted determining the server state", (Object)e);
                return "failed";
            }
        }
        return "unknown";
    }

    public static void waitForDomain(ModelControllerClient client, long startupTimeout) throws InterruptedException, RuntimeException, TimeoutException {
        ServerHelper.waitForDomain(null, client, startupTimeout);
    }

    public static void waitForDomain(Process process, ModelControllerClient client, long startupTimeout) throws InterruptedException, RuntimeException, TimeoutException {
        long timeout;
        Assert.checkNotNullParam("client", client);
        long sleep = 100L;
        for (timeout = startupTimeout * 1000L; timeout > 0L; timeout -= 100L) {
            long before = System.currentTimeMillis();
            if (ServerHelper.isDomainRunning(client)) break;
            timeout -= System.currentTimeMillis() - before;
            if (process != null && !process.isAlive()) {
                throw new RuntimeException(String.format("The process has unexpectedly exited with code %d", process.exitValue()));
            }
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        if (timeout <= 0L) {
            if (process != null) {
                process.destroy();
            }
            throw new TimeoutException(String.format("The server did not start within %s seconds.", startupTimeout));
        }
    }

    public static boolean isDomainRunning(ModelControllerClient client) {
        return ServerHelper.isDomainRunning(client, false);
    }

    public static void shutdownDomain(ModelControllerClient client) throws IOException, OperationExecutionException {
        ServerHelper.shutdownDomain(client, 0);
    }

    public static void shutdownDomain(ModelControllerClient client, int timeout) throws IOException, OperationExecutionException {
        ModelNode stopServersOp = Operations.createOperation("stop-servers");
        stopServersOp.get("blocking").set(true);
        stopServersOp.get("timeout").set(timeout);
        ModelNode response = client.execute(stopServersOp);
        if (!Operations.isSuccessfulOutcome(response)) {
            throw new OperationExecutionException("Failed to stop servers.", stopServersOp, response);
        }
        ModelNode address = ServerHelper.determineHostAddress(client);
        ModelNode shutdownOp = Operations.createOperation("shutdown", address);
        response = client.execute(shutdownOp);
        if (Operations.isSuccessfulOutcome(response)) {
            while (ServerHelper.isDomainRunning(client, true)) {
                try {
                    TimeUnit.MILLISECONDS.sleep(20L);
                }
                catch (InterruptedException e) {
                    LOGGER.trace((Object)"Interrupted during sleep", e);
                }
            }
        } else {
            throw new OperationExecutionException("Failed to shutdown host.", shutdownOp, response);
        }
    }

    public static ModelNode determineHostAddress(ModelControllerClient client) throws IOException, OperationExecutionException {
        ModelNode op = Operations.createReadAttributeOperation(EMPTY_ADDRESS, "local-host-name");
        ModelNode response = client.execute(op);
        if (Operations.isSuccessfulOutcome(response)) {
            return DeploymentOperations.createAddress("host", Operations.readResult(response).asString());
        }
        throw new OperationExecutionException(op, response);
    }

    public static void waitForStandalone(ModelControllerClient client, long startupTimeout) throws InterruptedException, RuntimeException, TimeoutException {
        ServerHelper.waitForStandalone(null, client, startupTimeout);
    }

    public static void waitForStandalone(Process process, ModelControllerClient client, long startupTimeout) throws InterruptedException, RuntimeException, TimeoutException {
        long timeout;
        Assert.checkNotNullParam("client", client);
        long sleep = 100L;
        for (timeout = startupTimeout * 1000L; timeout > 0L; timeout -= 100L) {
            long before = System.currentTimeMillis();
            if (ServerHelper.isStandaloneRunning(client)) break;
            timeout -= System.currentTimeMillis() - before;
            if (process != null && !process.isAlive()) {
                throw new RuntimeException(String.format("The process has unexpectedly exited with code %d", process.exitValue()));
            }
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        if (timeout <= 0L) {
            if (process != null) {
                process.destroy();
            }
            throw new TimeoutException(String.format("The server did not start within %s seconds.", startupTimeout));
        }
    }

    public static boolean isStandaloneRunning(ModelControllerClient client) {
        try {
            ModelNode response = client.execute(Operations.createReadAttributeOperation(EMPTY_ADDRESS, "server-state"));
            if (Operations.isSuccessfulOutcome(response)) {
                String state = Operations.readResult(response).asString();
                return !"starting".equals(state) && !"stopping".equals(state);
            }
        }
        catch (IOException | RuntimeException e) {
            LOGGER.trace((Object)"Interrupted determining if standalone is running", e);
        }
        return false;
    }

    public static void shutdownStandalone(ModelControllerClient client) throws IOException {
        ServerHelper.shutdownStandalone(client, 0);
    }

    public static void shutdownStandalone(ModelControllerClient client, int timeout) throws IOException {
        ModelNode op = Operations.createOperation("shutdown");
        op.get("timeout").set(timeout);
        ModelNode response = client.execute(op);
        if (Operations.isSuccessfulOutcome(response)) {
            while (ServerHelper.isStandaloneRunning(client)) {
                try {
                    TimeUnit.MILLISECONDS.sleep(20L);
                }
                catch (InterruptedException e) {
                    LOGGER.trace((Object)"Interrupted during sleep", e);
                }
            }
        } else {
            throw new OperationExecutionException(op, response);
        }
    }

    private static boolean isDomainRunning(ModelControllerClient client, boolean shutdown) {
        DomainClient domainClient = client instanceof DomainClient ? (DomainClient)client : DomainClient.Factory.create(client);
        try {
            ModelNode hostAddress = ServerHelper.determineHostAddress(domainClient);
            Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create().addStep(Operations.createReadAttributeOperation(hostAddress, "running-mode")).addStep(Operations.createReadAttributeOperation(hostAddress, "host-state"));
            ModelNode response = domainClient.execute(builder.build());
            if (Operations.isSuccessfulOutcome(response) && "ADMIN_ONLY".equals(Operations.readResult((response = Operations.readResult(response)).get("step-1")).asString()) && Operations.isSuccessfulOutcome(response.get("step-2"))) {
                String state = Operations.readResult(response).asString();
                return !"starting".equals(state) && !"stopping".equals(state);
            }
            HashMap<ServerIdentity, ServerStatus> servers = new HashMap<ServerIdentity, ServerStatus>();
            Map<ServerIdentity, ServerStatus> statuses = domainClient.getServerStatuses();
            for (ServerIdentity id : statuses.keySet()) {
                ServerStatus status = statuses.get(id);
                switch (status) {
                    case DISABLED: 
                    case STARTED: {
                        servers.put(id, status);
                    }
                }
            }
            if (shutdown) {
                return statuses.isEmpty();
            }
            return statuses.size() == servers.size();
        }
        catch (Exception e) {
            LOGGER.trace((Object)"Interrupted determining if domain is running", e);
            return false;
        }
    }

    static {
        EMPTY_ADDRESS.protect();
    }
}

