/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class VersionComparator
implements Comparator<String> {
    private static final VersionComparator INSTANCE = new VersionComparator();

    public static int compareVersion(String v1, String v2) {
        return INSTANCE.compare(v1, v2);
    }

    @Override
    public int compare(String o1, String o2) {
        Version v1 = Version.parse(o1);
        Version v2 = Version.parse(o2);
        return v1.compareTo(v2);
    }

    private static class Version
    implements Comparable<Version> {
        private final List<Part> parts;
        private final String original;
        private static final Part NULL_PART = new Part(){

            @Override
            public int compareTo(Part o) {
                throw new UnsupportedOperationException();
            }
        };

        private Version(String original, List<Part> parts) {
            this.original = original;
            this.parts = parts;
        }

        public static Version parse(String version) {
            ArrayList<Part> parts = new ArrayList<Part>();
            StringBuilder sb = new StringBuilder();
            boolean isDigit = false;
            block3: for (char c : version.toCharArray()) {
                switch (c) {
                    case '-': 
                    case '.': {
                        if (isDigit) {
                            parts.add(new IntegerPart(Integer.parseInt(sb.toString())));
                        } else {
                            parts.add(new StringPart(sb.toString()));
                        }
                        sb.setLength(0);
                        isDigit = false;
                        continue block3;
                    }
                    default: {
                        if (Character.isDigit(c)) {
                            if (!isDigit && sb.length() > 0) {
                                parts.add(new StringPart(sb.toString()));
                                sb.setLength(0);
                            }
                            isDigit = true;
                        } else {
                            if (isDigit && sb.length() > 0) {
                                parts.add(new IntegerPart(Integer.parseInt(sb.toString())));
                                sb.setLength(0);
                            }
                            isDigit = false;
                        }
                        sb.append(c);
                    }
                }
            }
            if (sb.length() > 0) {
                if (isDigit) {
                    parts.add(new IntegerPart(Integer.parseInt(sb.toString())));
                } else {
                    parts.add(new StringPart(sb.toString()));
                }
            }
            return new Version(version, parts);
        }

        @Override
        public int compareTo(Version o) {
            Iterator<Part> left = this.parts.iterator();
            Iterator<Part> right = o.parts.iterator();
            int result = 0;
            while (left.hasNext() || right.hasNext()) {
                if (left.hasNext() && right.hasNext()) {
                    result = left.next().compareTo(right.next());
                } else if (left.hasNext()) {
                    result = left.next().compareTo(NULL_PART);
                } else if (right.hasNext()) {
                    result = -1 * right.next().compareTo(NULL_PART);
                }
                if (result == 0) continue;
                break;
            }
            return result;
        }

        public int hashCode() {
            return 33 * (17 + this.original.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Version)) {
                return false;
            }
            Version other = (Version)obj;
            return this.original.equals(other.original);
        }

        public String toString() {
            return this.original;
        }

        private static class StringPart
        implements Part {
            private final String originalValue;
            private final String value;
            private final ReleaseType releaseType;

            private StringPart(String value) {
                this.originalValue = value;
                this.value = value.toLowerCase(Locale.ROOT);
                this.releaseType = ReleaseType.find(this.value);
            }

            @Override
            public int compareTo(Part o) {
                if (o == NULL_PART) {
                    return this.releaseType.compareTo(ReleaseType.FINAL);
                }
                if (o instanceof StringPart) {
                    if (this.releaseType == ReleaseType.UNKNOWN && ((StringPart)o).releaseType == ReleaseType.UNKNOWN) {
                        return this.value.compareTo(((StringPart)o).value);
                    }
                    return this.releaseType.compareTo(((StringPart)o).releaseType);
                }
                return -1;
            }

            public String toString() {
                return this.originalValue;
            }
        }

        private static class IntegerPart
        implements Part {
            private static final Integer DEFAULT_INTEGER = 0;
            private final Integer value;

            private IntegerPart(Integer value) {
                this.value = value;
            }

            @Override
            public int compareTo(Part o) {
                if (o == NULL_PART) {
                    return this.value.compareTo(DEFAULT_INTEGER);
                }
                if (o instanceof IntegerPart) {
                    return this.value.compareTo(((IntegerPart)o).value);
                }
                return 1;
            }

            public String toString() {
                return this.value.toString();
            }
        }

        private static interface Part
        extends Comparable<Part> {
        }
    }

    private static enum ReleaseType {
        UNKNOWN(null, new String[0]),
        SNAPSHOT("snapshot", new String[0]),
        ALPHA("alpha", "a"),
        BETA("beta", "b"),
        MILESTONE("milestone", "m"),
        RELEASE_CANDIDATE("rc", "cr"),
        FINAL("final", "", "ga");

        private static final Map<String, ReleaseType> ENTRIES;
        private final String type;
        private final List<String> aliases;

        private ReleaseType(String type, String ... aliases) {
            this.type = type;
            this.aliases = Collections.unmodifiableList(Arrays.asList(aliases));
        }

        static ReleaseType find(String s) {
            if (ENTRIES.containsKey(s)) {
                return ENTRIES.get(s);
            }
            return UNKNOWN;
        }

        static {
            HashMap<Object, ReleaseType> map = new HashMap<Object, ReleaseType>();
            for (ReleaseType r : ReleaseType.values()) {
                if (r == UNKNOWN) continue;
                map.put(r.type, r);
                map.put("-" + r.type, r);
                for (String alias : r.aliases) {
                    map.put(alias, r);
                }
            }
            ENTRIES = Collections.unmodifiableMap(map);
        }
    }
}

