/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.cli.commands;

import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.wildfly.glow.FeaturePacks;
import org.wildfly.glow.Layer;
import org.wildfly.glow.LayerMapping;
import org.wildfly.glow.cli.CLIArguments;
import org.wildfly.glow.cli.commands.AbstractCommand;
import org.wildfly.glow.cli.commands.CommandsUtils;
import picocli.CommandLine;

@CommandLine.Command(name="show-configuration", sortOptions=true)
public class ShowConfigurationCommand
extends AbstractCommand {
    @CommandLine.Option(names={"-c", "--cloud"})
    Optional<Boolean> cloud;
    @CommandLine.Option(names={"-wp", "--wildfly-preview"})
    Optional<Boolean> wildflyPreview;
    @CommandLine.Option(names={"-sv", "--server-version"}, paramLabel="<server version>")
    Optional<String> wildflyServerVersion;
    @CommandLine.Option(names={"--input-feature-packs-file"}, paramLabel="<provisioning file path>")
    Optional<Path> provisioningXml;

    @Override
    public Integer call() throws Exception {
        this.print("Wildfly Glow is retrieving known provisioning configuration...");
        String context = "bare-metal";
        if (this.cloud.orElse(false).booleanValue()) {
            context = "cloud";
        }
        final String finalContext = context;
        final boolean isLatest = this.wildflyServerVersion.isEmpty();
        final String vers = this.wildflyServerVersion.isPresent() ? this.wildflyServerVersion.get() : FeaturePacks.getLatestVersion();
        CommandsUtils.ProvisioningConsumer consumer = new CommandsUtils.ProvisioningConsumer(){

            @Override
            public void consume(GalleonProvisioningConfig provisioning, Map<String, Layer> all, LayerMapping mapping, Map<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>> fpDependencies) throws Exception {
                String configStr = CLIArguments.dumpConfiguration(fpDependencies, finalContext, vers, all, mapping, provisioning, isLatest, ShowConfigurationCommand.this.wildflyPreview.orElse(false));
                ShowConfigurationCommand.this.print(configStr);
            }
        };
        CommandsUtils.buildProvisioning(consumer, context, this.provisioningXml.orElse(null), this.wildflyServerVersion.isEmpty(), context, this.wildflyPreview.orElse(false));
        return 0;
    }
}

