/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.cli;

import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.wildfly.glow.Arguments;
import org.wildfly.glow.FeaturePacks;
import org.wildfly.glow.Layer;
import org.wildfly.glow.LayerMapping;
import org.wildfly.glow.OutputFormat;

public class CLIArguments
extends Arguments {
    private static final String EXECUTION_CONTEXT_OPTION = "--context";
    private static final String DISPLAY_CONFIGURATION_OPTION = "--display-configuration";
    public static final String HELP_OPTION = "--help";
    public static final String VERSION_OPTION = "--version";
    private static final String SERVER_VERSION_OPTION = "--server-version";
    private static final String GO_OFFLINE_OPTION = "--go-offline";
    private static final String SUGGESTION_OPTION = "--suggest";
    private static final String PREVIEW_OPTION = "--preview";
    private static final String OUTPUT_OPTION = "--output";
    private static final String FEATURE_PACKS_FILE_OPTION = "--feature-packs-file";
    private static final String PROFILE_OPTION = "--profile";
    private static final String ADDONS_OPTION = "--add-ons";
    private static final String VERBOSE_OPTION = "--verbose";
    private static final String JNDI_LAYERS_ARGUMENT = "--add-layers-for-jndi";
    private static final String JNDI_LAYERS_ARGUMENT_EXPLANATION = "In the case some layers are missing, consider adding them manually with the --add-layers-for-jndi parameter.";
    private final boolean goOffline;
    private final boolean help;
    private final boolean version;
    private final boolean displayConfigurationInfo;

    public CLIArguments(boolean version, boolean help, String executionContext, Set<String> executionProfiles, Set<String> userEnabledAddOns, List<Path> binaries, Path provisioningXML, OutputFormat output, boolean suggest, boolean goOffline, String serverVersion, Set<String> layersForJndi, boolean verbose, boolean techPreview, boolean displayConfigurationInfo) {
        super(executionContext, executionProfiles, userEnabledAddOns, binaries, provisioningXML, output, suggest, serverVersion, "standalone.xml", layersForJndi, verbose, techPreview, null);
        this.goOffline = goOffline;
        this.help = help;
        this.version = version;
        this.displayConfigurationInfo = displayConfigurationInfo;
    }

    public static CLIArguments fromMainArguments(String[] args) throws Exception {
        String executionContext = null;
        ArrayList<Path> binaries = new ArrayList<Path>();
        TreeSet<String> executionProfiles = new TreeSet<String>();
        TreeSet<String> userEnabledAddOns = new TreeSet<String>();
        TreeSet<String> layersForJndi = new TreeSet<String>();
        Path provisioningXML = null;
        OutputFormat output = null;
        boolean goOffline = false;
        boolean suggest = false;
        String version = null;
        boolean help = false;
        boolean isVersion = false;
        boolean verbose = false;
        boolean preview = false;
        boolean displayConfigurationInfo = false;
        if (args.length == 0) {
            return new CLIArguments(isVersion, help, executionContext, executionProfiles, userEnabledAddOns, binaries, provisioningXML, output, suggest, goOffline, version, layersForJndi, verbose, preview, displayConfigurationInfo);
        }
        for (String a : args) {
            if (a.startsWith("--")) {
                if (a.equals(DISPLAY_CONFIGURATION_OPTION)) {
                    displayConfigurationInfo = true;
                    continue;
                }
                if (a.equals(PREVIEW_OPTION)) {
                    preview = true;
                    continue;
                }
                if (a.equals(HELP_OPTION)) {
                    help = true;
                    continue;
                }
                if (a.equals(VERSION_OPTION)) {
                    isVersion = true;
                    continue;
                }
                if (a.equals(SUGGESTION_OPTION)) {
                    suggest = true;
                    continue;
                }
                if (a.equals(GO_OFFLINE_OPTION)) {
                    goOffline = true;
                    continue;
                }
                if (a.startsWith(SERVER_VERSION_OPTION)) {
                    version = CLIArguments.parseArgStringValue(a);
                    continue;
                }
                if (a.startsWith(OUTPUT_OPTION)) {
                    int i = a.indexOf("=");
                    String type = CLIArguments.parseArgStringValue(a);
                    for (OutputFormat of : EnumSet.allOf(OutputFormat.class)) {
                        if (!of.name.equals(type)) continue;
                        output = of;
                        break;
                    }
                    if (output != null) continue;
                    throw new Exception("Invalid output format " + type);
                }
                if (a.startsWith(EXECUTION_CONTEXT_OPTION)) {
                    executionContext = CLIArguments.parseArgStringValue(a);
                    if ("cloud".equals(executionContext) || "bare-metal".equals(executionContext)) continue;
                    throw new Exception("Unknown execution context " + executionContext);
                }
                if (a.startsWith(FEATURE_PACKS_FILE_OPTION)) {
                    provisioningXML = Paths.get(CLIArguments.parseArgStringValue(a), new String[0]);
                    if (Files.exists(provisioningXML, new LinkOption[0])) continue;
                    throw new Exception("Provisioning file " + provisioningXML + "doesn't exist");
                }
                if (a.startsWith(PROFILE_OPTION)) {
                    List<String> split = CLIArguments.parseArgStringArrayValue(a);
                    for (String s : split) {
                        if ((s = s.trim()).isEmpty() || "standalone".equals(s)) continue;
                        executionProfiles.add(s);
                    }
                    continue;
                }
                if (a.startsWith(ADDONS_OPTION)) {
                    userEnabledAddOns.addAll(CLIArguments.parseArgStringArrayValue(a));
                    continue;
                }
                if (a.startsWith(JNDI_LAYERS_ARGUMENT)) {
                    layersForJndi.addAll(CLIArguments.parseArgStringArrayValue(a));
                    continue;
                }
                if (a.equals(VERBOSE_OPTION)) {
                    verbose = true;
                    continue;
                }
                throw new Exception("Unknown Option " + a);
            }
            List<String> split = Arrays.asList(a.split(","));
            for (String s : split) {
                binaries.add(Paths.get(s, new String[0]));
            }
        }
        if (!isVersion && !help && !goOffline && binaries.isEmpty() && userEnabledAddOns.isEmpty() && !displayConfigurationInfo) {
            throw new Exception("No deployment to scan nor add-ons have been set");
        }
        return new CLIArguments(isVersion, help, executionContext, executionProfiles, userEnabledAddOns, binaries, provisioningXML, output, suggest, goOffline, version, layersForJndi, verbose, preview, displayConfigurationInfo);
    }

    private static String parseArgStringValue(String arg) {
        int i = arg.indexOf("=");
        return arg.substring(i + 1);
    }

    private static List<String> parseArgStringArrayValue(String arg) {
        String value = CLIArguments.parseArgStringValue(arg);
        return Arrays.asList(value.split(","));
    }

    public static void dumpInfos(Set<String> profiles) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("\nDescription\n");
        builder.append("\nglow helps you create a WildFly server based on the content of your WAR/JAR/EAR deployment(s).\n");
        builder.append("glow will identify the required Galleon feature-packs and layers.\nglow will identify possible configuration errors and will help you fix them.\nglow will identify and suggest WildFly add-ons to extend the server capabilities.\nglow will provision a server or a bootable jar with your application deployed in it.\nYou can choose to generate an hollow server or bootable jar (with no deployment) by only selecting a set of add-ons.\n");
        builder.append("\nUsage:\n");
        builder.append("\njava -jar glow.jar [<comma separated list of path to war|jar|ear>] [options]\n");
        builder.append("\nOptions:\n");
        builder.append("\n--add-layers-for-jndi=<list of layers>\n");
        builder.append("\n In the case some layers are missing, consider adding them manually with the --add-layers-for-jndi parameter.\n");
        builder.append("\n--add-ons=<comma separated list of add-ons>\n");
        builder.append("\n List of add-ons to enable. To get the list of possible add-ons, use the --display-configuration option.\n");
        builder.append("\n--display-configuration\n");
        builder.append("\n Display the configuration information (known feature-packs, add-ons and layers) for a given execution context (bare-metal by default, set --context=<context> option to change it), server version (latest by default, set --server-version=<server version> option to change it) and preview (false by default, set --preview option to change it)\n");
        builder.append("\n--context=<execution context>\n");
        builder.append("\n Possible execution context:\n");
        builder.append("  - bare-metal (default)\n");
        builder.append("  - cloud\n");
        builder.append("\n--feature-packs-file=<path to provisioning.xml file>\n");
        builder.append("\n This file contains the feature-packs used by glow during scanning. By default the URL ").append(FeaturePacks.getFeaturePacksURL()).append(" contains the list of known feature-packs for each server version.\n");
        builder.append("\n--go-offline\n");
        builder.append("\n Glow will generate a zip file containing all that is required to run the tool in offline mode. Put this zip in the working directory of glow to work offline.\n");
        builder.append("\n --help\n");
        builder.append("\n Print this help content.\n");
        builder.append("\n--output=<type of output>\n");
        builder.append("\n Possible output formats (by default, glow scanning results are printed in the console):\n");
        EnumSet<OutputFormat> set = EnumSet.allOf(OutputFormat.class);
        TreeSet<CallSite> sorted = new TreeSet<CallSite>();
        for (OutputFormat outputFormat : set) {
            sorted.add((CallSite)((Object)(outputFormat.name + ": " + outputFormat.description)));
        }
        for (String string : sorted) {
            builder.append("  - ").append(string).append("\n");
        }
        builder.append("\n--preview\n");
        builder.append("\n Use only preview feature-packs as input.\n");
        builder.append("\n--profile=<profile>\n");
        builder.append("\n Possible execution profile (default non HA):\n");
        for (String string : profiles) {
            builder.append("  - ").append(string).append("\n");
        }
        builder.append("\n--server-version=<server version>\n");
        builder.append("\n Glow works with the latest version of the server by default. Supported versions: ").append(FeaturePacks.getAllVersions()).append(".\n");
        builder.append("\n--suggest\n");
        builder.append("\n Glow will suggest add-ons and usable env variables.\n");
        builder.append("\n--verbose\n");
        builder.append("\n Enable more verbose output of errors\n");
        builder.append("\n --version\n");
        builder.append("\n Print the tool version.\n");
        System.out.println(builder);
    }

    public static String dumpConfiguration(Map<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>> fpDependencies, String context, String serverVersion, Map<String, Layer> allLayers, LayerMapping mapping, GalleonProvisioningConfig config, boolean isLatest, boolean techPreview) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("Execution context: ").append(context).append("\n");
        builder.append("Server version: ").append(serverVersion).append(isLatest ? " (latest)" : "").append("\n");
        builder.append("Tech Preview: ").append(techPreview).append("\n");
        LinkedHashSet<FeaturePackLocation.ProducerSpec> topLevel = new LinkedHashSet<FeaturePackLocation.ProducerSpec>();
        for (GalleonFeaturePackConfig fp : config.getFeaturePackDeps()) {
            topLevel.add(fp.getLocation().getProducer());
        }
        for (GalleonFeaturePackConfig fp : config.getFeaturePackDeps()) {
            builder.append("\nFeature-pack: ").append("@|bold ").append(fp.getLocation().getFPID()).append("|@\n");
            builder.append("Contained layers: ");
            TreeSet<String> layers = new TreeSet<String>();
            Set<FeaturePackLocation.ProducerSpec> deps = fpDependencies.get(fp.getLocation().getFPID());
            for (Layer l : allLayers.values()) {
                if (l.getFeaturePacks().contains(fp.getLocation().getFPID())) {
                    layers.add(l.getName());
                }
                if (deps == null) continue;
                for (FeaturePackLocation.ProducerSpec dep : deps) {
                    if (topLevel.contains(dep)) continue;
                    for (FeaturePackLocation.FPID fpid : l.getFeaturePacks()) {
                        if (!fpid.getProducer().equals(dep)) continue;
                        layers.add(l.getName());
                    }
                }
            }
            topLevel.addAll(deps);
            builder.append(layers).append("\n");
        }
        return builder.toString();
    }

    public boolean isGoOffline() {
        return this.goOffline;
    }

    public boolean isHelp() {
        return this.help;
    }

    public boolean isVersion() {
        return this.version;
    }

    public boolean isDisplayConfigurationInfo() {
        return this.displayConfigurationInfo;
    }
}

