/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.windup;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.wildfly.glow.Layer;
import org.wildfly.glow.windup.WindupMapping;

public class WindupSupport {
    public static Set<Layer> getLayers(Map<String, Layer> all, Path mappingFile, Path jsonAnalysis) throws IOException {
        String json = new String(Files.readAllBytes(jsonAnalysis), StandardCharsets.UTF_8);
        String mapping = new String(Files.readAllBytes(mappingFile), StandardCharsets.UTF_8);
        ObjectMapper objectMapper = new ObjectMapper();
        WindupMapping wdMapping = objectMapper.readValue(mapping, WindupMapping.class);
        List maps = objectMapper.readValue(json, List.class);
        HashSet<String> tags = new HashSet<String>();
        for (Map obj : maps) {
            List lst = (List)obj.get("technologyTags");
            for (Map t : lst) {
                tags.add((String)t.get("name"));
            }
        }
        Map<String, List<String>> assoc = wdMapping.getMapping();
        TreeSet<Layer> layers = new TreeSet<Layer>();
        for (String t : tags) {
            List<String> l = assoc.get(t);
            for (String s : l) {
                Layer ll = all.get(s);
                layers.add(ll);
            }
        }
        return layers;
    }

    public static Path getWindupMapping() {
        Path path = null;
        String p = System.getProperty("windup");
        if (p != null) {
            path = Paths.get(p, new String[0]);
        }
        return path;
    }
}

