/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools;

import java.io.IOException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.common.Assert;
import org.wildfly.plugin.tools.DefaultContainerDescription;
import org.wildfly.plugin.tools.OperationExecutionException;

public interface ContainerDescription {
    public String getProductName();

    public String getProductVersion();

    public String getReleaseVersion();

    default public ModelVersion getModelVersion() {
        return ModelVersion.DEFAULT;
    }

    public String getLaunchType();

    public boolean isDomain();

    public static ContainerDescription lookup(ModelControllerClient client) throws IOException, OperationExecutionException {
        return DefaultContainerDescription.lookup(Assert.checkNotNullParam("client", client));
    }

    public static final class ModelVersion
    implements Comparable<ModelVersion> {
        static final ModelVersion DEFAULT = new ModelVersion(0, 0, 0);
        private final int major;
        private final int minor;
        private final int micro;

        ModelVersion(int major, int minor, int micro) {
            this.major = major;
            this.minor = minor;
            this.micro = micro;
        }

        public int major() {
            return this.major;
        }

        public int minor() {
            return this.minor;
        }

        public int micro() {
            return this.micro;
        }

        public int hashCode() {
            int prime = 31;
            int result = this.major;
            result = 31 * result + this.minor;
            result = 31 * result + this.micro;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ModelVersion)) {
                return false;
            }
            ModelVersion other = (ModelVersion)obj;
            return this.major == other.major && this.minor == other.minor && this.micro == other.micro;
        }

        public String toString() {
            return this.major + "." + this.minor + "." + this.micro;
        }

        @Override
        public int compareTo(ModelVersion o) {
            int result = Integer.compare(this.major, o.major);
            result = result == 0 ? Integer.compare(this.minor, o.major) : result;
            result = result == 0 ? Integer.compare(this.micro, o.micro) : result;
            return result;
        }
    }
}

