/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools.cli;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.logging.Logger;
import org.wildfly.plugin.tools.bootablejar.BootLoggingConfiguration;

public class CLIWrapper
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(CLIWrapper.class);
    private final Object ctx;
    private final Method handle;
    private final Method handleSafe;
    private final Method terminateSession;
    private final Method getModelControllerClient;
    private final Method bindClient;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final String origConfig;
    private final Path jbossHome;
    private final BootLoggingConfiguration bootLoggingConfiguration;

    public CLIWrapper(Path jbossHome, boolean resolveExpression, ClassLoader loader) {
        this(jbossHome, resolveExpression, loader, null);
    }

    public CLIWrapper(Path jbossHome, boolean resolveExpression, ClassLoader loader, BootLoggingConfiguration bootLoggingConfiguration) {
        if (jbossHome != null) {
            Path config = jbossHome.resolve("bin").resolve("jboss-cli.xml");
            this.origConfig = System.getProperty("jboss.cli.config");
            if (Files.exists(config, new LinkOption[0])) {
                System.setProperty("jboss.cli.config", config.toString());
            }
        } else {
            this.origConfig = null;
        }
        this.jbossHome = jbossHome;
        try {
            Constructor<?> constructor = loader.loadClass("org.jboss.as.cli.impl.CommandContextConfiguration$Builder").getConstructor(new Class[0]);
            Object builder = constructor.newInstance(new Object[0]);
            Method setEchoCommand = builder.getClass().getMethod("setEchoCommand", Boolean.TYPE);
            setEchoCommand.invoke(builder, true);
            Method setResolve = builder.getClass().getMethod("setResolveParameterValues", Boolean.TYPE);
            setResolve.invoke(builder, resolveExpression);
            Method setOutput = builder.getClass().getMethod("setConsoleOutput", OutputStream.class);
            setOutput.invoke(builder, this.out);
            Object ctxConfig = builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
            Object factory = loader.loadClass("org.jboss.as.cli.CommandContextFactory").getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Class<?> configClass = loader.loadClass("org.jboss.as.cli.impl.CommandContextConfiguration");
            this.ctx = factory.getClass().getMethod("newCommandContext", configClass).invoke(factory, ctxConfig);
            this.handle = this.ctx.getClass().getMethod("handle", String.class);
            this.handleSafe = this.ctx.getClass().getMethod("handleSafe", String.class);
            this.terminateSession = this.ctx.getClass().getMethod("terminateSession", new Class[0]);
            this.getModelControllerClient = this.ctx.getClass().getMethod("getModelControllerClient", new Class[0]);
            this.bindClient = this.ctx.getClass().getMethod("bindClient", ModelControllerClient.class);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to create the CLIWrapper.", e);
        }
        this.bootLoggingConfiguration = bootLoggingConfiguration;
    }

    public void handle(String command) throws Exception {
        block3: {
            try {
                this.handle.invoke(this.ctx, command);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause == null) break block3;
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw new RuntimeException("Failed to handle command.", cause);
            }
        }
    }

    public void handleSafe(String command) {
        try {
            this.handleSafe.invoke(this.ctx, command);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOGGER.error((Object)"Failed to invoke command.", e);
        }
    }

    public void bindClient(ModelControllerClient client) throws Exception {
        block3: {
            try {
                this.bindClient.invoke(this.ctx, client);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause == null) break block3;
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw new RuntimeException("Failed to bind the client to the CLI context.", cause);
            }
        }
    }

    public String getOutput() {
        return this.out.toString();
    }

    @Override
    public void close() throws Exception {
        try {
            this.terminateSession.invoke(this.ctx, new Object[0]);
        }
        finally {
            if (this.origConfig != null) {
                System.setProperty("jboss.cli.config", this.origConfig);
            } else {
                System.clearProperty("jboss.cli.config");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateBootLoggingConfig() {
        Objects.requireNonNull(this.bootLoggingConfiguration);
        Exception toThrow = null;
        try {
            this.handle("embed-server --jboss-home=" + this.jbossHome + " --std-out=discard");
            ModelControllerClient client = this.getModelControllerClient();
            Path configDir = this.jbossHome.resolve("standalone").resolve("configuration");
            this.bootLoggingConfiguration.generate(configDir, client);
        }
        catch (Exception e) {
            toThrow = e;
        }
        finally {
            try {
                this.handle("stop-embedded-server");
            }
            catch (Exception e) {
                if (toThrow != null) {
                    e.addSuppressed(toThrow);
                }
                toThrow = e;
            }
        }
        if (toThrow != null) {
            throw new RuntimeException("Failed to generate the boot logging configuration.", toThrow);
        }
    }

    private ModelControllerClient getModelControllerClient() throws Exception {
        return (ModelControllerClient)this.getModelControllerClient.invoke(this.ctx, new Object[0]);
    }
}

