/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    private static final Pattern WHITESPACE_IF_NOT_QUOTED = Pattern.compile("(\\S+\"[^\"]+\")|\\S+");

    public static boolean isValidHomeDirectory(Path path) {
        return path != null && Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]) && Files.exists(path.resolve("jboss-modules.jar"), new LinkOption[0]);
    }

    public static List<String> splitArguments(CharSequence arguments) {
        ArrayList<String> args = new ArrayList<String>();
        Matcher m = WHITESPACE_IF_NOT_QUOTED.matcher(arguments);
        while (m.find()) {
            String value = m.group();
            if (value.isEmpty()) continue;
            args.add(value);
        }
        return args;
    }
}

