/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.wildfly.common.Assert;
import org.wildfly.plugin.tools.DeploymentDescription;
import org.wildfly.plugin.tools.util.Assertions;

public class UndeployDescription
implements DeploymentDescription,
Comparable<UndeployDescription> {
    private final String name;
    private final Set<String> serverGroups;
    private boolean failOnMissing;
    private boolean removeContent;

    private UndeployDescription(String name) {
        this.name = name;
        this.serverGroups = new LinkedHashSet<String>();
        this.failOnMissing = false;
        this.removeContent = true;
    }

    public static UndeployDescription of(String name) {
        return new UndeployDescription(Assertions.requiresNotNullOrNotEmptyParameter("name", name));
    }

    public static UndeployDescription of(DeploymentDescription deploymentDescription) {
        Assert.checkNotNullParam("deploymentDescription", deploymentDescription);
        return UndeployDescription.of(deploymentDescription.getName()).addServerGroups(deploymentDescription.getServerGroups());
    }

    public UndeployDescription addServerGroup(String serverGroup) {
        this.serverGroups.add(serverGroup);
        return this;
    }

    public UndeployDescription addServerGroups(String ... serverGroups) {
        return this.addServerGroups(Arrays.asList(serverGroups));
    }

    public UndeployDescription addServerGroups(Collection<String> serverGroups) {
        this.serverGroups.addAll(serverGroups);
        return this;
    }

    @Override
    public Set<String> getServerGroups() {
        return Collections.unmodifiableSet(this.serverGroups);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isFailOnMissing() {
        return this.failOnMissing;
    }

    public UndeployDescription setFailOnMissing(boolean failOnMissing) {
        this.failOnMissing = failOnMissing;
        return this;
    }

    public boolean isRemoveContent() {
        return this.removeContent;
    }

    public UndeployDescription setRemoveContent(boolean removeContent) {
        this.removeContent = removeContent;
        return this;
    }

    @Override
    public int compareTo(UndeployDescription o) {
        return this.name.compareTo(o.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UndeployDescription)) {
            return false;
        }
        UndeployDescription other = (UndeployDescription)obj;
        return Objects.equals(this.name, other.name);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(UndeployDescription.class.getSimpleName());
        result.append('(');
        result.append("name=").append(this.name);
        result.append(", failOnMissing=").append(this.failOnMissing);
        result.append(", removeContent=").append(this.removeContent);
        if (!this.serverGroups.isEmpty()) {
            result.append(", serverGroups=").append(this.serverGroups);
        }
        return result.append(')').toString();
    }
}

