/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.cli.commands;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jboss.as.version.Stability;
import org.jboss.galleon.util.IoUtils;
import org.wildfly.glow.Arguments;
import org.wildfly.glow.FeaturePacks;
import org.wildfly.glow.GlowMessageWriter;
import org.wildfly.glow.GlowSession;
import org.wildfly.glow.HiddenPropertiesAccessor;
import org.wildfly.glow.OutputContent;
import org.wildfly.glow.OutputFormat;
import org.wildfly.glow.ScanArguments;
import org.wildfly.glow.ScanResults;
import org.wildfly.glow.cli.commands.AbstractCommand;
import org.wildfly.glow.error.IdentifiedError;
import org.wildfly.glow.maven.MavenResolver;
import picocli.CommandLine;

@CommandLine.Command(name="scan", sortOptions=true)
public class ScanCommand
extends AbstractCommand {
    private static final String ADD_ADD_ONS_MSG = "@|bold To enable add-ons, add the|@ @|fg(yellow) --add-ons=<list of add-ons>|@ @|bold option to the|@ @|fg(yellow) scan|@ @|bold command|@";
    @CommandLine.Option(names={"-c", "--cloud"})
    Optional<Boolean> cloud;
    @CommandLine.Option(names={"-wp", "--wildfly-preview"})
    Optional<Boolean> wildflyPreview;
    @CommandLine.Option(names={"-s", "--suggest"})
    Optional<Boolean> suggest;
    @CommandLine.Option(names={"--ha"})
    Optional<Boolean> haProfile;
    @CommandLine.Option(names={"-sv", "--server-version"}, paramLabel="<server version>")
    Optional<String> wildflyServerVersion;
    @CommandLine.Option(names={"-di", "--docker-image-name"}, paramLabel="<docker image name>")
    Optional<String> dockerImageName;
    @CommandLine.Option(names={"--add-layers-for-jndi"}, split=",", paramLabel="<layer>")
    Set<String> layersForJndi = new LinkedHashSet<String>();
    @CommandLine.Option(names={"-ao", "--add-ons"}, split=",", paramLabel="<add-on>")
    Set<String> addOns = new LinkedHashSet<String>();
    @CommandLine.Parameters(descriptionKey="deployments")
    List<Path> deployments;
    @CommandLine.Option(names={"--input-feature-packs-file"}, paramLabel="<provisioning file path>")
    Optional<Path> provisioningXml;
    @CommandLine.Option(names={"-p", "--provision"}, paramLabel="<SERVER|BOOTABLE_JAR|DOCKER_IMAGE|PROVISIONING_XML>")
    Optional<OutputFormat> provision;
    @CommandLine.Option(names={"-d", "--output-dir"}, paramLabel="<output directory>")
    Optional<String> provisionOutputDir;
    @CommandLine.Option(names={"-ea", "--exclude-archives-from-scan"}, split=",", paramLabel="<list of nested archive names>")
    Set<String> excludeArchivesFromScan = new HashSet<String>();
    @CommandLine.Option(converter={StabilityConverter.class}, names={"--stability-level", "-sl"}, paramLabel="<default|community|preview|experimental>")
    Optional<Stability> stability;

    @Override
    public Integer call() throws Exception {
        HiddenPropertiesAccessor hiddenPropertiesAccessor = new HiddenPropertiesAccessor();
        boolean compact = Boolean.parseBoolean(hiddenPropertiesAccessor.getProperty("compact"));
        if (!compact) {
            this.print("Wildfly Glow is scanning...");
        }
        ScanArguments.Builder builder = Arguments.scanBuilder();
        if (this.cloud.orElse(false).booleanValue()) {
            builder.setExecutionContext("cloud");
        }
        if (this.haProfile.orElse(false).booleanValue()) {
            HashSet<String> profiles = new HashSet<String>();
            profiles.add("ha");
            builder.setExecutionProfiles(profiles);
        }
        if (!this.layersForJndi.isEmpty()) {
            builder.setJndiLayers(this.layersForJndi);
        }
        if (this.suggest.orElse(false).booleanValue()) {
            builder.setSuggest(true);
        }
        if (this.wildflyPreview.orElse(false).booleanValue()) {
            builder.setTechPreview(true);
        }
        if (this.wildflyServerVersion.isPresent()) {
            builder.setVersion(this.wildflyServerVersion.get());
        }
        builder.setVerbose(this.verbose);
        if (!this.addOns.isEmpty()) {
            builder.setUserEnabledAddOns(this.addOns);
        }
        if (this.deployments != null && !this.deployments.isEmpty()) {
            builder.setBinaries(this.deployments);
        }
        if (this.provisioningXml.isPresent()) {
            builder.setProvisoningXML(this.provisioningXml.get());
        }
        if (this.provision.isPresent()) {
            if (OutputFormat.BOOTABLE_JAR.equals((Object)this.provision.get()) && this.cloud.orElse(false).booleanValue()) {
                throw new Exception("Can't produce a Bootable JAR for cloud. Use the --provision=SERVER option for cloud.");
            }
            if (OutputFormat.DOCKER_IMAGE.equals((Object)this.provision.get()) && !this.cloud.orElse(false).booleanValue()) {
                throw new Exception("Can't produce a Docker image if cloud is not enabled. Use the --cloud option.");
            }
            builder.setOutput(this.provision.get());
        }
        builder.setExcludeArchivesFromScan(this.excludeArchivesFromScan);
        if (this.stability.isPresent()) {
            builder.setStability(this.stability.get());
        }
        if (this.dockerImageName.isPresent() && this.provision.isPresent() && !OutputFormat.DOCKER_IMAGE.equals((Object)this.provision.get())) {
            throw new Exception("Can only set a docker image name when provisioning a docker image. Remove the --docker-image-name option");
        }
        ScanResults scanResults = GlowSession.scan(MavenResolver.newMavenResolver(), builder.build(), GlowMessageWriter.DEFAULT);
        scanResults.outputInformation();
        if (this.provision.isEmpty()) {
            if (!compact) {
                if (this.suggest.orElse(false).booleanValue()) {
                    if (!scanResults.getSuggestions().getPossibleAddOns().isEmpty() && this.addOns.isEmpty()) {
                        this.print(ADD_ADD_ONS_MSG);
                    }
                    if (!scanResults.getSuggestions().getPossibleProfiles().isEmpty()) {
                        this.print("@|bold To enable the HA profile, add the|@ @|fg(yellow) %s|@ @|bold option to the|@ @|fg(yellow) %s|@ @|bold command|@", "--ha", "scan");
                    }
                }
                if (scanResults.getErrorSession().hasErrors()) {
                    if (!this.suggest.orElse(false).booleanValue()) {
                        boolean hasAddOn = false;
                        for (IdentifiedError err : scanResults.getErrorSession().getErrors()) {
                            if (err.getPossibleAddons().isEmpty()) continue;
                            hasAddOn = true;
                            break;
                        }
                        if (hasAddOn) {
                            System.out.println(CommandLine.Help.Ansi.AUTO.string(ADD_ADD_ONS_MSG));
                        }
                    }
                    this.print("@|bold Some errors have been reported. You should fix them prior provisioning a server with the|@ @|fg(yellow) --provision|@ @|bold option of the|@ @|fg(yellow) scan|@ @|bold command|@");
                } else {
                    this.print("@|bold If you had included a|@ @|fg(yellow) --provision|@ @|bold option to the|@ @|fg(yellow) scan|@ @|bold command, after outputting this report, WildFly Glow will continue on to provisioning your WildFly server, bootable jar or Docker image.|@");
                }
            }
        } else {
            this.print();
            String vers = this.wildflyServerVersion.orElse(null) == null ? FeaturePacks.getLatestVersion() : this.wildflyServerVersion.get();
            Path target = Paths.get(this.provisionOutputDir.orElse("server-" + vers), new String[0]);
            IoUtils.recursiveDelete(target);
            switch (this.provision.get()) {
                case BOOTABLE_JAR: {
                    if (this.provisionOutputDir.isEmpty()) {
                        target = Paths.get("", new String[0]);
                    }
                    this.print("@|bold Building WildFly Bootable JAR file...|@");
                    break;
                }
                case PROVISIONING_XML: {
                    this.print("@|bold Generating Galleon provisioning configuration file...|@");
                    break;
                }
                case SERVER: {
                    this.print("@|bold Provisioning server...|@", target);
                    break;
                }
                case DOCKER_IMAGE: {
                    this.print("@|bold Generating docker image...|@");
                }
            }
            OutputContent content = scanResults.outputConfig(target, this.dockerImageName.orElse(null));
            Path base = Paths.get("", new String[0]).toAbsolutePath();
            for (OutputContent.OutputFile f : content.getFiles().keySet()) {
                Path rel = base.relativize(content.getFiles().get((Object)f));
                block6 : switch (f) {
                    case BOOTABLE_JAR_FILE: {
                        this.print("@|bold Bootable JAR build DONE.|@");
                        this.print("@|bold To run the jar call: 'java -jar " + rel + "'|@");
                        break;
                    }
                    case DOCKER_FILE: {
                        this.print("@|bold Image generation DONE.|@.");
                        this.print("@|bold Docker file generated in %s|@.", rel);
                        break;
                    }
                    case ENV_FILE: {
                        this.print("@|bold The file " + rel + " contains the list of environment variables that you must set prior to start the server.|@");
                        switch (this.provision.get()) {
                            case SERVER: {
                                this.print("@|bold Export the suggested env variables for the server to take them into account.|@");
                                break block6;
                            }
                            case BOOTABLE_JAR: {
                                this.print("@|bold Export the suggested env variables for the bootable JAR to take them into account.|@");
                                break block6;
                            }
                            case DOCKER_IMAGE: {
                                this.print("@|bold For each env variable add `-e <env name>=<env value>` to the `docker run` command.|@");
                            }
                        }
                        break;
                    }
                    case PROVISIONING_XML_FILE: {
                        this.print("@|bold Generation DONE.|@");
                        this.print("@|bold Galleon Provisioning configuration is located in " + rel + " file|@");
                        break;
                    }
                    case SERVER_DIR: {
                        this.print("@|bold Provisioning DONE.|@");
                        if (this.cloud.orElse(false).booleanValue()) {
                            this.print("@|bold To run the server call: 'JBOSS_HOME=" + rel + " sh " + rel + "/bin/openshift-launch.sh'|@");
                            break;
                        }
                        this.print("@|bold To run the server call: 'sh " + rel + "/bin/standalone.sh'|@");
                    }
                }
            }
            if (content.getDockerImageName() != null) {
                this.print("@|bold To run the image call: 'docker run " + content.getDockerImageName() + "'|@");
            }
        }
        return 0;
    }

    private static class StabilityConverter
    implements CommandLine.ITypeConverter<Stability> {
        private StabilityConverter() {
        }

        @Override
        public Stability convert(String value) throws Exception {
            return Stability.fromString(value);
        }
    }
}

