/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.cli.commands;

import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.wildfly.glow.FeaturePacks;
import org.wildfly.glow.Layer;
import org.wildfly.glow.LayerMapping;
import org.wildfly.glow.cli.commands.AbstractCommand;
import org.wildfly.glow.cli.commands.CommandsUtils;
import picocli.CommandLine;

@CommandLine.Command(name="show-configuration", sortOptions=true)
public class ShowConfigurationCommand
extends AbstractCommand {
    @CommandLine.Option(names={"-c", "--cloud"})
    Optional<Boolean> cloud;
    @CommandLine.Option(names={"-wp", "--wildfly-preview"})
    Optional<Boolean> wildflyPreview;
    @CommandLine.Option(names={"-sv", "--server-version"}, paramLabel="<server version>")
    Optional<String> wildflyServerVersion;
    @CommandLine.Option(names={"--input-feature-packs-file"}, paramLabel="<provisioning file path>")
    Optional<Path> provisioningXml;

    @Override
    public Integer call() throws Exception {
        this.print("Wildfly Glow is retrieving known provisioning configuration...");
        String context = "bare-metal";
        if (this.cloud.orElse(false).booleanValue()) {
            context = "cloud";
        }
        final String finalContext = context;
        final boolean isLatest = this.wildflyServerVersion.isEmpty();
        final String vers = this.wildflyServerVersion.isPresent() ? this.wildflyServerVersion.get() : FeaturePacks.getLatestVersion();
        CommandsUtils.ProvisioningConsumer consumer = new CommandsUtils.ProvisioningConsumer(){

            @Override
            public void consume(GalleonProvisioningConfig provisioning, Map<String, Layer> all, LayerMapping mapping, Map<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>> fpDependencies) throws Exception {
                String configStr = ShowConfigurationCommand.dumpConfiguration(fpDependencies, finalContext, vers, all, mapping, provisioning, isLatest, ShowConfigurationCommand.this.wildflyPreview.orElse(false));
                ShowConfigurationCommand.this.print(configStr);
            }
        };
        CommandsUtils.buildProvisioning(consumer, context, this.provisioningXml.orElse(null), this.wildflyServerVersion.isEmpty(), context, this.wildflyPreview.orElse(false));
        return 0;
    }

    private static String dumpConfiguration(Map<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>> fpDependencies, String context, String serverVersion, Map<String, Layer> allLayers, LayerMapping mapping, GalleonProvisioningConfig config, boolean isLatest, boolean techPreview) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("Execution context: ").append(context).append("\n");
        builder.append("Server version: ").append(serverVersion).append(isLatest ? " (latest)" : "").append("\n");
        builder.append("Tech Preview: ").append(techPreview).append("\n");
        LinkedHashSet<FeaturePackLocation.ProducerSpec> topLevel = new LinkedHashSet<FeaturePackLocation.ProducerSpec>();
        for (GalleonFeaturePackConfig fp : config.getFeaturePackDeps()) {
            topLevel.add(fp.getLocation().getProducer());
        }
        for (GalleonFeaturePackConfig fp : config.getFeaturePackDeps()) {
            builder.append("\nFeature-pack: ").append("@|bold ").append(fp.getLocation().getFPID()).append("|@\n");
            builder.append("Contained layers: ");
            TreeSet<String> layers = new TreeSet<String>();
            Set<FeaturePackLocation.ProducerSpec> deps = fpDependencies.get(fp.getLocation().getFPID());
            for (Layer l : allLayers.values()) {
                if (l.getFeaturePacks().contains(fp.getLocation().getFPID())) {
                    layers.add(l.getName());
                }
                if (deps == null) continue;
                for (FeaturePackLocation.ProducerSpec dep : deps) {
                    if (topLevel.contains(dep)) continue;
                    for (FeaturePackLocation.FPID fpid : l.getFeaturePacks()) {
                        if (!fpid.getProducer().equals(dep)) continue;
                        layers.add(l.getName());
                    }
                }
            }
            topLevel.addAll(deps);
            builder.append(layers).append("\n");
        }
        return builder.toString();
    }
}

