/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.cli;

import java.util.Arrays;
import org.wildfly.glow.cli.ExecutionExceptionHandler;
import org.wildfly.glow.cli.commands.CompletionCommand;
import org.wildfly.glow.cli.commands.GoOfflineCommand;
import org.wildfly.glow.cli.commands.MainCommand;
import org.wildfly.glow.cli.commands.ScanCommand;
import org.wildfly.glow.cli.commands.ShowAddOnsCommand;
import org.wildfly.glow.cli.commands.ShowConfigurationCommand;
import org.wildfly.glow.cli.commands.ShowServerVersionsCommand;
import picocli.CommandLine;

public class GlowCLI {
    public static void main(String[] args) throws Exception {
        MainCommand command = new MainCommand();
        try {
            CommandLine commandLine = new CommandLine(command);
            commandLine.addSubcommand(new ScanCommand());
            commandLine.addSubcommand(new ShowAddOnsCommand());
            commandLine.addSubcommand(new ShowServerVersionsCommand());
            commandLine.addSubcommand(new ShowConfigurationCommand());
            commandLine.addSubcommand(new GoOfflineCommand());
            commandLine.addSubcommand(new CompletionCommand());
            commandLine.setUsageHelpAutoWidth(true);
            boolean isVerbose = Arrays.stream(args).anyMatch(s -> s.equals("-vv") || s.equals("--verbose"));
            commandLine.setExecutionExceptionHandler(new ExecutionExceptionHandler(isVerbose, command));
            int exitCode = commandLine.execute(args);
            System.exit(exitCode);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
    }
}

