/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;
import org.wildfly.glow.FeaturePacks;
import org.wildfly.glow.GlowMessageWriter;
import org.wildfly.glow.GlowSession;
import org.wildfly.glow.Layer;
import org.wildfly.glow.LayerMapping;
import org.wildfly.glow.Utils;

public class ProvisioningUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void traverseProvisioning(ProvisioningConsumer consumer, String executionContext, Path provisioningXML, boolean isLatest, String wildflyServerVersion, boolean wildflyPreview, MavenRepoManager resolver) throws Exception {
        UniverseResolver universeResolver = ((UniverseResolver.Builder)UniverseResolver.builder().addArtifactResolver(resolver)).build();
        GalleonBuilder provider = new GalleonBuilder();
        provider.addArtifactResolver(resolver);
        String vers = wildflyServerVersion != null ? wildflyServerVersion : FeaturePacks.getLatestVersion();
        Provisioning provisioning = null;
        try {
            GalleonProvisioningConfig config = Utils.buildOfflineProvisioningConfig(provider, GlowMessageWriter.DEFAULT);
            if (config == null) {
                if (provisioningXML == null) {
                    provisioningXML = FeaturePacks.getFeaturePacks(vers, executionContext, wildflyPreview);
                }
                provisioning = provider.newProvisioningBuilder(provisioningXML).build();
                config = provisioning.loadProvisioningConfig(provisioningXML);
            } else {
                provisioning = provider.newProvisioningBuilder(config).build();
            }
            HashMap<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>> fpDependencies = new HashMap<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>>();
            Map<String, Layer> all = Utils.getAllLayers(config, universeResolver, provisioning, fpDependencies);
            LayerMapping mapping = Utils.buildMapping(all, Collections.emptySet());
            consumer.consume(config, all, mapping, fpDependencies);
        }
        finally {
            IoUtils.recursiveDelete(GlowSession.OFFLINE_CONTENT);
            if (provisioning != null) {
                provisioning.close();
            }
        }
    }

    public static interface ProvisioningConsumer {
        public void consume(GalleonProvisioningConfig var1, Map<String, Layer> var2, LayerMapping var3, Map<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>> var4) throws Exception;
    }
}

